/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldcache.backend.kiwi;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import java.sql.SQLException;
import org.apache.marmotta.kiwi.sail.KiWiStore;
import org.apache.marmotta.ldcache.api.LDCachingBackend;
import org.apache.marmotta.ldcache.api.LDCachingConnection;
import org.apache.marmotta.ldcache.backend.kiwi.persistence.LDCachingKiWiPersistence;
import org.apache.marmotta.ldcache.backend.kiwi.repository.LDCachingSailRepositoryConnection;
import org.apache.marmotta.ldcache.backend.kiwi.sail.LDCachingKiWiSail;
import org.apache.marmotta.ldcache.backend.kiwi.sail.LDCachingKiWiSailConnection;
import org.apache.marmotta.ldcache.model.CacheEntry;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDCachingKiWiBackend
implements LDCachingBackend {
    private static Logger log = LoggerFactory.getLogger(LDCachingKiWiBackend.class);
    private String cacheContext;
    private LDCachingKiWiSail sail;
    private LDCachingKiWiPersistence persistence;
    private SailRepository repository;

    public LDCachingKiWiBackend(KiWiStore store, String cacheContext) {
        this.cacheContext = cacheContext;
        this.sail = new LDCachingKiWiSail(store);
        this.repository = new SailRepository((Sail)this.sail);
        this.persistence = new LDCachingKiWiPersistence(store.getPersistence());
    }

    public LDCachingConnection getCacheConnection(String resource) throws RepositoryException {
        try {
            LDCachingKiWiSailConnection sailConnection = this.sail.getConnection();
            return new LDCachingSailRepositoryConnection(this.repository, sailConnection, this.cacheContext);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public CloseableIteration<CacheEntry, RepositoryException> listExpiredEntries() throws RepositoryException {
        try {
            final LDCachingKiWiSailConnection sailConnection = this.sail.getConnection();
            sailConnection.begin();
            return new ExceptionConvertingIteration<CacheEntry, RepositoryException>(sailConnection.listExpired()){

                protected RepositoryException convert(Exception e) {
                    return new RepositoryException((Throwable)e);
                }

                protected void handleClose() throws RepositoryException {
                    super.handleClose();
                    try {
                        sailConnection.commit();
                        sailConnection.close();
                    }
                    catch (SailException ex) {
                        throw new RepositoryException((Throwable)ex);
                    }
                }
            };
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public CloseableIteration<CacheEntry, RepositoryException> listCacheEntries() throws RepositoryException {
        try {
            final LDCachingKiWiSailConnection sailConnection = this.sail.getConnection();
            sailConnection.begin();
            return new ExceptionConvertingIteration<CacheEntry, RepositoryException>(sailConnection.listAll()){

                protected RepositoryException convert(Exception e) {
                    return new RepositoryException((Throwable)e);
                }

                protected void handleClose() throws RepositoryException {
                    super.handleClose();
                    try {
                        sailConnection.commit();
                        sailConnection.close();
                    }
                    catch (SailException ex) {
                        throw new RepositoryException((Throwable)ex);
                    }
                }
            };
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public LDCachingKiWiPersistence getPersistence() {
        return this.persistence;
    }

    public void initialize() {
        try {
            this.repository.initialize();
        }
        catch (RepositoryException e) {
            log.error("error initializing secondary repository", (Throwable)e);
        }
        try {
            this.persistence.initDatabase();
        }
        catch (SQLException e) {
            log.error("error initializing LDCache database tables", (Throwable)e);
        }
        this.repository.getValueFactory().createURI(this.cacheContext);
    }

    public void shutdown() {
        try {
            this.repository.shutDown();
        }
        catch (RepositoryException e) {
            log.error("error shutting down secondary repository", (Throwable)e);
        }
    }
}

