/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.sail;

import com.google.common.collect.MapMaker;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.LocaleUtils;
import org.apache.marmotta.commons.sesame.model.LiteralCommons;
import org.apache.marmotta.commons.util.DateUtils;
import org.apache.marmotta.kiwi.model.caching.IntArray;
import org.apache.marmotta.kiwi.model.rdf.KiWiAnonResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiBooleanLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiDateLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiDoubleLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiIntLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiStringLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.persistence.KiWiConnection;
import org.apache.marmotta.kiwi.sail.KiWiStore;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiValueFactory
implements ValueFactory {
    private static Logger log = LoggerFactory.getLogger(KiWiValueFactory.class);
    private Random anonIdGenerator;
    private ConcurrentMap<IntArray, Statement> tripleRegistry;
    private KiWiStore store;
    private ReentrantLock nodeLock;
    private ReentrantLock tripleLock;
    private ConcurrentMap<String, ReentrantLock> resourceLocks;
    private ConcurrentMap<Object, ReentrantLock> literalLocks;
    private String defaultContext;

    public KiWiValueFactory(KiWiStore store, String defaultContext) {
        this.nodeLock = store.nodeLock;
        this.tripleLock = store.tripleLock;
        this.resourceLocks = new MapMaker().weakKeys().weakValues().makeMap();
        this.literalLocks = new MapMaker().weakKeys().weakValues().makeMap();
        this.anonIdGenerator = new Random();
        this.tripleRegistry = store.tripleRegistry;
        this.store = store;
        this.defaultContext = defaultContext;
    }

    protected KiWiConnection aqcuireConnection() {
        try {
            KiWiConnection connection = this.store.getPersistence().getConnection();
            return connection;
        }
        catch (SQLException ex) {
            log.error("could not acquire database connection", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected void releaseConnection(KiWiConnection con) {
        try {
            con.commit();
            con.close();
        }
        catch (SQLException ex) {
            log.error("could not release database connection", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReentrantLock acquireResourceLock(String uri) {
        ReentrantLock lock;
        ConcurrentMap<String, ReentrantLock> concurrentMap = this.resourceLocks;
        synchronized (concurrentMap) {
            lock = (ReentrantLock)this.resourceLocks.get(uri);
            if (lock == null) {
                lock = new ReentrantLock();
                this.resourceLocks.put(uri, lock);
            }
        }
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReentrantLock acquireLiteralLock(Object value) {
        ReentrantLock lock;
        ConcurrentMap<Object, ReentrantLock> concurrentMap = this.literalLocks;
        synchronized (concurrentMap) {
            lock = (ReentrantLock)this.literalLocks.get(value);
            if (lock == null) {
                lock = new ReentrantLock();
                this.literalLocks.put(value, lock);
            }
        }
        lock.lock();
        return lock;
    }

    public BNode createBNode() {
        return this.createBNode(Long.toHexString(System.currentTimeMillis()) + Integer.toHexString(this.anonIdGenerator.nextInt(1000)));
    }

    public URI createURI(String uri) {
        ReentrantLock lock = this.acquireResourceLock(uri);
        KiWiConnection connection = this.aqcuireConnection();
        try {
            KiWiUriResource result = connection.loadUriResource(uri);
            if (result == null) {
                result = new KiWiUriResource(uri);
                connection.storeNode(result);
            }
            KiWiUriResource kiWiUriResource = result;
            return kiWiUriResource;
        }
        catch (SQLException e) {
            log.error("database error, could not load URI resource", (Throwable)e);
            throw new IllegalStateException("database error, could not load URI resource", e);
        }
        finally {
            this.releaseConnection(connection);
            lock.unlock();
        }
    }

    public URI createURI(String namespace, String localName) {
        return this.createURI(namespace + localName);
    }

    public BNode createBNode(String nodeID) {
        this.nodeLock.lock();
        KiWiConnection connection = this.aqcuireConnection();
        try {
            KiWiAnonResource result = connection.loadAnonResource(nodeID);
            if (result == null) {
                result = new KiWiAnonResource(nodeID);
                connection.storeNode(result);
            }
            KiWiAnonResource kiWiAnonResource = result;
            return kiWiAnonResource;
        }
        catch (SQLException e) {
            log.error("database error, could not load anonymous resource", (Throwable)e);
            throw new IllegalStateException("database error, could not load anonymous resource", e);
        }
        finally {
            this.releaseConnection(connection);
            this.nodeLock.unlock();
        }
    }

    public Literal createLiteral(Date date) {
        return this.createLiteral(date, null, LiteralCommons.getXSDType(Date.class));
    }

    public Literal createLiteral(Object object) {
        if (object instanceof XMLGregorianCalendar) {
            return this.createLiteral((XMLGregorianCalendar)object);
        }
        return this.createLiteral(object, null, null);
    }

    public Literal createLiteral(String label) {
        return this.createLiteral(label, null, LiteralCommons.getXSDType(String.class));
    }

    public Literal createLiteral(String label, String language) {
        return this.createLiteral(label, language, LiteralCommons.getRDFLangStringType());
    }

    public Literal createLiteral(String label, URI datatype) {
        return this.createLiteral(label, null, datatype.stringValue());
    }

    private <T> KiWiLiteral createLiteral(T value, String lang, String type) {
        if (lang != null) {
            type = LiteralCommons.getRDFLangStringType();
        } else if (type == null) {
            type = LiteralCommons.getXSDType(value.getClass());
        }
        KiWiLiteral result = null;
        KiWiUriResource rtype = (KiWiUriResource)this.createURI(type);
        Locale locale = lang != null ? LocaleUtils.toLocale((String)lang) : null;
        ReentrantLock lock = this.acquireLiteralLock(value);
        KiWiConnection connection = this.aqcuireConnection();
        try {
            if (value instanceof Date || type.equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
                Date dvalue = value instanceof Date ? (Date)value : DateUtils.parseDate((String)value.toString());
                result = connection.loadLiteral(dvalue);
                if (result == null) {
                    result = new KiWiDateLiteral(dvalue, rtype);
                }
            } else if (Integer.class.equals(value.getClass()) || Integer.TYPE.equals(value.getClass()) || Long.class.equals(value.getClass()) || Long.TYPE.equals(value.getClass()) || type.equals("http://www.w3.org/2001/XMLSchema#integer") || type.equals("http://www.w3.org/2001/XMLSchema#long")) {
                long ivalue = 0L;
                ivalue = Integer.class.equals(value.getClass()) || Integer.TYPE.equals(value.getClass()) ? (long)((Integer)value).intValue() : (Long.class.equals(value.getClass()) || Long.TYPE.equals(value.getClass()) ? (Long)value : Long.parseLong(value.toString()));
                result = connection.loadLiteral(ivalue);
                if (result == null) {
                    result = new KiWiIntLiteral(ivalue, rtype);
                }
            } else if (Double.class.equals(value.getClass()) || Double.TYPE.equals(value.getClass()) || Float.class.equals(value.getClass()) || Float.TYPE.equals(value.getClass()) || type.equals("http://www.w3.org/2001/XMLSchema#double") || type.equals("http://www.w3.org/2001/XMLSchema#float")) {
                double dvalue = 0.0;
                dvalue = Float.class.equals(value.getClass()) || Float.TYPE.equals(value.getClass()) ? (double)((Float)value).floatValue() : (Double.class.equals(value.getClass()) || Double.TYPE.equals(value.getClass()) ? (Double)value : Double.parseDouble(value.toString()));
                result = connection.loadLiteral(dvalue);
                if (result == null) {
                    result = new KiWiDoubleLiteral(dvalue, rtype);
                }
            } else if (Boolean.class.equals(value.getClass()) || Boolean.TYPE.equals(value.getClass()) || type.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
                boolean bvalue = false;
                bvalue = Boolean.class.equals(value.getClass()) || Boolean.TYPE.equals(value.getClass()) ? (Boolean)value : Boolean.parseBoolean(value.toString());
                result = connection.loadLiteral(bvalue);
                if (result == null) {
                    result = new KiWiBooleanLiteral(bvalue, rtype);
                }
            } else {
                result = connection.loadLiteral(value.toString(), lang, rtype);
                if (result == null) {
                    result = new KiWiStringLiteral(value.toString(), locale, rtype);
                }
            }
            if (result.getId() == null) {
                connection.storeNode(result);
            }
            KiWiDateLiteral bvalue = result;
            return bvalue;
        }
        catch (SQLException e) {
            log.error("database error, could not load literal", (Throwable)e);
            throw new IllegalStateException("database error, could not load literal", e);
        }
        finally {
            this.releaseConnection(connection);
            lock.unlock();
        }
    }

    public Literal createLiteral(boolean value) {
        return this.createLiteral(value, null, LiteralCommons.getXSDType(Boolean.class));
    }

    public Literal createLiteral(byte value) {
        return this.createLiteral(Integer.valueOf(value), null, LiteralCommons.getXSDType(Byte.class));
    }

    public Literal createLiteral(short value) {
        return this.createLiteral(Integer.valueOf(value), null, LiteralCommons.getXSDType(Short.class));
    }

    public Literal createLiteral(int value) {
        return this.createLiteral(value, null, LiteralCommons.getXSDType(Integer.class));
    }

    public Literal createLiteral(long value) {
        return this.createLiteral(value, null, LiteralCommons.getXSDType(Long.class));
    }

    public Literal createLiteral(float value) {
        return this.createLiteral(Float.valueOf(value), null, LiteralCommons.getXSDType(Float.class));
    }

    public Literal createLiteral(double value) {
        return this.createLiteral(value, null, LiteralCommons.getXSDType(Double.class));
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        Date value = calendar.toGregorianCalendar().getTime();
        return this.createLiteral(value, null, LiteralCommons.getXSDType(Date.class));
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return this.createStatement(subject, predicate, object, (Resource)this.createURI(this.defaultContext));
    }

    public Statement createStatement(Resource subject, URI predicate, Value object, Resource context) {
        return new ContextStatementImpl(subject, predicate, object, context);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object, Resource context, KiWiConnection connection) {
        IntArray cacheKey = IntArray.createSPOCKey((Resource)subject, (URI)predicate, (Value)object, (Resource)context);
        Statement result = (Statement)this.tripleRegistry.get(cacheKey);
        try {
            if (result == null || ((KiWiTriple)result).isDeleted().booleanValue()) {
                KiWiResource kcontext;
                KiWiNode kobject;
                KiWiUriResource kpredicate;
                KiWiResource ksubject = this.convert(subject);
                List triples = connection.listTriples(ksubject, kpredicate = this.convert(predicate), kobject = this.convert(object), kcontext = this.convert(context), true).asList();
                if (triples.size() == 1) {
                    result = (Statement)triples.get(0);
                } else {
                    result = new KiWiTriple(ksubject, kpredicate, kobject, kcontext);
                    ((KiWiTriple)result).setMarkedForReasoning(true);
                }
                this.tripleRegistry.put(cacheKey, result);
            }
            return result;
        }
        catch (SQLException e) {
            log.error("database error, could not load triple", (Throwable)e);
            throw new IllegalStateException("database error, could not load triple", e);
        }
        catch (RepositoryException e) {
            log.error("database error, could not load triple", (Throwable)e);
            throw new IllegalStateException("database error, could not load triple", e);
        }
    }

    public KiWiResource convert(Resource r) {
        return (KiWiResource)this.convert((Value)r);
    }

    public KiWiUriResource convert(URI r) {
        return (KiWiUriResource)this.convert((Value)r);
    }

    public KiWiNode convert(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof KiWiNode) {
            return (KiWiNode)value;
        }
        if (value instanceof URI) {
            return (KiWiUriResource)this.createURI(value.stringValue());
        }
        if (value instanceof BNode) {
            return (KiWiAnonResource)this.createBNode(value.stringValue());
        }
        if (value instanceof Literal) {
            Literal l = (Literal)value;
            return this.createLiteral(l.getLabel(), l.getLanguage(), l.getDatatype() != null ? l.getDatatype().stringValue() : null);
        }
        throw new IllegalArgumentException("the value passed as argument does not have the correct type");
    }
}

