/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.sail;

import com.google.common.collect.MapMaker;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.marmotta.kiwi.model.caching.IntArray;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.KiWiPersistence;
import org.apache.marmotta.kiwi.sail.KiWiSailConnection;
import org.apache.marmotta.kiwi.sail.KiWiValueFactory;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.NotifyingSailBase;

public class KiWiStore
extends NotifyingSailBase {
    private KiWiValueFactory repositoryValueFactory;
    private KiWiPersistence persistence;
    private String defaultContext;
    private String inferredContext;
    private boolean initialized = false;
    protected ReentrantLock nodeLock;
    protected ReentrantLock tripleLock;
    protected ConcurrentMap<IntArray, Statement> tripleRegistry;

    public KiWiStore(KiWiPersistence persistence, String defaultContext, String inferredContext) {
        this.persistence = persistence;
        this.defaultContext = defaultContext;
        this.nodeLock = new ReentrantLock();
        this.tripleLock = new ReentrantLock();
        this.inferredContext = inferredContext;
        this.tripleRegistry = new MapMaker().weakValues().makeMap();
    }

    public KiWiStore(String name, String jdbcUrl, String db_user, String db_password, KiWiDialect dialect, String defaultContext, String inferredContext) {
        this(new KiWiPersistence(name, jdbcUrl, db_user, db_password, dialect), defaultContext, inferredContext);
    }

    protected void initializeInternal() throws SailException {
        try {
            this.persistence.initDatabase();
            this.persistence.initialise();
            this.initialized = true;
        }
        catch (SQLException e) {
            throw new SailException("database error while initialising database", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public String getInferredContext() {
        return this.inferredContext;
    }

    public KiWiPersistence getPersistence() {
        return this.persistence;
    }

    protected KiWiSailConnection getConnectionInternal() throws SailException {
        return new KiWiSailConnection(this);
    }

    protected void shutDownInternal() throws SailException {
        this.closeValueFactory();
        this.persistence.shutdown();
    }

    public void closeValueFactory() {
        if (this.repositoryValueFactory != null) {
            this.repositoryValueFactory = null;
        }
    }

    public boolean isWritable() throws SailException {
        return true;
    }

    public ValueFactory getValueFactory() {
        if (this.repositoryValueFactory == null) {
            this.repositoryValueFactory = new KiWiValueFactory(this, this.defaultContext);
        }
        return this.repositoryValueFactory;
    }
}

