/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.sail;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.UnionIteration;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.marmotta.kiwi.model.rdf.KiWiNamespace;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.persistence.KiWiConnection;
import org.apache.marmotta.kiwi.sail.KiWiStore;
import org.apache.marmotta.kiwi.sail.KiWiValueFactory;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.openrdf.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiSailConnection
extends NotifyingSailConnectionBase
implements InferencerConnection {
    private static final Logger log = LoggerFactory.getLogger(KiWiSailConnection.class);
    protected KiWiConnection databaseConnection;
    private String defaultContext;
    private String inferredContext;
    private KiWiValueFactory valueFactory;
    private KiWiStore store;
    private boolean triplesAdded;
    private boolean triplesRemoved;
    private HashSet<Long> deletedStatementsLog;

    public KiWiSailConnection(KiWiStore sailBase) throws SailException {
        super((SailBase)sailBase);
        this.store = sailBase;
        try {
            this.databaseConnection = sailBase.getPersistence().getConnection();
            this.defaultContext = sailBase.getDefaultContext();
            this.inferredContext = sailBase.getInferredContext();
            this.valueFactory = (KiWiValueFactory)sailBase.getValueFactory();
        }
        catch (SQLException e) {
            throw new SailException("error establishing database connection", (Throwable)e);
        }
    }

    public KiWiConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.addStatementInternal(subj, pred, obj, false, contexts);
    }

    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        return this.addStatementInternal(subj, pred, obj, true, new Resource[]{this.valueFactory.createURI(this.inferredContext)}).size() > 0;
    }

    public KiWiTriple addInferredStatement(Resource subj, URI pred, Value obj) throws SailException {
        return this.addStatementInternal(subj, pred, obj, true, new Resource[]{this.valueFactory.createURI(this.inferredContext)}).iterator().next();
    }

    public Set<KiWiTriple> addStatementInternal(Resource subj, URI pred, Value obj, boolean inferred, Resource ... contexts) throws SailException {
        try {
            HashSet<Object> contextSet = new HashSet<Object>();
            for (Resource ctx : contexts) {
                if (ctx == null) continue;
                contextSet.add(ctx);
            }
            if (contextSet.size() == 0) {
                contextSet.add(this.valueFactory.createURI(this.defaultContext));
            }
            KiWiResource ksubj = this.valueFactory.convert(subj);
            KiWiUriResource kpred = this.valueFactory.convert(pred);
            KiWiNode kobj = this.valueFactory.convert(obj);
            HashSet<KiWiTriple> added = new HashSet<KiWiTriple>();
            for (Resource resource : contextSet) {
                KiWiResource kcontext = this.valueFactory.convert(resource);
                KiWiTriple triple = (KiWiTriple)this.valueFactory.createStatement(ksubj, kpred, kobj, kcontext, this.databaseConnection);
                triple.setInferred(inferred);
                if (triple.getId() == null) {
                    this.databaseConnection.storeTriple(triple);
                    this.triplesAdded = true;
                    this.notifyStatementAdded(triple);
                } else if (this.deletedStatementsLog.contains(triple.getId())) {
                    this.databaseConnection.undeleteTriple(triple);
                    this.triplesAdded = true;
                    this.notifyStatementAdded(triple);
                }
                added.add(triple);
            }
            return added;
        }
        catch (SQLException ex) {
            log.error(String.format("Could not persist rdf-statement (%s %s %s)", subj, pred, obj), (Throwable)ex);
            throw new SailException("database error while storing statement", (Throwable)ex);
        }
    }

    protected void closeInternal() throws SailException {
        try {
            this.databaseConnection.close();
        }
        catch (SQLException e) {
            throw new SailException("database error while closing connection", (Throwable)e);
        }
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        if (!((tupleExpr = tupleExpr.clone()) instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        try {
            KiWiTripleSource tripleSource = new KiWiTripleSource(this, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer((EvaluationStrategy)strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer((EvaluationStatistics)new KiWiEvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            return strategy.evaluate(tupleExpr, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        try {
            return new ExceptionConvertingIteration<Resource, SailException>(this.databaseConnection.listContexts()){

                protected SailException convert(Exception e) {
                    return new SailException("database error while iterating over result set", (Throwable)e);
                }
            };
        }
        catch (SQLException e) {
            throw new SailException("database error while listing contexts", (Throwable)e);
        }
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, final boolean includeInferred, Resource ... contexts) throws SailException {
        final KiWiResource rsubj = this.valueFactory.convert(subj);
        final KiWiUriResource rpred = this.valueFactory.convert(pred);
        final KiWiNode robj = this.valueFactory.convert(obj);
        HashSet contextSet = new HashSet();
        contextSet.addAll(Lists.transform(Arrays.asList(contexts), (Function)new Function<Resource, KiWiResource>(){

            public KiWiResource apply(Resource input) {
                return KiWiSailConnection.this.valueFactory.convert(input);
            }
        }));
        HashSet<DelayedIteration> iterations = new HashSet<DelayedIteration>();
        if (contextSet.size() > 0) {
            for (final KiWiResource context : contextSet) {
                iterations.add(new DelayedIteration<Statement, RepositoryException>(){

                    protected Iteration<? extends Statement, ? extends RepositoryException> createIteration() throws RepositoryException {
                        try {
                            return KiWiSailConnection.this.databaseConnection.listTriples(rsubj, rpred, robj, context, includeInferred);
                        }
                        catch (SQLException e) {
                            throw new RepositoryException("database error while listing triples", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            iterations.add(new DelayedIteration<Statement, RepositoryException>(){

                protected Iteration<? extends Statement, ? extends RepositoryException> createIteration() throws RepositoryException {
                    try {
                        return KiWiSailConnection.this.databaseConnection.listTriples(rsubj, rpred, robj, null, includeInferred);
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("database error while listing triples", (Throwable)e);
                    }
                }
            });
        }
        return new UnionIteration(Iterables.transform(iterations, (Function)new Function<DelayedIteration<Statement, RepositoryException>, Iteration<? extends Statement, SailException>>(){

            public Iteration<? extends Statement, SailException> apply(DelayedIteration<Statement, RepositoryException> input) {
                return new ExceptionConvertingIteration<Statement, SailException>(input){

                    protected SailException convert(Exception e) {
                        return new SailException("database error while iterating over result set", (Throwable)e);
                    }
                };
            }
        }));
    }

    protected long sizeInternal(Resource ... contexts) throws SailException {
        try {
            if (contexts.length == 0) {
                return this.databaseConnection.getSize();
            }
            long sum = 0L;
            for (Resource context : contexts) {
                sum += this.databaseConnection.getSize(this.valueFactory.convert(context));
            }
            return sum;
        }
        catch (SQLException ex) {
            throw new SailException("database error while listing triples", (Throwable)ex);
        }
    }

    protected void startTransactionInternal() throws SailException {
        this.triplesAdded = false;
        this.triplesRemoved = false;
        this.deletedStatementsLog = new HashSet();
    }

    protected void commitInternal() throws SailException {
        try {
            this.databaseConnection.commit();
        }
        catch (SQLException e) {
            throw new SailException("database error while committing transaction", (Throwable)e);
        }
        if (this.triplesAdded || this.triplesRemoved) {
            this.deletedStatementsLog.clear();
            this.store.notifySailChanged(new SailChangedEvent(){

                public Sail getSail() {
                    return KiWiSailConnection.this.store;
                }

                public boolean statementsAdded() {
                    return KiWiSailConnection.this.triplesAdded;
                }

                public boolean statementsRemoved() {
                    return KiWiSailConnection.this.triplesRemoved;
                }
            });
        }
    }

    protected void rollbackInternal() throws SailException {
        try {
            this.databaseConnection.rollback();
            this.deletedStatementsLog.clear();
        }
        catch (SQLException e) {
            throw new SailException("database error while rolling back transaction", (Throwable)e);
        }
    }

    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            CloseableIteration<? extends Statement, SailException> triples = this.getStatementsInternal(subj, pred, obj, true, contexts);
            while (triples.hasNext()) {
                KiWiTriple triple = (KiWiTriple)triples.next();
                if (triple.getId() == null) continue;
                this.databaseConnection.deleteTriple(triple);
                this.triplesRemoved = true;
                this.deletedStatementsLog.add(triple.getId());
                this.notifyStatementRemoved(triple);
            }
            triples.close();
        }
        catch (SQLException ex) {
            throw new SailException("database error while deleting statement", (Throwable)ex);
        }
    }

    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            CloseableIteration<? extends Statement, SailException> triples = this.getStatementsInternal(subj, pred, obj, true, new Resource[]{this.valueFactory.createURI(this.inferredContext)});
            while (triples.hasNext()) {
                KiWiTriple triple = (KiWiTriple)triples.next();
                if (triple.getId() == null || !triple.isInferred()) continue;
                this.databaseConnection.deleteTriple(triple);
                this.triplesRemoved = true;
                this.deletedStatementsLog.add(triple.getId());
                this.notifyStatementRemoved(triple);
            }
            triples.close();
        }
        catch (SQLException ex) {
            throw new SailException("database error while deleting statement", (Throwable)ex);
        }
        return true;
    }

    public boolean removeInferredStatement(KiWiTriple triple) throws SailException {
        try {
            if (triple.getId() != null && triple.isInferred()) {
                this.databaseConnection.deleteTriple(triple);
                this.triplesRemoved = true;
                this.deletedStatementsLog.add(triple.getId());
                this.notifyStatementRemoved(triple);
            }
        }
        catch (SQLException ex) {
            throw new SailException("database error while deleting statement", (Throwable)ex);
        }
        return true;
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatementsInternal(null, null, null, contexts);
    }

    public void clearInferred(Resource ... contexts) throws SailException {
        this.removeInferredStatement(null, null, null, new Resource[]{this.valueFactory.createURI(this.inferredContext)});
    }

    public void flushUpdates() {
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        try {
            return new ExceptionConvertingIteration<Namespace, SailException>(this.databaseConnection.listNamespaces()){

                protected SailException convert(Exception e) {
                    return new SailException("database error while iterating over namespaces", (Throwable)e);
                }
            };
        }
        catch (SQLException e) {
            throw new SailException("database error while querying namespaces", (Throwable)e);
        }
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        try {
            KiWiNamespace result = this.databaseConnection.loadNamespaceByPrefix(prefix);
            if (result != null) {
                return result.getUri();
            }
            return null;
        }
        catch (SQLException e) {
            throw new SailException("database error while querying namespaces", (Throwable)e);
        }
    }

    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        try {
            KiWiNamespace result = this.databaseConnection.loadNamespaceByPrefix(prefix);
            if (result != null) {
                if (!result.getUri().equals(name)) {
                    this.databaseConnection.deleteNamespace(result);
                    this.databaseConnection.storeNamespace(new KiWiNamespace(prefix, name));
                }
            } else {
                this.databaseConnection.storeNamespace(new KiWiNamespace(prefix, name));
            }
        }
        catch (SQLException e) {
            throw new SailException("database error while updating namespace", (Throwable)e);
        }
    }

    protected void removeNamespaceInternal(String prefix) throws SailException {
        try {
            KiWiNamespace result = this.databaseConnection.loadNamespaceByPrefix(prefix);
            if (result != null) {
                this.databaseConnection.deleteNamespace(result);
            }
        }
        catch (SQLException e) {
            throw new SailException("database error while deleting namespace", (Throwable)e);
        }
    }

    protected void clearNamespacesInternal() throws SailException {
        for (Namespace ns : Iterations.asList(this.getNamespacesInternal())) {
            this.removeNamespaceInternal(ns.getPrefix());
        }
    }

    public KiWiValueFactory getValueFactory() {
        return this.valueFactory;
    }

    protected static class KiWiEvaluationStatistics
    extends EvaluationStatistics {
        protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
            return new KiWiCardinalityCalculator();
        }

        protected class KiWiCardinalityCalculator
        extends EvaluationStatistics.CardinalityCalculator {
            protected KiWiCardinalityCalculator() {
            }

            protected double getCardinality(StatementPattern sp) {
                return super.getCardinality(sp);
            }

            protected Value getConstantValue(Var var) {
                return var != null ? var.getValue() : null;
            }
        }
    }

    private static class KiWiTripleSource
    implements TripleSource {
        private boolean inferred;
        private KiWiSailConnection connection;

        private KiWiTripleSource(KiWiSailConnection connection, boolean inferred) {
            this.inferred = inferred;
            this.connection = connection;
        }

        public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
            try {
                return new ExceptionConvertingIteration<Statement, QueryEvaluationException>((Iteration)this.connection.getStatements(subj, pred, obj, this.inferred, contexts)){

                    protected QueryEvaluationException convert(Exception e) {
                        if (e instanceof ClosedByInterruptException) {
                            return new QueryInterruptedException((Throwable)e);
                        }
                        if (e instanceof IOException) {
                            return new QueryEvaluationException((Throwable)e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (e == null) {
                            throw new IllegalArgumentException("e must not be null");
                        }
                        throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                    }
                };
            }
            catch (SailException ex) {
                throw new QueryEvaluationException((Throwable)ex);
            }
        }

        public ValueFactory getValueFactory() {
            return this.connection.valueFactory;
        }
    }
}

