/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.persistence.util;

import info.aduna.iteration.CloseableIteration;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.marmotta.kiwi.persistence.util.ResultTransformerFunction;

public class ResultSetIteration<E>
implements CloseableIteration<E, SQLException> {
    ResultSet result;
    ResultTransformerFunction<E> transformer;
    boolean moved = false;
    boolean closed = false;
    boolean closeStatement = false;

    public ResultSetIteration(ResultSet result, ResultTransformerFunction<E> transformer) {
        this.result = result;
        this.transformer = transformer;
    }

    public ResultSetIteration(ResultSet result, boolean closeStatement, ResultTransformerFunction<E> transformer) {
        this.result = result;
        this.transformer = transformer;
        this.closeStatement = closeStatement;
    }

    public void close() throws SQLException {
        try {
            this.result.close();
            if (this.closeStatement) {
                this.result.getStatement().close();
            }
            this.closed = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean hasNext() throws SQLException {
        if (this.closed) {
            return false;
        }
        if (this.moved) {
            return true;
        }
        if (this.result.next()) {
            this.moved = true;
            return true;
        }
        this.close();
        return false;
    }

    public E next() throws SQLException {
        if (this.moved || this.result.next()) {
            this.moved = false;
            return this.transformer.apply(this.result);
        }
        this.close();
        throw new NoSuchElementException("no more results");
    }

    public void remove() throws SQLException {
        throw new UnsupportedOperationException("removing result rows not supported");
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

