/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.persistence;

import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.apache.marmotta.kiwi.caching.KiWiCacheManager;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.persistence.KiWiConnection;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.KiWiGarbageCollector;
import org.apache.marmotta.kiwi.persistence.util.ScriptRunner;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiPersistence {
    private static Logger log = LoggerFactory.getLogger(KiWiPersistence.class);
    private static int KIWI_ID = 0;
    private String name;
    private DataSource connectionPool;
    private KiWiDialect dialect;
    private PoolProperties poolConfig;
    private KiWiCacheManager cacheManager;
    private KiWiGarbageCollector garbageCollector;

    public KiWiPersistence(String name, String jdbcUrl, String db_user, String db_password, KiWiDialect dialect) {
        this.name = name;
        this.dialect = dialect;
        this.initConnectionPool(jdbcUrl, db_user, db_password);
        this.initCachePool();
        this.initGarbageCollector();
        try {
            this.logPoolInfo();
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    public KiWiDialect getDialect() {
        return this.dialect;
    }

    public KiWiCacheManager getCacheManager() {
        return this.cacheManager;
    }

    private void initCachePool() {
        this.cacheManager = new KiWiCacheManager(this.name);
    }

    private void initConnectionPool(String jdbcUrl, String db_user, String db_password) {
        this.poolConfig = new PoolProperties();
        this.poolConfig.setName("kiwi-" + ++KIWI_ID);
        this.poolConfig.setUrl(jdbcUrl);
        this.poolConfig.setDriverClassName(this.dialect.getDriverClass());
        this.poolConfig.setUsername(db_user);
        this.poolConfig.setPassword(db_password);
        this.poolConfig.setDefaultTransactionIsolation(2);
        this.poolConfig.setCommitOnReturn(true);
        this.poolConfig.setJdbcInterceptors("org.apache.tomcat.jdbc.pool.interceptor.ConnectionState;org.apache.tomcat.jdbc.pool.interceptor.StatementFinalizer;org.apache.tomcat.jdbc.pool.interceptor.SlowQueryReport");
        if (log.isDebugEnabled()) {
            this.poolConfig.setSuspectTimeout(30);
            this.poolConfig.setLogAbandoned(true);
        }
        this.connectionPool = new DataSource((PoolConfiguration)this.poolConfig);
    }

    private void initGarbageCollector() {
        this.garbageCollector = new KiWiGarbageCollector(this);
        this.garbageCollector.addNodeTableDependency("triples", "subject");
        this.garbageCollector.addNodeTableDependency("triples", "predicate");
        this.garbageCollector.addNodeTableDependency("triples", "object");
        this.garbageCollector.addNodeTableDependency("triples", "context");
        this.garbageCollector.addNodeTableDependency("triples", "creator");
        this.garbageCollector.addNodeTableDependency("nodes", "ltype");
    }

    public void logPoolInfo() throws SQLException {
        log.debug("num_busy_connections:    {}", (Object)this.connectionPool.getNumActive());
        log.debug("num_idle_connections:    {}", (Object)this.connectionPool.getNumIdle());
    }

    public void initDatabase() throws SQLException {
        this.initDatabase("base", new String[]{"nodes", "triples", "namespaces", "metadata"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDatabase(String scriptName, String[] checkTables) throws SQLException {
        KiWiConnection connection = this.getConnection();
        try {
            Set<String> tables = connection.getDatabaseTables();
            if (log.isDebugEnabled()) {
                log.debug("database tables:");
                for (String table : tables) {
                    log.debug("- found table: {}", (Object)table);
                }
            }
            boolean createNeeded = false;
            for (String tableName : checkTables) {
                createNeeded = createNeeded || !tables.contains(tableName);
            }
            if (createNeeded) {
                log.info("creating new KiWi database ...");
                ScriptRunner runner = new ScriptRunner(connection.getJDBCConnection(), false, false);
                runner.runScript(new StringReader(this.dialect.getCreateScript(scriptName)));
            } else {
                int version = connection.getDatabaseVersion();
                String updateScript = this.dialect.getMigrationScript(version, scriptName);
                if (updateScript != null && updateScript.length() > 0) {
                    log.info("upgrading existing KiWi database from version {} to version {}", (Object)version, (Object)this.dialect.getVersion());
                    ScriptRunner runner = new ScriptRunner(connection.getJDBCConnection(), false, false);
                    runner.runScript(new StringReader(updateScript));
                } else {
                    log.info("connecting to existing KiWi database (version: {})", (Object)version);
                }
            }
            connection.commit();
        }
        catch (SQLException ex) {
            log.error("SQL exception while initialising database, rolling back");
            connection.rollback();
            throw ex;
        }
        catch (IOException ex) {
            log.error("I/O exception while initialising database, rolling back");
            connection.rollback();
        }
        finally {
            connection.close();
        }
    }

    public void dropDatabase() throws SQLException {
        this.dropDatabase("base");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDatabase(String scriptName) throws SQLException {
        this.logPoolInfo();
        this.forceCloseConnections();
        try {
            KiWiConnection connection = this.getConnection();
            try {
                Set<String> tables = connection.getDatabaseTables();
                if (log.isDebugEnabled()) {
                    log.debug("BEFORE DROP: database tables");
                    for (String table : tables) {
                        log.debug("- found table: {}", (Object)table);
                    }
                }
                ScriptRunner runner = new ScriptRunner(connection.getJDBCConnection(), false, false);
                runner.runScript(new StringReader(this.dialect.getDropScript(scriptName)));
                if (log.isDebugEnabled()) {
                    tables = connection.getDatabaseTables();
                    log.debug("AFTER DROP: database tables");
                    for (String table : tables) {
                        log.debug("- found table: {}", (Object)table);
                    }
                }
                connection.commit();
            }
            catch (SQLException ex) {
                log.error("SQL exception while dropping database, rolling back");
                connection.rollback();
                throw ex;
            }
            catch (IOException ex) {
                log.error("I/O exception while dropping database, rolling back");
                connection.rollback();
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException ex) {
            log.error("SQL exception while acquiring database connection");
        }
    }

    public KiWiConnection getConnection() throws SQLException {
        return new KiWiConnection(this, this.dialect, this.cacheManager);
    }

    public Connection getJDBCConnection() throws SQLException {
        Connection conn = this.connectionPool.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    private void forceCloseConnections() {
        this.connectionPool.close(true);
        this.connectionPool = new DataSource((PoolConfiguration)this.poolConfig);
    }

    public void addNodeTableDependency(String tableName, String columnName) {
        this.garbageCollector.addNodeTableDependency(tableName, columnName);
    }

    public void addTripleTableDependency(String tableName, String columnName) {
        this.garbageCollector.addTripleTableDependency(tableName, columnName);
    }

    public RepositoryResult<Statement> listTriples(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context, boolean inferred) throws SQLException {
        final KiWiConnection conn = this.getConnection();
        return new RepositoryResult<Statement>(conn.listTriples(subject, predicate, object, context, inferred)){

            protected void handleClose() throws RepositoryException {
                super.handleClose();
                try {
                    if (!conn.isClosed()) {
                        conn.commit();
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    throw new RepositoryException("SQL error when closing database connection", (Throwable)ex);
                }
            }

            protected void finalize() throws Throwable {
                this.handleClose();
                super.finalize();
            }
        };
    }

    public void initialise() {
        this.garbageCollector.start();
    }

    public void shutdown() {
        this.garbageCollector.shutdown();
        this.cacheManager.shutdown();
        this.connectionPool.close();
    }

    public void clearCache() {
        this.cacheManager.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyGarbageCollector() {
        KiWiGarbageCollector kiWiGarbageCollector = this.garbageCollector;
        synchronized (kiWiGarbageCollector) {
            this.garbageCollector.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceGarbageCollector() throws SQLException {
        KiWiGarbageCollector kiWiGarbageCollector = this.garbageCollector;
        synchronized (kiWiGarbageCollector) {
            this.garbageCollector.garbageCollect();
        }
    }
}

