/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.marmotta.kiwi.persistence.KiWiPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiGarbageCollector
extends Thread {
    private static Logger log = LoggerFactory.getLogger(KiWiGarbageCollector.class);
    private Set<TableDependency> tripleTableDependencies;
    private Set<TableDependency> nodeTableDependencies;
    private long interval = 3600000L;
    private long round = 0L;
    private KiWiPersistence persistence;
    private boolean shutdown = false;

    public KiWiGarbageCollector(KiWiPersistence persistence) {
        super("KiWi Garbage Collector");
        this.persistence = persistence;
        this.tripleTableDependencies = new HashSet<TableDependency>();
        this.nodeTableDependencies = new HashSet<TableDependency>();
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void addTripleTableDependency(String tableName, String columnName) {
        this.tripleTableDependencies.add(new TableDependency(tableName, columnName));
    }

    public void addNodeTableDependency(String tableName, String columnName) {
        this.nodeTableDependencies.add(new TableDependency(tableName, columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int garbageCollect() throws SQLException {
        ++this.round;
        Connection con = this.persistence.getJDBCConnection();
        try {
            int count = 0;
            try {
                String gcTripleQuery = this.buildGCTriplesQuery();
                PreparedStatement stmtGcTriples = con.prepareStatement(gcTripleQuery);
                count += stmtGcTriples.executeUpdate();
                stmtGcTriples.close();
                con.commit();
            }
            catch (SQLException ex) {
                con.rollback();
                log.warn("SQL error while executing garbage collection on triples table: {}", (Object)ex.getMessage());
            }
            int n = count;
            return n;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        KiWiGarbageCollector kiWiGarbageCollector = this;
        synchronized (kiWiGarbageCollector) {
            boolean started = false;
            while (!this.shutdown) {
                if (started) {
                    long start = System.currentTimeMillis();
                    log.info("running garbage collection ...");
                    try {
                        int count = this.garbageCollect();
                        log.info("... cleaned up {} entries (duration: {} ms)", (Object)count, (Object)(System.currentTimeMillis() - start));
                    }
                    catch (SQLException e) {
                        log.error("error while executing garbage collection: {}", (Object)e.getMessage());
                    }
                }
                started = true;
                try {
                    this.wait(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        KiWiGarbageCollector kiWiGarbageCollector = this;
        synchronized (kiWiGarbageCollector) {
            this.shutdown = true;
            this.notifyAll();
        }
    }

    private String buildGCTriplesQuery() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM triples WHERE deleted = true");
        if (this.tripleTableDependencies.size() > 0) {
            for (TableDependency next : this.tripleTableDependencies) {
                builder.append(" AND NOT EXISTS (");
                builder.append("SELECT ");
                builder.append(next.column);
                builder.append(" FROM ");
                builder.append(next.table);
                builder.append(" WHERE ");
                builder.append(next.column);
                builder.append(" = triples.id");
                builder.append(")");
            }
        }
        return builder.toString();
    }

    private String buildGCNodesQuery() {
        StringBuilder builder = new StringBuilder();
        if (this.nodeTableDependencies.size() > 0) {
            builder.append("DELETE FROM nodes T1 WHERE NOT EXISTS (");
            Iterator<TableDependency> iterator = this.nodeTableDependencies.iterator();
            while (iterator.hasNext()) {
                TableDependency next = iterator.next();
                builder.append("SELECT ");
                builder.append(next.column);
                builder.append(" FROM ");
                builder.append(next.table);
                builder.append(" WHERE ");
                builder.append(next.column);
                builder.append(" = T1.id");
                builder.append(")");
                if (!iterator.hasNext()) continue;
                builder.append(" AND NOT EXISTS (");
            }
        }
        return builder.toString();
    }

    private static class TableDependency {
        String table;
        String column;

        private TableDependency(String table, String column) {
            this.column = column;
            this.table = table;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableDependency that = (TableDependency)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            return this.table.equals(that.table);
        }

        public int hashCode() {
            int result = this.table.hashCode();
            result = 31 * result + this.column.hashCode();
            return result;
        }
    }
}

