/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.persistence;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KiWiDialect {
    private static Logger log = LoggerFactory.getLogger(KiWiDialect.class);
    private static final int VERSION = 1;
    private Properties statements = new Properties();

    protected KiWiDialect() {
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(this.getClass().getPackage().getName().replace('.', '/') + "/statements.properties");
            while (urls.hasMoreElements()) {
                this.statements.load(urls.nextElement().openStream());
            }
        }
        catch (Exception e) {
            log.error("could not load statement definitions (statement.properties)", (Throwable)e);
        }
    }

    public int getVersion() {
        return 1;
    }

    public abstract String getDriverClass();

    public String getCreateScript(String scriptName) {
        return this.getScript("create_" + scriptName + "_tables.sql");
    }

    public String getDropScript(String scriptName) {
        return this.getScript("drop_" + scriptName + "_tables.sql");
    }

    protected String getScript(String scriptName) {
        try {
            return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(scriptName));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getMigrationScript(int oldVersion, String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = oldVersion + 1; i <= 1; ++i) {
            try {
                String script = String.format("upgrade_" + name + "_%02d_%02d.sql", i - 1, i);
                builder.append(IOUtils.toString((InputStream)this.getClass().getResourceAsStream(script)));
                continue;
            }
            catch (Exception e) {
                log.warn("upgrade script {} -> {} not found or not readable!", (Object)(i - 1), (Object)i);
            }
        }
        return builder.toString();
    }

    public String getStatement(String identifier) {
        return this.statements.getProperty(identifier);
    }

    public boolean hasStatement(String identifier) {
        return this.statements.getProperty(identifier) != null;
    }

    public Set<String> getStatementIdentifiers() {
        return this.statements.stringPropertyNames();
    }
}

