/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.persistence;

import com.google.common.base.Preconditions;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.LocaleUtils;
import org.apache.marmotta.commons.sesame.model.LiteralCommons;
import org.apache.marmotta.commons.util.DateUtils;
import org.apache.marmotta.kiwi.caching.KiWiCacheManager;
import org.apache.marmotta.kiwi.model.rdf.KiWiAnonResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiBooleanLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiDateLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiDoubleLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiIntLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiNamespace;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiStringLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.KiWiPersistence;
import org.apache.marmotta.kiwi.persistence.util.ResultSetIteration;
import org.apache.marmotta.kiwi.persistence.util.ResultTransformerFunction;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiConnection {
    private static Logger log = LoggerFactory.getLogger(KiWiConnection.class);
    protected KiWiDialect dialect;
    protected Connection connection;
    protected KiWiPersistence persistence;
    protected KiWiCacheManager cacheManager;
    private Cache nodeCache;
    private Cache tripleCache;
    private Cache uriCache;
    private Cache bnodeCache;
    private Cache literalCache;
    private Cache namespaceUriCache;
    private Cache namespacePrefixCache;
    private static Map<String, Locale> localeMap = new HashMap<String, Locale>();
    private Map<String, PreparedStatement> statementCache;
    private boolean autoCommit = false;

    public KiWiConnection(KiWiPersistence persistence, KiWiDialect dialect, KiWiCacheManager cacheManager) throws SQLException {
        this.cacheManager = cacheManager;
        this.dialect = dialect;
        this.persistence = persistence;
        this.initCachePool();
        this.initStatementCache();
    }

    private void initCachePool() {
        this.nodeCache = this.cacheManager.getNodeCache();
        this.tripleCache = this.cacheManager.getTripleCache();
        this.uriCache = this.cacheManager.getUriCache();
        this.bnodeCache = this.cacheManager.getBNodeCache();
        this.literalCache = this.cacheManager.getLiteralCache();
        this.namespacePrefixCache = this.cacheManager.getNamespacePrefixCache();
        this.namespaceUriCache = this.cacheManager.getNamespaceUriCache();
    }

    private void initStatementCache() throws SQLException {
        this.statementCache = new HashMap<String, PreparedStatement>();
    }

    protected void requireJDBCConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.persistence.getJDBCConnection();
            this.connection.setAutoCommit(this.autoCommit);
        }
    }

    public Connection getJDBCConnection() {
        return this.connection;
    }

    public KiWiCacheManager getCacheManager() {
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiNamespace loadNamespaceByPrefix(String prefix) throws SQLException {
        Element element = this.namespacePrefixCache.get((Serializable)((Object)prefix));
        if (element != null) {
            return (KiWiNamespace)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.namespace_prefix");
        query.setString(1, prefix);
        query.setMaxRows(1);
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiNamespace kiWiNamespace = this.constructNamespaceFromDatabase(result);
                return kiWiNamespace;
            }
            KiWiNamespace kiWiNamespace = null;
            return kiWiNamespace;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiNamespace loadNamespaceByUri(String uri) throws SQLException {
        Element element = this.namespaceUriCache.get((Serializable)((Object)uri));
        if (element != null) {
            return (KiWiNamespace)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.namespace_uri");
        query.setString(1, uri);
        query.setMaxRows(1);
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiNamespace kiWiNamespace = this.constructNamespaceFromDatabase(result);
                return kiWiNamespace;
            }
            KiWiNamespace kiWiNamespace = null;
            return kiWiNamespace;
        }
        finally {
            result.close();
        }
    }

    public void storeNamespace(KiWiNamespace namespace) throws SQLException {
        if (namespace.getId() != null) {
            log.warn("trying to store namespace which is already persisted: {}", (Object)namespace);
            return;
        }
        this.requireJDBCConnection();
        namespace.setId(this.getNextSequence("seq.namespaces"));
        PreparedStatement insertNamespace = this.getPreparedStatement("store.namespace");
        insertNamespace.setLong(1, namespace.getId());
        insertNamespace.setString(2, namespace.getPrefix());
        insertNamespace.setString(3, namespace.getUri());
        insertNamespace.setTimestamp(4, new Timestamp(namespace.getCreated().getTime()));
        insertNamespace.executeUpdate();
        this.namespacePrefixCache.put(new Element((Serializable)((Object)namespace.getPrefix()), (Serializable)namespace));
        this.namespaceUriCache.put(new Element((Serializable)((Object)namespace.getUri()), (Serializable)namespace));
    }

    public void deleteNamespace(KiWiNamespace namespace) throws SQLException {
        if (namespace.getId() == null) {
            log.warn("trying to remove namespace which is not persisted: {}", (Object)namespace);
            return;
        }
        this.requireJDBCConnection();
        PreparedStatement deleteNamespace = this.getPreparedStatement("delete.namespace");
        deleteNamespace.setLong(1, namespace.getId());
        deleteNamespace.executeUpdate();
        this.namespacePrefixCache.remove((Serializable)((Object)namespace.getPrefix()));
        this.namespaceUriCache.remove((Serializable)((Object)namespace.getUri()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement querySize = this.getPreparedStatement("query.size");
        ResultSet result = querySize.executeQuery();
        try {
            if (result.next()) {
                long l = result.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize(KiWiResource context) throws SQLException {
        if (context.getId() == null) {
            return 0L;
        }
        this.requireJDBCConnection();
        PreparedStatement querySize = this.getPreparedStatement("query.size_ctx");
        querySize.setLong(1, context.getId());
        ResultSet result = querySize.executeQuery();
        try {
            if (result.next()) {
                long l = result.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiNode loadNodeById(Long id) throws SQLException {
        Element element = this.nodeCache.get((Serializable)id);
        if (element != null) {
            return (KiWiNode)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.node_by_id");
        query.setLong(1, id);
        query.setMaxRows(1);
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiNode kiWiNode = this.constructNodeFromDatabase(result);
                return kiWiNode;
            }
            KiWiNode kiWiNode = null;
            return kiWiNode;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiTriple loadTripleById(Long id) throws SQLException {
        Element element = this.tripleCache.get((Serializable)id);
        if (element != null) {
            return (KiWiTriple)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.triple_by_id");
        query.setLong(1, id);
        query.setMaxRows(1);
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiTriple kiWiTriple = this.constructTripleFromDatabase(result);
                return kiWiTriple;
            }
            KiWiTriple kiWiTriple = null;
            return kiWiTriple;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiUriResource loadUriResource(String uri) throws SQLException {
        Element element = this.uriCache.get((Serializable)((Object)uri));
        if (element != null) {
            return (KiWiUriResource)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.uri_by_uri");
        query.setString(1, uri);
        query.setMaxRows(1);
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiUriResource kiWiUriResource = (KiWiUriResource)this.constructNodeFromDatabase(result);
                return kiWiUriResource;
            }
            KiWiUriResource kiWiUriResource = null;
            return kiWiUriResource;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiAnonResource loadAnonResource(String id) throws SQLException {
        Element element = this.bnodeCache.get((Serializable)((Object)id));
        if (element != null) {
            return (KiWiAnonResource)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.bnode_by_anonid");
        query.setString(1, id);
        query.setMaxRows(1);
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiAnonResource kiWiAnonResource = (KiWiAnonResource)this.constructNodeFromDatabase(result);
                return kiWiAnonResource;
            }
            KiWiAnonResource kiWiAnonResource = null;
            return kiWiAnonResource;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiLiteral loadLiteral(String value, String lang, KiWiUriResource ltype) throws SQLException {
        PreparedStatement query;
        Element element = this.literalCache.get((Serializable)((Object)LiteralCommons.createCacheKey((String)value, (Locale)KiWiConnection.getLocale(lang), (URI)ltype)));
        if (element != null) {
            return (KiWiLiteral)element.getObjectValue();
        }
        if (ltype != null && ltype.getId() == null) {
            return null;
        }
        this.requireJDBCConnection();
        if (lang == null && ltype == null) {
            query = this.getPreparedStatement("load.literal_by_v");
            query.setString(1, value);
        } else if (lang != null) {
            query = this.getPreparedStatement("load.literal_by_vl");
            query.setString(1, value);
            query.setString(2, lang);
        } else if (ltype != null) {
            query = this.getPreparedStatement("load.literal_by_vt");
            query.setString(1, value);
            query.setLong(2, ltype.getId());
        } else {
            throw new IllegalArgumentException("Impossible combination of lang/type in loadLiteral!");
        }
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiLiteral kiWiLiteral = (KiWiLiteral)this.constructNodeFromDatabase(result);
                return kiWiLiteral;
            }
            KiWiLiteral kiWiLiteral = null;
            return kiWiLiteral;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiDateLiteral loadLiteral(Date date) throws SQLException {
        KiWiUriResource ltype = this.loadUriResource("http://www.w3.org/2001/XMLSchema#dateTime");
        if (ltype == null || ltype.getId() == null) {
            return null;
        }
        Element element = this.literalCache.get((Serializable)((Object)LiteralCommons.createCacheKey((Date)DateUtils.getDateWithoutFraction((Date)date), (String)ltype.stringValue())));
        if (element != null) {
            return (KiWiDateLiteral)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.literal_by_tv");
        query.setTimestamp(1, new Timestamp(DateUtils.getDateWithoutFraction((Date)date).getTime()));
        query.setLong(2, ltype.getId());
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiDateLiteral kiWiDateLiteral = (KiWiDateLiteral)this.constructNodeFromDatabase(result);
                return kiWiDateLiteral;
            }
            KiWiDateLiteral kiWiDateLiteral = null;
            return kiWiDateLiteral;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiIntLiteral loadLiteral(long value) throws SQLException {
        KiWiUriResource ltype = this.loadUriResource("http://www.w3.org/2001/XMLSchema#integer");
        if (ltype == null || ltype.getId() == null) {
            return null;
        }
        Element element = this.literalCache.get((Serializable)((Object)LiteralCommons.createCacheKey((String)Long.toString(value), null, (String)ltype.stringValue())));
        if (element != null) {
            return (KiWiIntLiteral)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.literal_by_iv");
        query.setLong(1, value);
        query.setLong(2, ltype.getId());
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiIntLiteral kiWiIntLiteral = (KiWiIntLiteral)this.constructNodeFromDatabase(result);
                return kiWiIntLiteral;
            }
            KiWiIntLiteral kiWiIntLiteral = null;
            return kiWiIntLiteral;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiDoubleLiteral loadLiteral(double value) throws SQLException {
        KiWiUriResource ltype = this.loadUriResource("http://www.w3.org/2001/XMLSchema#double");
        if (ltype == null || ltype.getId() == null) {
            return null;
        }
        Element element = this.literalCache.get((Serializable)((Object)LiteralCommons.createCacheKey((String)Double.toString(value), null, (String)ltype.stringValue())));
        if (element != null) {
            return (KiWiDoubleLiteral)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.literal_by_dv");
        query.setDouble(1, value);
        query.setLong(2, ltype.getId());
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiDoubleLiteral kiWiDoubleLiteral = (KiWiDoubleLiteral)this.constructNodeFromDatabase(result);
                return kiWiDoubleLiteral;
            }
            KiWiDoubleLiteral kiWiDoubleLiteral = null;
            return kiWiDoubleLiteral;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiBooleanLiteral loadLiteral(boolean value) throws SQLException {
        KiWiUriResource ltype = this.loadUriResource("http://www.w3.org/2001/XMLSchema#boolean");
        if (ltype == null || ltype.getId() == null) {
            return null;
        }
        Element element = this.literalCache.get((Serializable)((Object)LiteralCommons.createCacheKey((String)Boolean.toString(value), null, (String)ltype.stringValue())));
        if (element != null) {
            return (KiWiBooleanLiteral)element.getObjectValue();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.getPreparedStatement("load.literal_by_bv");
        query.setBoolean(1, value);
        query.setLong(2, ltype.getId());
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiBooleanLiteral kiWiBooleanLiteral = (KiWiBooleanLiteral)this.constructNodeFromDatabase(result);
                return kiWiBooleanLiteral;
            }
            KiWiBooleanLiteral kiWiBooleanLiteral = null;
            return kiWiBooleanLiteral;
        }
        finally {
            result.close();
        }
    }

    public synchronized void storeNode(KiWiNode node) throws SQLException {
        KiWiLiteral literal;
        if (node.getId() != null) {
            log.warn("node {} already had a node ID, not persisting", (Object)node);
            return;
        }
        if (node instanceof KiWiLiteral && (literal = (KiWiLiteral)node).getType() != null && literal.getType().getId() == null) {
            this.storeNode(literal.getType());
        }
        this.requireJDBCConnection();
        node.setId(this.getNextSequence("seq.nodes"));
        if (node instanceof KiWiUriResource) {
            KiWiUriResource uriResource = (KiWiUriResource)node;
            PreparedStatement insertNode = this.getPreparedStatement("store.uri");
            insertNode.setLong(1, node.getId());
            insertNode.setString(2, uriResource.stringValue());
            insertNode.setTimestamp(3, new Timestamp(uriResource.getCreated().getTime()));
            insertNode.executeUpdate();
        } else if (node instanceof KiWiAnonResource) {
            KiWiAnonResource anonResource = (KiWiAnonResource)node;
            PreparedStatement insertNode = this.getPreparedStatement("store.bnode");
            insertNode.setLong(1, node.getId());
            insertNode.setString(2, anonResource.stringValue());
            insertNode.setTimestamp(3, new Timestamp(anonResource.getCreated().getTime()));
            insertNode.executeUpdate();
        } else if (node instanceof KiWiDateLiteral) {
            KiWiDateLiteral dateLiteral = (KiWiDateLiteral)node;
            PreparedStatement insertNode = this.getPreparedStatement("store.tliteral");
            insertNode.setLong(1, node.getId());
            insertNode.setString(2, dateLiteral.stringValue());
            insertNode.setTimestamp(3, new Timestamp(dateLiteral.getDateContent().getTime()));
            if (dateLiteral.getType() == null) {
                throw new IllegalStateException("a date literal must have a datatype");
            }
            insertNode.setLong(4, dateLiteral.getType().getId());
            insertNode.setTimestamp(5, new Timestamp(dateLiteral.getCreated().getTime()));
            insertNode.executeUpdate();
        } else if (node instanceof KiWiIntLiteral) {
            KiWiIntLiteral intLiteral = (KiWiIntLiteral)node;
            PreparedStatement insertNode = this.getPreparedStatement("store.iliteral");
            insertNode.setLong(1, node.getId());
            insertNode.setString(2, intLiteral.getContent());
            insertNode.setDouble(3, intLiteral.getDoubleContent());
            insertNode.setLong(4, intLiteral.getIntContent());
            if (intLiteral.getType() == null) {
                throw new IllegalStateException("an integer literal must have a datatype");
            }
            insertNode.setLong(5, intLiteral.getType().getId());
            insertNode.setTimestamp(6, new Timestamp(intLiteral.getCreated().getTime()));
            insertNode.executeUpdate();
        } else if (node instanceof KiWiDoubleLiteral) {
            KiWiDoubleLiteral doubleLiteral = (KiWiDoubleLiteral)node;
            PreparedStatement insertNode = this.getPreparedStatement("store.dliteral");
            insertNode.setLong(1, node.getId());
            insertNode.setString(2, doubleLiteral.getContent());
            insertNode.setDouble(3, doubleLiteral.getDoubleContent());
            if (doubleLiteral.getType() == null) {
                throw new IllegalStateException("a double literal must have a datatype");
            }
            insertNode.setLong(4, doubleLiteral.getType().getId());
            insertNode.setTimestamp(5, new Timestamp(doubleLiteral.getCreated().getTime()));
            insertNode.executeUpdate();
        } else if (node instanceof KiWiBooleanLiteral) {
            KiWiBooleanLiteral booleanLiteral = (KiWiBooleanLiteral)node;
            PreparedStatement insertNode = this.getPreparedStatement("store.bliteral");
            insertNode.setLong(1, node.getId());
            insertNode.setString(2, booleanLiteral.getContent());
            insertNode.setBoolean(3, booleanLiteral.booleanValue());
            if (booleanLiteral.getType() == null) {
                throw new IllegalStateException("a boolean literal must have a datatype");
            }
            insertNode.setLong(4, booleanLiteral.getType().getId());
            insertNode.setTimestamp(5, new Timestamp(booleanLiteral.getCreated().getTime()));
            insertNode.executeUpdate();
        } else if (node instanceof KiWiStringLiteral) {
            KiWiStringLiteral stringLiteral = (KiWiStringLiteral)node;
            PreparedStatement insertNode = this.getPreparedStatement("store.sliteral");
            insertNode.setLong(1, node.getId());
            insertNode.setString(2, stringLiteral.getContent());
            if (stringLiteral.getLocale() != null) {
                insertNode.setString(3, stringLiteral.getLocale().getLanguage());
            } else {
                insertNode.setObject(3, null);
            }
            if (stringLiteral.getType() != null) {
                insertNode.setLong(4, stringLiteral.getType().getId());
            } else {
                insertNode.setObject(4, null);
            }
            insertNode.setTimestamp(5, new Timestamp(stringLiteral.getCreated().getTime()));
            insertNode.executeUpdate();
        } else {
            log.warn("unrecognized node type: {}", (Object)node.getClass().getCanonicalName());
        }
        this.cacheNode(node);
    }

    public synchronized void storeTriple(KiWiTriple triple) throws SQLException {
        if (triple.getId() != null) {
            log.warn("triple {} already had a triple ID, not persisting", (Object)triple);
            return;
        }
        Preconditions.checkNotNull((Object)triple.getSubject().getId());
        Preconditions.checkNotNull((Object)triple.getPredicate().getId());
        Preconditions.checkNotNull((Object)triple.getObject().getId());
        Preconditions.checkNotNull((Object)triple.getContext().getId());
        this.requireJDBCConnection();
        triple.setId(this.getNextSequence("seq.triples"));
        PreparedStatement insertTriple = this.getPreparedStatement("store.triple");
        insertTriple.setLong(1, triple.getId());
        insertTriple.setLong(2, triple.getSubject().getId());
        insertTriple.setLong(3, triple.getPredicate().getId());
        insertTriple.setLong(4, triple.getObject().getId());
        insertTriple.setLong(5, triple.getContext().getId());
        insertTriple.setBoolean(6, triple.isInferred());
        insertTriple.setTimestamp(7, new Timestamp(triple.getCreated().getTime()));
        insertTriple.executeUpdate();
        this.cacheTriple(triple);
    }

    public void deleteTriple(KiWiTriple triple) throws SQLException {
        if (triple.getId() == null) {
            log.warn("attempting to remove non-persistent triple: {}", (Object)triple);
            return;
        }
        this.requireJDBCConnection();
        PreparedStatement deleteTriple = this.getPreparedStatement("delete.triple");
        deleteTriple.setLong(1, triple.getId());
        deleteTriple.executeUpdate();
        this.removeCachedTriple(triple);
        triple.setDeleted(true);
        triple.setDeletedAt(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeleteTriple(KiWiTriple triple) throws SQLException {
        if (triple.getId() == null) {
            log.warn("attempting to undelete non-persistent triple: {}", (Object)triple);
            return;
        }
        this.requireJDBCConnection();
        KiWiTriple kiWiTriple = triple;
        synchronized (kiWiTriple) {
            if (!triple.isDeleted().booleanValue()) {
                log.warn("attemting to undelete triple that was not deleted: {}", (Object)triple);
                return;
            }
            PreparedStatement undeleteTriple = this.getPreparedStatement("undelete.triple");
            undeleteTriple.setLong(1, triple.getId());
            undeleteTriple.executeUpdate();
            triple.setDeleted(false);
            triple.setDeletedAt(null);
            this.cacheTriple(triple);
        }
    }

    public void cleanupTriples() {
        throw new UnsupportedOperationException("garbage collection of triples is not yet supported!");
    }

    public CloseableIteration<KiWiResource, SQLException> listContexts() throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement queryContexts = this.getPreparedStatement("query.contexts");
        final ResultSet result = queryContexts.executeQuery();
        return new ResultSetIteration<KiWiResource>(result, new ResultTransformerFunction<KiWiResource>(){

            @Override
            public KiWiResource apply(ResultSet row) throws SQLException {
                return (KiWiResource)KiWiConnection.this.loadNodeById(result.getLong("context"));
            }
        });
    }

    public CloseableIteration<KiWiNamespace, SQLException> listNamespaces() throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement queryContexts = this.getPreparedStatement("query.namespaces");
        final ResultSet result = queryContexts.executeQuery();
        return new ResultSetIteration<KiWiNamespace>(result, new ResultTransformerFunction<KiWiNamespace>(){

            @Override
            public KiWiNamespace apply(ResultSet input) throws SQLException {
                return KiWiConnection.this.constructNamespaceFromDatabase(result);
            }
        });
    }

    public RepositoryResult<Statement> listTriples(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context, boolean inferred) throws SQLException {
        return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Statement, RepositoryException>(this.listTriplesInternal(subject, predicate, object, context, inferred)){

            protected RepositoryException convert(Exception e) {
                return new RepositoryException("database error while iterating over result set", (Throwable)e);
            }
        });
    }

    private CloseableIteration<Statement, SQLException> listTriplesInternal(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context, boolean inferred) throws SQLException {
        if (subject != null && subject.getId() == null) {
            return new EmptyIteration();
        }
        if (predicate != null && predicate.getId() == null) {
            return new EmptyIteration();
        }
        if (object != null && object.getId() == null) {
            return new EmptyIteration();
        }
        if (context != null && context.getId() == null) {
            return new EmptyIteration();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.connection.prepareStatement(this.constructTripleQuery(subject, predicate, object, context, inferred), 1003, 1007);
        query.clearParameters();
        int position = 1;
        if (subject != null) {
            query.setLong(position++, subject.getId());
        }
        if (predicate != null) {
            query.setLong(position++, predicate.getId());
        }
        if (object != null) {
            query.setLong(position++, object.getId());
        }
        if (context != null) {
            query.setLong(position++, context.getId());
        }
        final ResultSet result = query.executeQuery();
        return new ResultSetIteration<Statement>(result, true, new ResultTransformerFunction<Statement>(){

            @Override
            public Statement apply(ResultSet row) throws SQLException {
                return KiWiConnection.this.constructTripleFromDatabase(result);
            }
        });
    }

    protected String constructTripleQuery(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context, boolean inferred) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id,subject,predicate,object,context,deleted,inferred,creator,createdAt,deletedAt FROM triples WHERE deleted = false");
        if (subject != null) {
            builder.append(" AND subject = ?");
        }
        if (predicate != null) {
            builder.append(" AND predicate = ?");
        }
        if (object != null) {
            builder.append(" AND object = ?");
        }
        if (context != null) {
            builder.append(" AND context = ?");
        }
        if (!inferred) {
            builder.append(" AND inferred = false");
        }
        return builder.toString();
    }

    protected KiWiNamespace constructNamespaceFromDatabase(ResultSet row) throws SQLException {
        KiWiNamespace result = new KiWiNamespace(row.getString("prefix"), row.getString("uri"));
        result.setId(row.getLong("id"));
        result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
        this.namespacePrefixCache.put(new Element((Serializable)((Object)result.getPrefix()), (Serializable)result));
        this.namespaceUriCache.put(new Element((Serializable)((Object)result.getUri()), (Serializable)result));
        return result;
    }

    protected KiWiNode constructNodeFromDatabase(ResultSet row) throws SQLException {
        Long id = row.getLong("id");
        Element cached = this.nodeCache.get((Serializable)id);
        if (cached != null) {
            return (KiWiNode)cached.getObjectValue();
        }
        String ntype = row.getString("ntype");
        if ("uri".equals(ntype)) {
            KiWiUriResource result = new KiWiUriResource(row.getString("svalue"));
            result.setId(id);
            result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
            this.cacheNode(result);
            return result;
        }
        if ("bnode".equals(ntype)) {
            KiWiAnonResource result = new KiWiAnonResource(row.getString("svalue"));
            result.setId(row.getLong("id"));
            result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
            this.cacheNode(result);
            return result;
        }
        if ("string".equals(ntype)) {
            KiWiStringLiteral result = new KiWiStringLiteral(row.getString("svalue"));
            result.setId(row.getLong("id"));
            result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
            if (row.getString("lang") != null) {
                result.setLocale(KiWiConnection.getLocale(row.getString("lang")));
            }
            if (row.getLong("ltype") != 0L) {
                result.setType((KiWiUriResource)this.loadNodeById(row.getLong("ltype")));
            } else {
                log.warn("Loaded literal without type: '{}' (id:{}).", (Object)result.getContent(), (Object)result.getId());
            }
            this.cacheNode(result);
            return result;
        }
        if ("int".equals(ntype)) {
            KiWiIntLiteral result = new KiWiIntLiteral();
            result.setId(row.getLong("id"));
            result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
            result.setIntContent(row.getLong("ivalue"));
            if (row.getLong("ltype") != 0L) {
                result.setType((KiWiUriResource)this.loadNodeById(row.getLong("ltype")));
            }
            this.cacheNode(result);
            return result;
        }
        if ("double".equals(ntype)) {
            KiWiDoubleLiteral result = new KiWiDoubleLiteral();
            result.setId(row.getLong("id"));
            result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
            result.setDoubleContent(row.getDouble("dvalue"));
            if (row.getLong("ltype") != 0L) {
                result.setType((KiWiUriResource)this.loadNodeById(row.getLong("ltype")));
            }
            this.cacheNode(result);
            return result;
        }
        if ("boolean".equals(ntype)) {
            KiWiBooleanLiteral result = new KiWiBooleanLiteral();
            result.setId(row.getLong("id"));
            result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
            result.setValue(row.getBoolean("bvalue"));
            if (row.getLong("ltype") != 0L) {
                result.setType((KiWiUriResource)this.loadNodeById(row.getLong("ltype")));
            }
            this.cacheNode(result);
            return result;
        }
        if ("date".equals(ntype)) {
            KiWiDateLiteral result = new KiWiDateLiteral();
            result.setId(row.getLong("id"));
            result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
            result.setDateContent(new Date(row.getTimestamp("tvalue").getTime()));
            if (row.getLong("ltype") != 0L) {
                result.setType((KiWiUriResource)this.loadNodeById(row.getLong("ltype")));
            }
            this.cacheNode(result);
            return result;
        }
        throw new IllegalArgumentException("unknown node type in database result: " + ntype);
    }

    protected KiWiTriple constructTripleFromDatabase(ResultSet row) throws SQLException {
        Long id = row.getLong("id");
        Element cached = this.tripleCache.get((Serializable)id);
        if (cached != null) {
            return (KiWiTriple)cached.getObjectValue();
        }
        KiWiTriple result = new KiWiTriple();
        result.setId(id);
        result.setSubject((KiWiResource)this.loadNodeById(row.getLong("subject")));
        result.setPredicate((KiWiUriResource)this.loadNodeById(row.getLong("predicate")));
        result.setObject(this.loadNodeById(row.getLong("object")));
        result.setContext((KiWiResource)this.loadNodeById(row.getLong("context")));
        if (row.getLong("creator") != 0L) {
            result.setCreator((KiWiResource)this.loadNodeById(row.getLong("creator")));
        }
        result.setDeleted(row.getBoolean("deleted"));
        result.setInferred(row.getBoolean("deleted"));
        result.setCreated(new Date(row.getTimestamp("createdAt").getTime()));
        try {
            if (row.getDate("deletedAt") != null) {
                result.setDeletedAt(new Date(row.getTimestamp("deletedAt").getTime()));
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        this.tripleCache.put(new Element((Serializable)id, (Serializable)result));
        return result;
    }

    protected static Locale getLocale(String language) {
        Locale locale = localeMap.get(language);
        if (locale == null) {
            locale = LocaleUtils.toLocale((String)language);
            localeMap.put(language, locale);
        }
        return locale;
    }

    public PreparedStatement getPreparedStatement(String key) throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement statement = this.statementCache.get(key);
        if (statement == null) {
            statement = this.connection.prepareStatement(this.dialect.getStatement(key));
            this.statementCache.put(key, statement);
        }
        statement.clearParameters();
        return statement;
    }

    public long getNextSequence(String sequenceName) throws SQLException {
        this.requireJDBCConnection();
        if (this.dialect.hasStatement(sequenceName + ".prep")) {
            PreparedStatement prepNodeId = this.getPreparedStatement(sequenceName + ".prep");
            prepNodeId.executeUpdate();
        }
        PreparedStatement queryNodeId = this.getPreparedStatement(sequenceName);
        ResultSet resultNodeId = queryNodeId.executeQuery();
        try {
            if (resultNodeId.next()) {
                long l = resultNodeId.getLong(1);
                return l;
            }
            throw new SQLException("the sequence did not return a new value");
        }
        finally {
            resultNodeId.close();
        }
    }

    private void cacheNode(KiWiNode node) {
        if (node.getId() != null) {
            this.nodeCache.put(new Element((Serializable)node.getId(), (Serializable)node));
        }
        if (node instanceof KiWiUriResource) {
            this.uriCache.put(new Element((Serializable)((Object)node.stringValue()), (Serializable)node));
        } else if (node instanceof KiWiAnonResource) {
            this.bnodeCache.put(new Element((Serializable)((Object)node.stringValue()), (Serializable)node));
        } else if (node instanceof KiWiLiteral) {
            this.literalCache.put(new Element((Serializable)((Object)LiteralCommons.createCacheKey((Literal)((Literal)node))), (Serializable)node));
        }
    }

    private void cacheTriple(KiWiTriple triple) {
        if (triple.getId() != null) {
            this.tripleCache.put(new Element((Serializable)triple.getId(), (Serializable)triple));
        }
    }

    private void removeCachedTriple(KiWiTriple triple) {
        if (triple.getId() != null) {
            this.tripleCache.remove((Serializable)triple.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDatabaseTables() throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement statement = this.getPreparedStatement("meta.tables");
        ResultSet result = statement.executeQuery();
        try {
            HashSet<String> tables = new HashSet<String>();
            while (result.next()) {
                tables.add(result.getString(1).toLowerCase());
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        finally {
            result.close();
        }
    }

    public int getDatabaseVersion() throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement statement = this.getPreparedStatement("meta.version");
        ResultSet result = statement.executeQuery();
        try {
            if (result.next()) {
                int n = Integer.parseInt(result.getString(1));
                return n;
            }
            throw new SQLException("no version information available");
        }
        finally {
            result.close();
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.connection != null) {
            this.connection.setAutoCommit(autoCommit);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        if (this.connection != null) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.rollback();
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.connection != null) {
            return this.connection.isClosed();
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            try {
                for (Map.Entry<String, PreparedStatement> entry : this.statementCache.entrySet()) {
                    try {
                        entry.getValue().close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (AbstractMethodError ex) {
                log.debug("database system does not allow closing statements");
            }
            this.connection.close();
        }
    }
}

