/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.model.rdf;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import org.apache.marmotta.commons.sesame.model.URICommons;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.openrdf.model.URI;

public class KiWiUriResource
extends KiWiResource
implements URI {
    private static final long serialVersionUID = -6399293877969640084L;
    private static HashFunction hasher = Hashing.goodFastHash((int)16);
    private HashCode goodHashCode;
    private String uri;
    private String namespace;
    private String localName;

    @Deprecated
    public KiWiUriResource() {
    }

    public KiWiUriResource(String uri) {
        this.uri = uri;
    }

    @Deprecated
    public String getUri() {
        return this.uri;
    }

    @Deprecated
    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getLocalName() {
        this.initNamespace();
        return this.localName;
    }

    public String getNamespace() {
        this.initNamespace();
        return this.namespace;
    }

    public String stringValue() {
        return this.uri;
    }

    @Override
    public boolean isAnonymousResource() {
        return false;
    }

    @Override
    public boolean isUriResource() {
        return true;
    }

    public String toString() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof URI) {
            return this.stringValue().equals(((URI)o).stringValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.goodHashCode == null) {
            this.goodHashCode = hasher.newHasher().putChar('U').putString((CharSequence)this.getUri()).hash();
        }
        return this.goodHashCode.hashCode();
    }

    private void initNamespace() {
        if (this.namespace == null || this.localName == null) {
            String[] components = URICommons.splitNamespace((String)this.uri);
            this.namespace = components[0];
            this.localName = components[1];
        }
    }
}

