/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.model.rdf;

import java.io.Serializable;
import java.util.Date;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.openrdf.model.Statement;

public class KiWiTriple
implements Statement,
Serializable {
    private static final long serialVersionUID = -8726615974625660845L;
    private Long id;
    private KiWiResource subject;
    private KiWiUriResource predicate;
    private KiWiNode object;
    private KiWiResource context;
    private KiWiResource creator;
    private Date created = new Date();
    private Date deletedAt = null;
    private Boolean deleted = false;
    private Boolean inferred = false;
    private Boolean markedForReasoning = false;

    public KiWiTriple() {
    }

    public KiWiTriple(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context) {
        this();
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.context = context;
        this.deletedAt = null;
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        assert (context != null);
    }

    public KiWiNode getObject() {
        return this.object;
    }

    public void setObject(KiWiNode object) {
        this.object = object;
    }

    public KiWiUriResource getPredicate() {
        return this.predicate;
    }

    public void setPredicate(KiWiUriResource property) {
        this.predicate = property;
    }

    public KiWiResource getSubject() {
        return this.subject;
    }

    public void setSubject(KiWiResource subject) {
        this.subject = subject;
    }

    public KiWiResource getContext() {
        return this.context;
    }

    public void setContext(KiWiResource context) {
        this.context = context;
    }

    public KiWiResource getCreator() {
        return this.creator;
    }

    public void setCreator(KiWiResource author) {
        this.creator = author;
    }

    public Date getCreated() {
        return new Date(this.created.getTime());
    }

    public void setCreated(Date created) {
        this.created = new Date(created.getTime());
    }

    public Date getDeletedAt() {
        return new Date(this.deletedAt.getTime());
    }

    public void setDeletedAt(Date deletedAt) {
        this.deletedAt = new Date(deletedAt.getTime());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        KiWiTriple triple = (KiWiTriple)o;
        if (!this.getContext().equals(triple.getContext())) {
            return false;
        }
        if (!this.getObject().equals(triple.getObject())) {
            return false;
        }
        if (!this.getPredicate().equals(triple.getPredicate())) {
            return false;
        }
        return this.getSubject().equals(triple.getSubject());
    }

    public int hashCode() {
        int result = this.getSubject().hashCode();
        result = 31 * result + this.getPredicate().hashCode();
        result = 31 * result + this.getObject().hashCode();
        result = 31 * result + this.getContext().hashCode();
        return result;
    }

    public String toString() {
        if (this.context != null) {
            return "{" + this.subject.toString() + " " + this.predicate.toString() + " " + this.object.toString() + "}@" + this.context.toString();
        }
        return "{" + this.subject.toString() + " " + this.predicate.toString() + " " + this.object.toString() + "}@GLOBAL";
    }

    public String getKey() {
        return this.toString();
    }

    public boolean isInferred() {
        return this.inferred;
    }

    public void setInferred(boolean inferred) {
        this.inferred = inferred;
    }

    public Boolean isMarkedForReasoning() {
        return this.markedForReasoning;
    }

    public void setMarkedForReasoning(Boolean markedForReasoning) {
        this.markedForReasoning = markedForReasoning;
    }
}

