/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.model.rdf;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public abstract class KiWiLiteral
extends KiWiNode
implements Literal {
    private static HashFunction hasher = Hashing.goodFastHash((int)32);
    private HashCode goodHashCode;
    private static final long serialVersionUID = 1772323725671607249L;
    private String contentMd5;
    private Locale locale;
    private KiWiUriResource type;

    public KiWiLiteral() {
    }

    protected KiWiLiteral(Locale locale, KiWiUriResource type) {
        this();
        this.locale = locale;
        this.type = type;
    }

    public abstract String getContent();

    public abstract void setContent(String var1);

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale language) {
        this.locale = language;
    }

    public KiWiUriResource getType() {
        return this.type;
    }

    public void setType(KiWiUriResource type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\"").append(this.getContent()).append("\"");
        if (this.locale != null) {
            result.append("@").append(this.locale.getLanguage());
        }
        if (this.type != null) {
            result.append("^^");
            if (this.type.stringValue().startsWith("http://www.w3.org/2001/XMLSchema#")) {
                result.append(this.getType().stringValue().replace("http://www.w3.org/2001/XMLSchema#", "xsd:"));
            } else if (this.type.stringValue().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                result.append(this.getType().stringValue().replace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:"));
            } else {
                result.append(this.getType());
            }
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal that = (Literal)o;
            if (!this.getLabel().equals(that.getLabel())) {
                return false;
            }
            if (this.getLanguage() != null && !this.getLanguage().equals(that.getLanguage())) {
                return false;
            }
            if (this.getDatatype() == null && that.getDatatype() != null) {
                return false;
            }
            return this.getDatatype() == null || this.getDatatype().equals(that.getDatatype());
        }
        return false;
    }

    public int hashCode() {
        if (this.goodHashCode == null) {
            Hasher hash = hasher.newHasher().putChar('L').putString((CharSequence)this.getContent());
            if (this.getLocale() != null) {
                hash.putString((CharSequence)this.getLocale().toString());
            }
            if (this.getType() != null) {
                hash.putString((CharSequence)this.getType().stringValue());
            }
            this.goodHashCode = hash.hash();
        }
        return this.goodHashCode.hashCode();
    }

    @Override
    public boolean isAnonymousResource() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isUriResource() {
        return false;
    }

    public boolean booleanValue() {
        return Boolean.parseBoolean(this.getLabel());
    }

    public String getLabel() {
        return this.getContent();
    }

    public String getLanguage() {
        if (this.getLocale() != null) {
            return this.getLocale().getLanguage().toLowerCase();
        }
        return null;
    }

    public URI getDatatype() {
        return this.type;
    }

    public byte byteValue() {
        return Byte.parseByte(this.getLabel());
    }

    public short shortValue() {
        return Short.parseShort(this.getLabel());
    }

    public int intValue() {
        return Integer.parseInt(this.getLabel());
    }

    public long longValue() {
        return Long.parseLong(this.getLabel());
    }

    public BigInteger integerValue() {
        return new BigInteger(this.getLabel());
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.getLabel());
    }

    public float floatValue() {
        return Float.parseFloat(this.getLabel());
    }

    public double doubleValue() {
        return Double.parseDouble(this.getLabel());
    }

    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar((String)this.getLabel());
    }

    public String stringValue() {
        return this.getLabel();
    }
}

