/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.model.rdf;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.marmotta.commons.util.DateUtils;
import org.apache.marmotta.kiwi.model.rdf.KiWiStringLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.openrdf.model.Literal;

public class KiWiDateLiteral
extends KiWiStringLiteral {
    private static final long serialVersionUID = -7710255732571214481L;
    private Date dateContent;
    private static DatatypeFactory dtf;

    public KiWiDateLiteral() {
    }

    public KiWiDateLiteral(Date dateContent, KiWiUriResource type) {
        super(DateUtils.getXMLCalendar((Date)DateUtils.getDateWithoutFraction((Date)dateContent)).toXMLFormat(), null, type);
        this.setDateContent(dateContent);
    }

    public Date getDateContent() {
        return new Date(this.dateContent.getTime());
    }

    public void setDateContent(Date dateContent) {
        this.dateContent = DateUtils.getDateWithoutFraction((Date)dateContent);
        this.content = DateUtils.getXMLCalendar((Date)this.dateContent).toXMLFormat();
    }

    @Override
    public String getContent() {
        return DateUtils.getXMLCalendar((Date)this.dateContent).toXMLFormat();
    }

    @Override
    public void setContent(String content) {
        this.setDateContent(DateUtils.parseDate((String)content));
    }

    @Override
    public String getLabel() {
        return this.calendarValue().toXMLFormat();
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(this.getDateContent());
        XMLGregorianCalendar xml_cal = dtf.newXMLGregorianCalendar(cal).normalize();
        xml_cal.setTimezone(0);
        return xml_cal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal that = (Literal)o;
            if (!this.getDatatype().equals(that.getDatatype())) {
                return false;
            }
            return this.calendarValue().toGregorianCalendar().getTime().getTime() == that.calendarValue().toGregorianCalendar().getTime().getTime();
        }
        return false;
    }

    static {
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }
}

