/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.caching;

import com.google.common.collect.ImmutableList;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.marmotta.kiwi.model.caching.IntArray;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiQueryCache {
    private static Logger log = LoggerFactory.getLogger(KiWiQueryCache.class);
    private Ehcache queryCache;

    public KiWiQueryCache(Ehcache queryCache) {
        this.queryCache = queryCache;
        log.debug("Building up new {}", (Object)KiWiQueryCache.class.getSimpleName());
    }

    public List<KiWiTriple> listTriples(KiWiResource subject, KiWiUriResource property, KiWiNode object, KiWiUriResource context, boolean inferred) {
        IntArray key = KiWiQueryCache.createCacheKey(subject, property, object, context, inferred);
        if (this.queryCache.get((Object)key) != null) {
            return (List)this.queryCache.get((Object)key).getObjectValue();
        }
        return null;
    }

    public void cacheTriples(KiWiResource subject, KiWiUriResource property, KiWiNode object, KiWiResource context, boolean inferred, List<KiWiTriple> result) {
        IntArray key = KiWiQueryCache.createCacheKey(subject, property, object, context, inferred);
        this.queryCache.put(new Element((Object)key, result));
        HashSet nodes = new HashSet();
        for (KiWiTriple triple : result) {
            Collections.addAll(nodes, triple.getSubject(), triple.getObject(), triple.getPredicate(), triple.getContext());
            this.queryCache.put(new Element((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext(), triple.isInferred()), (Object)ImmutableList.of((Object)triple)));
        }
        if (subject != null && property == null && object == null) {
            HashMap<KiWiUriResource, LinkedList<KiWiTriple>> properties = new HashMap<KiWiUriResource, LinkedList<KiWiTriple>>();
            for (KiWiTriple kiWiTriple : result) {
                LinkedList<KiWiTriple> values = (LinkedList<KiWiTriple>)properties.get(kiWiTriple.getPredicate());
                if (values == null) {
                    values = new LinkedList<KiWiTriple>();
                    properties.put(kiWiTriple.getPredicate(), values);
                }
                values.add(kiWiTriple);
            }
            for (Map.Entry entry : properties.entrySet()) {
                IntArray key2 = KiWiQueryCache.createCacheKey(subject, (KiWiUriResource)entry.getKey(), null, context, inferred);
                this.queryCache.put(new Element((Object)key2, entry.getValue()));
            }
        }
    }

    public void cacheTriple(KiWiTriple triple) {
        this.tripleUpdated(triple);
        this.cacheTriples(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext(), triple.isInferred(), Collections.singletonList(triple));
    }

    public void removeTriple(KiWiTriple triple) {
        this.tripleUpdated(triple);
    }

    public void clearAll() {
        this.queryCache.removeAll();
    }

    public void tripleUpdated(KiWiTriple triple) {
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, null, null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, null, null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, null, null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, null, null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), null, null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), null, null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, triple.getObject(), null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, triple.getObject(), null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, null, triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, null, triple.getContext(), true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), null, null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), null, null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, triple.getObject(), null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, triple.getObject(), null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, null, triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, null, triple.getContext(), true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), triple.getObject(), null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), triple.getObject(), null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), null, triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), null, triple.getContext(), true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, triple.getObject(), triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, null, triple.getObject(), triple.getContext(), true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), null, false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), null, true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), null, triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), null, triple.getContext(), true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, triple.getObject(), triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), null, triple.getObject(), triple.getContext(), true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), triple.getObject(), triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(null, triple.getPredicate(), triple.getObject(), triple.getContext(), true));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext(), false));
        this.queryCache.remove((Object)KiWiQueryCache.createCacheKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext(), true));
    }

    private static IntArray createCacheKey(KiWiResource subject, KiWiUriResource property, KiWiNode object, KiWiResource context, boolean inferred) {
        int s = subject != null ? subject.hashCode() : Integer.MIN_VALUE;
        int p = property != null ? property.hashCode() : Integer.MIN_VALUE;
        int o = object != null ? object.hashCode() : Integer.MIN_VALUE;
        int c = context != null ? context.hashCode() : Integer.MIN_VALUE;
        IntBuffer bb = IntBuffer.allocate(5);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        bb.put(c);
        bb.put((byte)(inferred ? 1 : 0));
        return new IntArray(bb.array());
    }
}

