/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.caching;

import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.marmotta.kiwi.caching.KiWiQueryCache;

public class KiWiCacheManager {
    private CacheManager cacheManager = CacheManager.newInstance((URL)KiWiCacheManager.class.getResource("/ehcache-kiwi.xml"));
    private KiWiQueryCache queryCache;

    public KiWiCacheManager(String name) {
        if (name != null) {
            this.cacheManager.setName(name);
        }
        this.queryCache = new KiWiQueryCache((Ehcache)this.cacheManager.getCache("query-cache"));
    }

    public Cache getNodeCache() {
        return this.cacheManager.getCache("node-cache");
    }

    public Cache getTripleCache() {
        return this.cacheManager.getCache("triple-cache");
    }

    public Cache getUriCache() {
        return this.cacheManager.getCache("uri-cache");
    }

    public Cache getBNodeCache() {
        return this.cacheManager.getCache("bnode-cache");
    }

    public Cache getLiteralCache() {
        return this.cacheManager.getCache("literal-cache");
    }

    public Cache getNamespaceUriCache() {
        return this.cacheManager.getCache("namespace-uri-cache");
    }

    public Cache getNamespacePrefixCache() {
        return this.cacheManager.getCache("namespace-prefix-cache");
    }

    public synchronized Cache getCacheByName(String name) {
        if (!this.cacheManager.cacheExists(name)) {
            this.cacheManager.addCache(name);
        }
        return this.cacheManager.getCache(name);
    }

    public KiWiQueryCache getQueryCache() {
        return this.queryCache;
    }

    public void clear() {
        this.cacheManager.clearAll();
    }

    public void shutdown() {
        this.cacheManager.shutdown();
    }
}

