/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r5d\u0001B\u001f?\u0001\rC\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u00199\u0007\u0001)A\u00057\"9\u0001\u000e\u0001a\u0001\n\u0013I\u0007\"\u0003B\u0003\u0001\u0001\u0007I\u0011\u0002B\u0004\u0011\u001d\u0011\t\u0002\u0001Q!\n)D\u0011Ba\u0007\u0001\u0005\u0004%IA!\b\t\u0011\t-\u0002\u0001)A\u0005\u0005?AqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"9!1\u0012\u0001\u0005\u0002\t5\u0005\"\u0003BT\u0001E\u0005I\u0011\u0001BU\u0011%\u0011i\u000bAI\u0001\n\u0003\u0011I\u000bC\u0004\u00030\u0002!\tA!-\t\u000f\tM\u0006\u0001\"\u0001\u00036\"9!q\u0016\u0001\u0005\n\t}\u0006b\u0002BZ\u0001\u0011%!1\u0019\u0005\b\u0005\u0017\u0004A\u0011\u0001Bg\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005'DqAa6\u0001\t\u0003\u0011I\u000eC\u0004\u0003^\u0002!IAa8\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!q\u001f\u0001\u0005\u0002\te\bbBB\u0001\u0001\u0011\u0005\u0011q\b\u0005\b\u0007\u0007\u0001A\u0011AB\u0003\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+Aqaa\n\u0001\t\u0003\u0019I\u0003C\u0004\u0004(\u0001!\ta!\f\t\u000f\rM\u0002\u0001\"\u0003\u00046\u0019!A\u000e\u0001!n\u0011!!\bE!f\u0001\n\u0003)\b\"CA\u001eA\tE\t\u0015!\u0003w\u0011)\ti\u0004\tBK\u0002\u0013\u0005\u0011q\b\u0005\u000b\u0003\u000f\u0002#\u0011#Q\u0001\n\u0005\u0005\u0003BCA%A\tU\r\u0011\"\u0001\u0002L!Q\u00111\f\u0011\u0003\u0012\u0003\u0006I!!\u0014\t\u0015\u0005u\u0003E!f\u0001\n\u0003\ty\u0006\u0003\u0006\u0002\u0000\u0001\u0012\t\u0012)A\u0005\u0003CBa\u0001\u0016\u0011\u0005\u0002\u0005\u0005\u0005\"CAFA\u0005\u0005I\u0011AAG\u0011%\t9\nII\u0001\n\u0003\tI\nC\u0005\u00020\u0002\n\n\u0011\"\u0001\u00022\"I\u0011Q\u0017\u0011\u0012\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003w\u0003\u0013\u0013!C\u0001\u0003{C\u0011\"!1!\u0003\u0003%\t%a1\t\u0013\u0005=\u0007%!A\u0005\u0002\u0005E\u0007\"CAjA\u0005\u0005I\u0011AAk\u0011%\t\t\u000fIA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002l\u0002\n\t\u0011\"\u0001\u0002n\"I\u0011q\u001f\u0011\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0003w\u0004\u0013\u0011!C!\u0003{D\u0011\"a@!\u0003\u0003%\tE!\u0001\b\u0013\ru\u0002!!A\t\u0002\r}b\u0001\u00037\u0001\u0003\u0003E\ta!\u0011\t\rQCD\u0011AB(\u0011%\tY\u0010OA\u0001\n\u000b\ni\u0010C\u0005\u0004Ra\n\t\u0011\"!\u0004T!I1Q\f\u001d\u0002\u0002\u0013\u00055q\f\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u000b\u0005}\u0002\u0015AB:feZ,'OC\u0001B\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001#K!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0019\te.\u001f*fMB\u00111JT\u0007\u0002\u0019*\u0011Q\nQ\u0001\u0006kRLGn]\u0005\u0003\u001f2\u0013q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\t)%+\u0003\u0002T\r\n\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\t1\u0006\f\u0005\u0002X\u00015\ta\bC\u0003Q\u0005\u0001\u0007\u0011+A\u000bqCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006dunY6\u0016\u0003m\u0003\"\u0001X3\u000e\u0003uS!AX0\u0002\u000b1|7m[:\u000b\u0005\u0001\f\u0017AC2p]\u000e,(O]3oi*\u0011!mY\u0001\u0005kRLGNC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019l&A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u0002-A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dW\u0002\n\u0001#\\3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0016\u0003)\u0004\"a\u001b\u0011\u000e\u0003\u0001\u0011\u0001#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0014\t\u0001\"e.\u001d\t\u0003\u000b>L!\u0001\u001d$\u0003\u000fA\u0013x\u000eZ;diB\u0011QI]\u0005\u0003g\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0002mB)q\u000f @\u0002\u00145\t\u0001P\u0003\u0002zu\u00069Q.\u001e;bE2,'BA>G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{b\u0014\u0011\"\u00118z%\u00164W*\u00199\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002\r6\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\u0011\u0015A\u0002\u001fs_>$h(C\u0002\u0002\f\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006\rB)q/!\u0006\u0002\u001a%\u0019\u0011q\u0003=\u0003\u000f1{gnZ'baB!\u00111DA\u001b\u001d\u0011\ti\"!\r\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003K\t9#\u0001\u0004d_6lwN\u001c\u0006\u0004\u0003\u0006%\"\u0002BA\u0016\u0003[\ta!\u00199bG\",'BAA\u0018\u0003\ry'oZ\u0005\u0005\u0003g\ty\"A\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\n\t\u0005]\u0012\u0011\b\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\t\u0019$a\b\u0002!A\f'\u000f^5uS>t7\u000b^1uKN\u0004\u0013\u0001D2p]R\u0014x\u000e\u001c7fe&#WCAA!!\u0011)\u00151I)\n\u0007\u0005\u0015cI\u0001\u0004PaRLwN\\\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002\u0019\u0005d\u0017N^3Ce>\\WM]:\u0016\u0005\u00055\u0003#B<\u0002\u0016\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U\u0003)A\u0004dYV\u001cH/\u001a:\n\t\u0005e\u00131\u000b\u0002\u0007\u0005J|7.\u001a:\u0002\u001b\u0005d\u0017N^3Ce>\\WM]:!\u0003)\tG.\u001b<f\u001d>$Wm]\u000b\u0003\u0003C\u0002Ra^A\u000b\u0003G\u0002\u0002\"!\u001a\u0002h\u0005-\u0014qO\u0007\u0002u&\u0019\u0011\u0011\u000e>\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002n\u0005MTBAA8\u0015\u0011\t\t(a\t\u0002\u000f9,Go^8sW&!\u0011QOA8\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\tI(a\u001f\u000e\u0005\u0005\r\u0012\u0002BA?\u0003G\u0011AAT8eK\u0006Y\u0011\r\\5wK:{G-Z:!)%Q\u00171QAC\u0003\u000f\u000bI\tC\u0003uS\u0001\u0007a\u000fC\u0004\u0002>%\u0002\r!!\u0011\t\u000f\u0005%\u0013\u00061\u0001\u0002N!9\u0011QL\u0015A\u0002\u0005\u0005\u0014\u0001B2paf$\u0012B[AH\u0003#\u000b\u0019*!&\t\u000fQT\u0003\u0013!a\u0001m\"I\u0011Q\b\u0016\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003\u0013R\u0003\u0013!a\u0001\u0003\u001bB\u0011\"!\u0018+!\u0003\u0005\r!!\u0019\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0014\u0016\u0004m\u0006u5FAAP!\u0011\t\t+a+\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%f)\u0001\u0006b]:|G/\u0019;j_:LA!!,\u0002$\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0017\u0016\u0005\u0003\u0003\ni*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e&\u0006BA'\u0003;\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002@*\"\u0011\u0011MAO\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0019\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111Z2\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\tI-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001R\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a6\u0002^B\u0019Q)!7\n\u0007\u0005mgIA\u0002B]fD\u0001\"a82\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\bCBA3\u0003O\f9.C\u0002\u0002jj\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q^A{!\r)\u0015\u0011_\u0005\u0004\u0003g4%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003?\u001c\u0014\u0011!a\u0001\u0003/\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002#\u0006AAo\\*ue&tw\r\u0006\u0002\u0002F\u00061Q-];bYN$B!a<\u0003\u0004!I\u0011q\u001c\u001c\u0002\u0002\u0003\u0007\u0011q[\u0001\u0015[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R|F%Z9\u0015\t\t%!q\u0002\t\u0004\u000b\n-\u0011b\u0001B\u0007\r\n!QK\\5u\u0011!\tyNBA\u0001\u0002\u0004Q\u0017!E7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8uA!\u001aqA!\u0006\u0011\u0007\u0015\u00139\"C\u0002\u0003\u001a\u0019\u0013\u0001B^8mCRLG.Z\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014XC\u0001B\u0010!\u0011\u0011\tCa\n\u000e\u0005\t\r\"b\u0001B\u0013\u0001\u0006Q1m\u001c8ue>dG.\u001a:\n\t\t%\"1\u0005\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018AE:uCR,7\t[1oO\u0016dunZ4fe\u0002\nAbZ3u\u000b:$\u0007o\\5oiN$\"B!\r\u00038\tm\"\u0011\u000bB+!\u0019\t)Ga\r\u0002x%\u0019!Q\u0007>\u0003\u0007M+\u0017\u000f\u0003\u0004\u0003:)\u0001\rA[\u0001\tg:\f\u0007o\u001d5pi\"9!Q\b\u0006A\u0002\t}\u0012a\u00022s_.,'o\u001d\t\u0006\u0005\u0003\u0012Y%\u0015\b\u0005\u0005\u0007\u00129E\u0004\u0003\u0002\u0004\t\u0015\u0013\"A$\n\u0007\t%c)A\u0004qC\u000e\\\u0017mZ3\n\t\t5#q\n\u0002\t\u0013R,'/\u00192mK*\u0019!\u0011\n$\t\u000f\tM#\u00021\u0001\u0002l\u0005aA.[:uK:,'OT1nK\"9!q\u000b\u0006A\u0002\u0005=\u0018A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\u0018\u0001F4fiB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0007\u0003^\t=$\u0011\u000fB;\u0005o\u0012Y\bE\u0003F\u0003\u0007\u0012y\u0006\u0005\u0004\u0003B\t-#\u0011\r\t\u0005\u0005G\u0012IG\u0004\u0003\u0002\u001e\t\u0015\u0014\u0002\u0002B4\u0003?\t\u0001#T3uC\u0012\fG/\u0019*fgB|gn]3\n\t\t-$Q\u000e\u0002\u0012!\u0006\u0014H/\u001b;j_:lU\r^1eCR\f'\u0002\u0002B4\u0003?AaA!\u000f\f\u0001\u0004Q\u0007B\u0002B:\u0017\u0001\u0007a0A\u0003u_BL7\rC\u0004\u0003T-\u0001\r!a\u001b\t\u000f\te4\u00021\u0001\u0002p\u0006IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t\u0011\u001d\u0011ih\u0003a\u0001\u0003_\f\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3MSN$XM\\3sg\u0006\u0001r-\u001a;BY&4X-\u00128ea>Lg\u000e\u001e\u000b\t\u0005\u0007\u0013)Ia\"\u0003\nB)Q)a\u0011\u0002x!1!\u0011\b\u0007A\u0002)DQ\u0001\u0015\u0007A\u0002ECqAa\u0015\r\u0001\u0004\tY'\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRQ!q\u0012BL\u0005C\u0013\u0019K!*\u0011\r\u0005\u0015$1\u0007BI!\u0011\u0011\u0019Ga%\n\t\tU%Q\u000e\u0002\u000e)>\u0004\u0018nY'fi\u0006$\u0017\r^1\t\u000f\teU\u00021\u0001\u0003\u001c\u00061Ao\u001c9jGN\u0004R!!\u001a\u0003\u001ezL1Aa({\u0005\r\u0019V\r\u001e\u0005\b\u0005'j\u0001\u0019AA6\u0011%\u0011I(\u0004I\u0001\u0002\u0004\ty\u000fC\u0005\u0003~5\u0001\n\u00111\u0001\u0002p\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0016\u0016\u0005\u0003_\fi*\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$C'\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0002\u0003\u001c\u0006\u0001r-\u001a;BY2\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0005o\u0003b!!\u001a\u0003\u001e\ne\u0006\u0003BA=\u0005wKAA!0\u0002$\tqAk\u001c9jGB\u000b'\u000f^5uS>tG\u0003\u0002BN\u0005\u0003DaA!\u000f\u0013\u0001\u0004QG\u0003\u0002Bc\u0005\u0013\u0004ra Bd\u0005s\u000bI\"\u0003\u0003\u0002j\u0005E\u0001B\u0002B\u001d'\u0001\u0007!.\u0001\u000bhKRtuN\\#ySN$\u0018N\\4U_BL7m\u001d\u000b\u0005\u00057\u0013y\rC\u0004\u0003\u001aR\u0001\rAa'\u0002\u001b%\u001c(I]8lKJ\fE.\u001b<f)\u0011\tyO!6\t\u000bA+\u0002\u0019A)\u0002\u001f\u001d,G/\u00117jm\u0016\u0014%o\\6feN,\"Aa7\u0011\r\u0005\u0015$1GA(\u0003a\tG\rZ(s+B$\u0017\r^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u000b\u0005\u0013\u0011\tOa9\u0003f\n%\b\"\u0002;\u0018\u0001\u00041\bB\u0002B:/\u0001\u0007a\u0010\u0003\u0004\u0003h^\u0001\r!U\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0003l^\u0001\r!!\u0007\u0002\u0013M$\u0018\r^3J]\u001a|\u0017\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\u0011\tPa=\u0003vB)Q)a\u0011\u0002\u001a!1!1\u000f\rA\u0002yDaAa:\u0019\u0001\u0004\t\u0016AG4fiB\u000b'\u000f^5uS>tG*Z1eKJ,e\u000e\u001a9pS:$H\u0003\u0003BB\u0005w\u0014iPa@\t\r\tM\u0014\u00041\u0001\u007f\u0011\u0019\u00119/\u0007a\u0001#\"9!1K\rA\u0002\u0005-\u0014aD4fi\u000e{g\u000e\u001e:pY2,'/\u00133\u0002%\u001d,Go\u00117vgR,'/T3uC\u0012\fG/\u0019\u000b\u0007\u0007\u000f\u0019ia!\u0005\u0011\t\u0005e4\u0011B\u0005\u0005\u0007\u0017\t\u0019CA\u0004DYV\u001cH/\u001a:\t\r\r=1\u00041\u0001\u007f\u0003%\u0019G.^:uKJLE\rC\u0004\u0003Tm\u0001\r!a\u001b\u0002\u001dU\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCR11qCB\r\u0007;\u0001b!!\u001a\u00034\te\u0006BBB\u000e9\u0001\u0007\u0011+A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\b\u0007?a\u0002\u0019AB\u0011\u0003U)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004B!!\b\u0004$%!1QEA\u0010\u0005U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003_\u001cY\u0003\u0003\u0004\u0003tu\u0001\rA \u000b\u0005\u0003_\u001cy\u0003C\u0004\u00042y\u0001\rA!/\u0002\u0005Q\u0004\u0018a\u0005:f[>4X\rU1si&$\u0018n\u001c8J]\u001a|G\u0003CAx\u0007o\u0019Ida\u000f\t\u000bQ|\u0002\u0019\u0001<\t\r\tMt\u00041\u0001\u007f\u0011\u0019\u00119o\ba\u0001#\u0006\u0001R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e\t\u0003Wb\u001aB\u0001OB\"cBa1QIB&m\u0006\u0005\u0013QJA1U6\u00111q\t\u0006\u0004\u0007\u00132\u0015a\u0002:v]RLW.Z\u0005\u0005\u0007\u001b\u001a9EA\tBEN$(/Y2u\rVt7\r^5p]R\"\"aa\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013)\u001c)fa\u0016\u0004Z\rm\u0003\"\u0002;<\u0001\u00041\bbBA\u001fw\u0001\u0007\u0011\u0011\t\u0005\b\u0003\u0013Z\u0004\u0019AA'\u0011\u001d\tif\u000fa\u0001\u0003C\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004b\r%\u0004#B#\u0002D\r\r\u0004CC#\u0004fY\f\t%!\u0014\u0002b%\u00191q\r$\u0003\rQ+\b\u000f\\35\u0011!\u0019Y\u0007PA\u0001\u0002\u0004Q\u0017a\u0001=%a\u0001")
public class MetadataCache
implements Logging {
    private volatile MetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public MetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(MetadataSnapshot snapshot, Iterable<Object> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(snapshot, brokerId, listenerName);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long partitionId = tuple2._1$mcJ$sp();
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.basePartitionState.leader;
            int leaderEpoch = partitionState.basePartitionState.leaderEpoch;
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            Buffer replicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom());
            Seq<Node> replicaInfo = this.getEndpoints(snapshot, (Iterable<Object>)replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints(snapshot, (Iterable<Object>)((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom())), listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                Errors errors;
                if (!snapshot.aliveBrokers().contains((long)$this.brokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" not found on leader ").append(leaderBrokerId).toString());
                    errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors;
                partitionMetadata = new MetadataResponse.PartitionMetadata(error, (int)partitionId, Node.noNode(), Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                Buffer isr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom());
                Seq<Node> isrInfo = this.getEndpoints(snapshot, (Iterable<Object>)isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(74).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom());
                        return new StringBuilder(82).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append(new StringBuilder(18).append("following brokers ").append(((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, (int)partitionId, leader, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((Object)listenerName));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic.isInternal((String)topic), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    public Set<TopicPartition> getAllPartitions() {
        return ((TraversableOnce)this.metadataSnapshot().partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topicName = (String)tuple2._1();
            LongMap partitionsAndStates = (LongMap)tuple2._2();
            Iterable iterable = (Iterable)partitionsAndStates.keys().map((Function1 & Serializable & scala.Serializable)partitionId -> MetadataCache.$anonfun$getAllPartitions$2(topicName, BoxesRunTime.unboxToLong((Object)partitionId)), scala.collection.Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            LongMap partitionStates = (LongMap)tuple2._2();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long partition = tuple2._1$mcJ$sp();
                UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.$minus$minus((GenTraversableOnce)this.metadataSnapshot().partitionStates().keySet());
    }

    public boolean isBrokerAlive(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    public Seq<Broker> getAliveBrokers() {
        return this.metadataSnapshot().aliveBrokers().values().toBuffer();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequest.PartitionState stateInfo) {
        LongMap infos = (LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        infos.update((long)partitionId, (Object)stateInfo);
    }

    public Option<UpdateMetadataRequest.PartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get((long)partitionId));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.basePartitionState.leader;
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            Map nodes = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), nodes.get((Object)listenerName).orNull(Predef$.MODULE$.$conforms()));
            return tuple22;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$2(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), MetadataCache.node$1(Predef$.MODULE$.int2Integer(state.basePartitionState.leader), nodes), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$7(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)nodes.values().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$8(x$9)))).toList()).asJava(), (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitions.toList()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable & scala.Serializable)id -> MetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            LongMap aliveBrokers = new LongMap(this.metadataSnapshot().aliveBrokers().size());
            LongMap aliveNodes = new LongMap(this.metadataSnapshot().aliveNodes().size());
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            None$ controllerId = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateMetadata$2(aliveBrokers, aliveNodes, broker);
                return BoxedUnit.UNIT;
            });
            aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
                MetadataCache.$anonfun$updateMetadata$4(this, aliveNodes, listenerMap);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            if (updateMetadataRequest.partitionStates().isEmpty()) {
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, this.metadataSnapshot().partitionStates(), (Option<Object>)controllerId, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            } else {
                AnyRefMap partitionStates = new AnyRefMap(this.metadataSnapshot().partitionStates().size());
                this.metadataSnapshot().partitionStates().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String topic = (String)tuple2._1();
                    LongMap oldPartitionStates = (LongMap)tuple2._2();
                    LongMap copy = new LongMap(oldPartitionStates.size());
                    copy.$plus$plus$eq((TraversableOnce)oldPartitionStates);
                    AnyRefMap anyRefMap = partitionStates.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)copy));
                    return anyRefMap;
                });
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        UpdateMetadataRequest.PartitionState info = (UpdateMetadataRequest.PartitionState)tuple2._2();
                        int controllerId = updateMetadataRequest.controllerId();
                        int controllerEpoch = updateMetadataRequest.controllerEpoch();
                        if (info.basePartitionState.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                            this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)partitionStates, tp.topic(), tp.partition());
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append(new StringBuilder(55).append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                            boxedUnit = deletedPartitions.$plus$eq((Object)tp);
                        } else {
                            this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)partitionStates, tp.topic(), tp.partition(), info);
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Cached leader info ").append(info).append(" for partition ").append(tp).append(" in response to ").append(new StringBuilder(70).append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)partitionStates, (Option<Object>)controllerId, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            }
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new MetadataCache$MetadataSnapshot$(this);
            }
        }
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$2(String topicName$1, long partitionId) {
        return new TopicPartition(topicName$1, (int)partitionId);
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.get((long)Predef$.MODULE$.Integer2int(id)).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UpdateMetadataRequest.PartitionState state = (UpdateMetadataRequest.PartitionState)tuple2._2();
        boolean bl = state.basePartitionState.leader != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$7(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$8(Node x$9) {
        return x$9 != null;
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$2(LongMap aliveBrokers$1, LongMap aliveNodes$1, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        aliveBrokers$1.update((long)broker.id, (Object)new Broker(broker.id, (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        aliveNodes$1.update((long)broker.id, JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        Set set2 = listeners$1;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(MetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        block0: {
            Set listeners = listenerMap.keySet();
            if (aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$updateMetadata$5(listeners, x$10)))) break block0;
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        Object object = infos.isEmpty() ? partitionStates$2.remove((Object)topic$4) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>>)AnyRefMap$.MODULE$.empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ MetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$MetadataCache$MetadataSnapshot$$$outer(), partitionStates, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public Option<Object> copy$default$2() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$3() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$4() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap;
            int n = x$1;
            switch (n) {
                case 0: {
                    anyRefMap = this.partitionStates();
                    break;
                }
                case 1: {
                    anyRefMap = this.controllerId();
                    break;
                }
                case 2: {
                    anyRefMap = this.aliveBrokers();
                    break;
                }
                case 3: {
                    anyRefMap = this.aliveNodes();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return anyRefMap;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)object).kafka$server$MetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$MetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetadataCache kafka$server$MetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(MetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequest.PartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

