/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Iterator;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e!B\f\u0019\u0001aa\u0002\u0002C\u0012\u0001\u0005\u000b\u0007I\u0011A\u0013\t\u0011%\u0002!\u0011!Q\u0001\n\u0019B\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005Y!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011\u00159\u0004\u0001\"\u00019\u0011\u001di\u0004A1A\u0005\nyBaA\u0013\u0001!\u0002\u0013y\u0004bB&\u0001\u0005\u0004%Ia\u000b\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002\u0017\t\u000b5\u0003A\u0011\u0002(\t\u000bq\u0003A\u0011B/\t\u000b}\u0003A\u0011\u00021\t\u000b\u0011\u0004A\u0011B3\t\u000b5\u0004A\u0011\u00018\t\r5\u0004A\u0011AA\u0005\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAa!a\u000f\u0001\t\u0003Y\u0003bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\ti\u0007\u0001C!\u0003_\u0012!\u0003\u0015:pIV\u001cWM]!qa\u0016tG-\u00138g_*\u0011\u0011DG\u0001\u0004Y><'\"A\u000e\u0002\u000b-\fgm[1\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0006qe>$WoY3s\u0013\u0012\u001c\u0001!F\u0001'!\tqr%\u0003\u0002)?\t!Aj\u001c8h\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002\u0019\r,(O]3oi\u0016sGO]=\u0016\u00031\u0002\"!\f\u0018\u000e\u0003aI!a\f\r\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/_\u0001\u000eGV\u0014(/\u001a8u\u000b:$(/\u001f\u0011\u0002\u001dY\fG.\u001b3bi&|g\u000eV=qKV\t1\u0007\u0005\u0002.i%\u0011Q\u0007\u0007\u0002\u000f-\u0006d\u0017\u000eZ1uS>tG+\u001f9f\u0003=1\u0018\r\\5eCRLwN\u001c+za\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003:umb\u0004CA\u0017\u0001\u0011\u0015\u0019s\u00011\u0001'\u0011\u0015Qs\u00011\u0001-\u0011\u0015\tt\u00011\u00014\u00031!(/\u00198tC\u000e$\u0018n\u001c8t+\u0005y\u0004c\u0001!F\u000f6\t\u0011I\u0003\u0002C\u0007\u00069Q.\u001e;bE2,'B\u0001# \u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\r\u0006\u0013!\u0002T5ti\n+hMZ3s!\ti\u0003*\u0003\u0002J1\tYA\u000b\u001f8NKR\fG-\u0019;b\u00035!(/\u00198tC\u000e$\u0018n\u001c8tA\u0005aQ\u000f\u001d3bi\u0016$WI\u001c;ss\u0006iQ\u000f\u001d3bi\u0016$WI\u001c;ss\u0002\n1#\\1zE\u00164\u0016\r\\5eCR,\u0017\t\u001d9f]\u0012$2a\u0014*X!\tq\u0002+\u0003\u0002R?\t!QK\\5u\u0011\u0015\u0019F\u00021\u0001U\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0011a$V\u0005\u0003-~\u0011Qa\u00155peRDQ\u0001\u0017\u0007A\u0002e\u000b\u0001BZ5sgR\u001cV-\u001d\t\u0003=iK!aW\u0010\u0003\u0007%sG/\u0001\ndQ\u0016\u001c7\u000e\u0015:pIV\u001cWM]#q_\u000eDGCA(_\u0011\u0015\u0019V\u00021\u0001U\u00035\u0019\u0007.Z2l'\u0016\fX/\u001a8dKR\u0019q*\u00192\t\u000bMs\u0001\u0019\u0001+\t\u000b\rt\u0001\u0019A-\u0002\u001d\u0005\u0004\b/\u001a8e\r&\u00148\u000f^*fc\u0006Q\u0011N\\*fcV,gnY3\u0015\u0007\u0019L7\u000e\u0005\u0002\u001fO&\u0011\u0001n\b\u0002\b\u0005>|G.Z1o\u0011\u0015Qw\u00021\u0001Z\u0003\u001da\u0017m\u001d;TKFDQ\u0001\\\bA\u0002e\u000bqA\\3yiN+\u0017/\u0001\u0004baB,g\u000e\u001a\u000b\u0003_V\u00042A\b9s\u0013\t\txD\u0001\u0004PaRLwN\u001c\t\u0003[ML!\u0001\u001e\r\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000bY\u0004\u0002\u0019A<\u0002\u000b\t\fGo\u00195\u0011\u0007a\f)!D\u0001z\u0015\tQ80\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003yv\faaY8n[>t'BA\u000e\u007f\u0015\ry\u0018\u0011A\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0011aA8sO&\u0019\u0011qA=\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u000b\u0010\u001f\u0006-\u0011qBA\t\u0003'\t9\"a\u0007\u0002 !1\u0011QB\tA\u0002Q\u000bQ!\u001a9pG\"DQ\u0001W\tA\u0002eCQA[\tA\u0002eCa!!\u0006\u0012\u0001\u00041\u0013!\u00047bgR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0004\u0002\u001aE\u0001\rAJ\u0001\fM&\u00148\u000f^(gMN,G\u000f\u0003\u0004\u0002\u001eE\u0001\rAJ\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\bBBA\u0011#\u0001\u0007a-A\bjgR\u0013\u0018M\\:bGRLwN\\1m\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015\u0013I\f9#!\r\u00024\u0005]\u0002bBA\u0015%\u0001\u0007\u00111F\u0001\rK:$G\u000b\u001f8NCJ\\WM\u001d\t\u0004q\u00065\u0012bAA\u0018s\n!RI\u001c3Ue\u0006t7/Y2uS>tW*\u0019:lKJDQa\u0015\nA\u0002QCa!!\u000e\u0013\u0001\u00041\u0013AB8gMN,G\u000f\u0003\u0004\u0002:I\u0001\rAJ\u0001\ni&lWm\u001d;b[B\fq\u0001^8F]R\u0014\u00180A\nti\u0006\u0014H/\u001a3Ue\u0006t7/Y2uS>t7/\u0006\u0002\u0002BA)\u00111IA*\u000f:!\u0011QIA(\u001d\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&I\u00051AH]8pizJ\u0011\u0001I\u0005\u0004\u0003#z\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003+\n9F\u0001\u0003MSN$(bAA)?\u0005\u0001S.Y=cK\u000e\u000b7\r[3Uq:4\u0015N]:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b)\ry\u0015Q\f\u0005\b\u0003?*\u0002\u0019AA1\u0003EawnZ(gMN,G/T3uC\u0012\fG/\u0019\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011q\r\u000e\u0002\rM,'O^3s\u0013\u0011\tY'!\u001a\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-\u0001\u0005u_N#(/\u001b8h)\t\t\t\b\u0005\u0003\u0002t\u0005md\u0002BA;\u0003o\u00022!a\u0012 \u0013\r\tIhH\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0014q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005et\u0004")
public class ProducerAppendInfo {
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq) {
        ValidationType validationType = this.validationType();
        if (ValidationType$None$.MODULE$.equals(validationType)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$EpochOnly$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$Full$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch);
            this.checkSequence(producerEpoch, firstSeq);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)validationType);
        }
    }

    private void checkProducerEpoch(short producerEpoch) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            throw new ProducerFencedException(new StringBuilder(72).append("Producer's epoch is no longer valid. There is probably another producer ").append(new StringBuilder(53).append("with a newer epoch. ").append(producerEpoch).append(" (request epoch), ").append(this.updatedEntry().producerEpoch()).append(" (server epoch)").toString()).toString());
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq) {
        if (producerEpoch != this.updatedEntry().producerEpoch()) {
            if (appendFirstSeq != 0) {
                if (this.updatedEntry().producerEpoch() != -1) {
                    throw new OutOfOrderSequenceException(new StringBuilder(40).append("Invalid sequence number for new epoch: ").append(producerEpoch).append(" ").append(new StringBuilder(31).append("(request epoch), ").append(appendFirstSeq).append(" (seq. number)").toString()).toString());
                }
                throw new UnknownProducerIdException(new StringBuilder(61).append("Found no record of producerId=").append(this.producerId()).append(" on the broker. It is possible ").append(new StringBuilder(95).append("that the last message with the producerId=").append(this.producerId()).append(" has been removed due to hitting the retention limit.").toString()).toString());
            }
        } else {
            int currentLastSeq;
            int n = !this.updatedEntry().isEmpty() ? this.updatedEntry().lastSeq() : (currentLastSeq = producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1);
            if (currentLastSeq == -1 && appendFirstSeq != 0) {
                throw new UnknownProducerIdException(new StringBuilder(45).append("Local producer state matches expected epoch ").append(producerEpoch).append(" ").append(new StringBuilder(64).append("for producerId=").append(this.producerId()).append(", but next expected sequence number is not known.").toString()).toString());
            }
            if (!this.inSequence(currentLastSeq, appendFirstSeq)) {
                throw new OutOfOrderSequenceException(new StringBuilder(47).append("Out of order sequence number for producerId ").append(this.producerId()).append(": ").append(appendFirstSeq).append(" ").append(new StringBuilder(54).append("(incoming seq. number), ").append(currentLastSeq).append(" (current end sequence number)").toString()).toString());
            }
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.baseOffset(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long firstOffset, long lastOffset, boolean isTransactional) {
        this.maybeValidateAppend(epoch, firstSeq);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder(43).append("Expected transactional write from producer ").append(this.producerId()).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        this.checkProducerEpoch(producerEpoch);
        if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            throw new TransactionCoordinatorFencedException(new StringBuilder(28).append("Invalid coordinator epoch: ").append(endTxnMarker.coordinatorEpoch()).append(" ").append(new StringBuilder(20).append("(zombie), ").append(this.updatedEntry().coordinatorEpoch()).append(" (current)").toString()).toString());
        }
        this.updatedEntry().maybeUpdateEpoch(producerEpoch);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some) {
            long txnFirstOffset;
            Some some = (Some)option;
            l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1 & Serializable & scala.Serializable)txn -> {
            ProducerAppendInfo.$anonfun$maybeCacheTxnFirstOffsetMetadata$1(logOffsetMetadata, txn);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return new StringBuilder(19).append("ProducerAppendInfo(").append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.updatedEntry().producerEpoch()).append(", ").toString()).append(new StringBuilder(16).append("firstSequence=").append(this.updatedEntry().firstSeq()).append(", ").toString()).append(new StringBuilder(15).append("lastSequence=").append(this.updatedEntry().lastSeq()).append(", ").toString()).append(new StringBuilder(24).append("currentTxnFirstOffset=").append(this.updatedEntry().currentTxnFirstOffset()).append(", ").toString()).append(new StringBuilder(19).append("coordinatorEpoch=").append(this.updatedEntry().coordinatorEpoch()).append(", ").toString()).append(new StringBuilder(21).append("startedTransactions=").append(this.transactions()).append(")").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$maybeCacheTxnFirstOffsetMetadata$1(LogOffsetMetadata logOffsetMetadata$1, TxnMetadata txn) {
        block0: {
            if (txn.firstOffset().messageOffset() != logOffsetMetadata$1.messageOffset()) break block0;
            txn.firstOffset_$eq(logOffsetMetadata$1);
        }
    }

    public ProducerAppendInfo(long producerId, ProducerStateEntry currentEntry, ValidationType validationType) {
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

