/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\t}h\u0001B\u001e=\u0001\u0005C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\t?\u0002\u0011)\u0019!C\u0001A\"AQ\u000f\u0001B\u0001B\u0003%\u0011\r\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001x\u0011%\t\u0019\u0002\u0001B\u0001B\u0003%\u0001\u0010\u0003\u0006\u0002\u0016\u0001\u0011)\u0019!C\u0001\u0003/A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t\t\u0003\u0001B\u0001B\u0003%\u00111\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty\u0004C\u0005\u0002B\u0001\u0001\r\u0011\"\u0003\u0002D!9\u0011q\n\u0001!B\u0013Y\u0006BCA-\u0001\t\u0007I\u0011\u0001\u001f\u0002\\!A\u00111\r\u0001!\u0002\u0013\ti\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0007C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002t!A!q\u0004\u0001!\u0002\u0013\t)\bC\u0004\u0003\"\u0001!\t!!7\t\u000f\t\r\u0002\u0001\"\u0001\u0002Z\"9!Q\u0005\u0001\u0005B\t\u001d\u0002b\u0002B\u0019\u0001\u0011\u0005#1\u0007\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqAa\u0014\u0001\t\u0003\u0011\t\u0006C\u0004\u0003X\u0001!\tA!\u0017\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003h!9!Q\u000e\u0001\u0005\u0002\t=\u0004b\u0002B=\u0001\u0011\u0005!1\u0010\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001fC\u0011B!'\u0001#\u0003%\tAa'\t\u000f\tE\u0006\u0001\"\u0001\u00034\"A!Q\u0018\u0001\u0005\u0002y\ny\u0004\u0003\u0005\u0003@\u0002!\t\u0001\u0010Ba\r\u0019\tI\t\u0001\u0003\u0002\f\"Q\u00111\u0013\u0013\u0003\u0002\u0003\u0006I!!&\t\u000f\u00055B\u0005\"\u0001\u0002\u001c\"9\u0011q\u0014\u0013\u0005R\u0005\u0005\u0006\"CAXI\t\u0007I\u0011AAY\u0011!\tI\f\nQ\u0001\n\u0005M\u0006\"CA^I\u0001\u0007I\u0011AA_\u0011%\t)\r\na\u0001\n\u0003\t9\r\u0003\u0005\u0002L\u0012\u0002\u000b\u0015BA`\u0011\u001d\ty\r\nC\u0005\u0003#Dq!a6%\t\u0003\nI\u000eC\u0004\u0002\\\u0012\"I!!8\t\u000f\u0005\u0015H\u0005\"\u0003\u0002h\"9\u00111\u001f\u0013\u0005\u0002\u0005Uxa\u0002Bby!\u0005!Q\u0019\u0004\u0007wqB\tAa2\t\u000f\u000552\u0007\"\u0001\u0003J\"I!1Z\u001aC\u0002\u0013\u0005!Q\u001a\u0005\t\u0005#\u001c\u0004\u0015!\u0003\u0003P\"9!1[\u001a\u0005\u0002\tU\u0007b\u0002Bmg\u0011\u0005!1\u001c\u0005\b\u0005S\u001cD\u0011\u0001Bv\u0011%\u0011IpMI\u0001\n\u0003\u0011YP\u0001\u0006M_\u001e\u001cE.Z1oKJT!!\u0010 \u0002\u00071|wMC\u0001@\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019R\u0001\u0001\"I\u001dR\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013a!\u00118z%\u00164\u0007CA%M\u001b\u0005Q%BA&?\u0003\u0015)H/\u001b7t\u0013\ti%JA\u0004M_\u001e<\u0017N\\4\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Es\u0014aB7fiJL7m]\u0005\u0003'B\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\t)\u0006,D\u0001W\u0015\t9f(\u0001\u0004tKJ4XM]\u0005\u00033Z\u0013AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017!D5oSRL\u0017\r\\\"p]\u001aLw\r\u0005\u0002];6\tA(\u0003\u0002_y\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001e\fq\u0001\\8h\t&\u00148/F\u0001b!\r\u0011'.\u001c\b\u0003G\"t!\u0001Z4\u000e\u0003\u0015T!A\u001a!\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0015BA5E\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\u0007M+\u0017O\u0003\u0002j\tB\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0003S>T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n!a)\u001b7f\u0003!awn\u001a#jeN\u0004\u0013\u0001\u00027pON,\u0012\u0001\u001f\t\u0006\u0013f\\\u0018QB\u0005\u0003u*\u0013A\u0001U8pYB\u0019A0!\u0003\u000e\u0003uT!A`@\u0002\r\r|W.\\8o\u0015\ry\u0014\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\t1a\u001c:h\u0013\r\tY! \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\ra\u0016qB\u0005\u0004\u0003#a$a\u0001'pO\u0006)An\\4tA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\"!!\u0007\u0011\u0007U\u000bY\"C\u0002\u0002\u001eY\u0013A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eI\u0001\u0005i&lW\r\u0005\u0003\u0002&\u0005%RBAA\u0014\u0015\tYU0\u0003\u0003\u0002,\u0005\u001d\"\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003DA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0002C\u0001/\u0001\u0011\u0015Q\u0016\u00021\u0001\\\u0011\u0015y\u0016\u00021\u0001b\u0011\u00151\u0018\u00021\u0001y\u0011\u001d\t)\"\u0003a\u0001\u00033A\u0011\"!\t\n!\u0003\u0005\r!a\t\u0002\r\r|gNZ5h+\u0005Y\u0016AC2p]\u001aLwm\u0018\u0013fcR!\u0011QIA&!\r\u0019\u0015qI\u0005\u0004\u0003\u0013\"%\u0001B+oSRD\u0001\"!\u0014\f\u0003\u0003\u0005\raW\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\r\t\u0015\u0004\u0019\u0005M\u0003cA\"\u0002V%\u0019\u0011q\u000b#\u0003\u0011Y|G.\u0019;jY\u0016\fab\u00197fC:,'/T1oC\u001e,'/\u0006\u0002\u0002^A\u0019A,a\u0018\n\u0007\u0005\u0005DHA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fqb\u00197fC:,'/T1oC\u001e,'\u000fI\u0001\ni\"\u0014x\u000e\u001e;mKJ,\"!!\u001b\u0011\u0007%\u000bY'C\u0002\u0002n)\u0013\u0011\u0002\u00165s_R$H.\u001a:\u0002\u0015QD'o\u001c;uY\u0016\u0014\b%\u0001\u0005dY\u0016\fg.\u001a:t+\t\t)\b\u0005\u0004\u0002x\u0005\u0005\u0015QQ\u0007\u0003\u0003sRA!a\u001f\u0002~\u00059Q.\u001e;bE2,'bAA@\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0015\u0011\u0010\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u0002\b\u0012j\u0011\u0001\u0001\u0002\u000e\u00072,\u0017M\\3s)\"\u0014X-\u00193\u0014\u0007\u0011\ni\tE\u0002J\u0003\u001fK1!!%K\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\u0011QD'/Z1e\u0013\u0012\u00042aQAL\u0013\r\tI\n\u0012\u0002\u0004\u0013:$H\u0003BAC\u0003;Cq!a%'\u0001\u0004\t)*\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!a)\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+r\u0003\u0011a\u0017M\\4\n\t\u00055\u0016q\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u000f\rdW-\u00198feV\u0011\u00111\u0017\t\u00049\u0006U\u0016bAA\\y\t91\t\\3b]\u0016\u0014\u0018\u0001C2mK\u0006tWM\u001d\u0011\u0002\u00131\f7\u000f^*uCR\u001cXCAA`!\ra\u0016\u0011Y\u0005\u0004\u0003\u0007d$\u0001D\"mK\u0006tWM]*uCR\u001c\u0018!\u00047bgR\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0003\u0002F\u0005%\u0007\"CA'W\u0005\u0005\t\u0019AA`\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u0015\u0004Y\u0005M\u0013!C2iK\u000e\\Gi\u001c8f)\u0011\t)%a5\t\r\u0005UW\u00061\u0001|\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0001Z8X_J\\GCAA#\u0003E\u0019G.Z1o\r&dG\u000f[5fgRdun\u001a\u000b\u0003\u0003?\u00042aQAq\u0013\r\t\u0019\u000f\u0012\u0002\b\u0005>|G.Z1o\u0003!\u0019G.Z1o\u0019><G\u0003BA#\u0003SDq!a;1\u0001\u0004\ti/A\u0005dY\u0016\fg.\u00192mKB\u0019A,a<\n\u0007\u0005EHH\u0001\u0006M_\u001e$vn\u00117fC:\f1B]3d_J$7\u000b^1ugRa\u0011QIA|\u0003w\u0014iAa\u0006\u0003\u001c!9\u0011\u0011`\u0019A\u0002\u0005U\u0015AA5e\u0011\u001d\ti0\ra\u0001\u0003\u007f\fAA\\1nKB!!\u0011\u0001B\u0005\u001d\u0011\u0011\u0019A!\u0002\u0011\u0005\u0011$\u0015b\u0001B\u0004\t\u00061\u0001K]3eK\u001aLA!!,\u0003\f)\u0019!q\u0001#\t\u000f\t=\u0011\u00071\u0001\u0003\u0012\u0005!aM]8n!\r\u0019%1C\u0005\u0004\u0005+!%\u0001\u0002'p]\u001eDqA!\u00072\u0001\u0004\u0011\t\"\u0001\u0002u_\"9!QD\u0019A\u0002\u0005}\u0016!B:uCR\u001c\u0018!C2mK\u0006tWM]:!\u0003\u001d\u0019H/\u0019:ukB\f\u0001b\u001d5vi\u0012|wO\\\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011I\u0003\u0005\u0004\u0003,\t5\u0012q`\u0007\u0003\u0003{JAAa\f\u0002~\t\u00191+\u001a;\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BA#\u0005kAqAa\u000e\u0017\u0001\u0004\u0011I$A\u0005oK^\u001cuN\u001c4jOB\u0019QKa\u000f\n\u0007\tubKA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$b!!\u0012\u0003D\t\u001d\u0003b\u0002B#/\u0001\u0007!\u0011H\u0001\n_2$7i\u001c8gS\u001eDqAa\u000e\u0018\u0001\u0004\u0011I$A\u0007bE>\u0014Ho\u00117fC:Lgn\u001a\u000b\u0005\u0003\u000b\u0012i\u0005\u0003\u0004\u0002Vb\u0001\ra_\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0003BA#\u0005'BaA!\u0016\u001a\u0001\u0004i\u0017a\u00023bi\u0006$\u0015N]\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u0002F\tm#Q\fB1\u0011\u0019\t)N\u0007a\u0001w\"1!q\f\u000eA\u00025\fAb]8ve\u000e,Gj\\4ESJDaAa\u0019\u001b\u0001\u0004i\u0017A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u0011Q\tB5\u0011\u001d\u0011Yg\u0007a\u0001\u0003\u007f\f1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002F\tE$1\u000fB;\u0011\u0019\u0011)\u0006\ba\u0001[\"1\u0011Q\u001b\u000fA\u0002mDqAa\u001e\u001d\u0001\u0004\u0011\t\"\u0001\u0004pM\u001a\u001cX\r^\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\t)E! \t\r\u0005UW\u00041\u0001|\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$B!!\u0012\u0003\u0004\"9!Q\u0011\u0010A\u0002\t\u001d\u0015a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\u000b\t-\"\u0011R>\n\t\t-\u0015Q\u0010\u0002\t\u0013R,'/\u00192mK\u0006a\u0011m^1ji\u000ecW-\u00198fIRA\u0011q\u001cBI\u0005'\u0013)\n\u0003\u0004\u0002V~\u0001\ra\u001f\u0005\b\u0005oz\u0002\u0019\u0001B\t\u0011%\u00119j\bI\u0001\u0002\u0004\u0011\t\"A\u0005nCb<\u0016-\u001b;Ng\u00061\u0012m^1ji\u000ecW-\u00198fI\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001e*\"!\u0011\u0003BPW\t\u0011\t\u000b\u0005\u0003\u0003$\n5VB\u0001BS\u0015\u0011\u00119K!+\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BV\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=&Q\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\n9bkN,7\t\\3b]&twMR8s\u001d>t7i\\7qC\u000e$X\r\u001a)beRLG/[8ogR\u0011!Q\u0017\t\u0007\u0005W\u0011IIa.\u0011\r\r\u0013Il_A\u0007\u0013\r\u0011Y\f\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u00031\u0019G.Z1oKJ\u001cu.\u001e8u+\t\t)*\u0001\u0006M_\u001e\u001cE.Z1oKJ\u0004\"\u0001X\u001a\u0014\u0005M\u0012EC\u0001Bc\u0003U\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"Aa4\u0011\r\t-\"QFAR\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!D2mK\u0006tWM]\"p]\u001aLw\rF\u0002\\\u0005/Dq!!\u00108\u0001\u0004\u0011I$A\fde\u0016\fG/\u001a(fo\u000ecW-\u00198fIN+w-\\3oiR1!Q\u001cBr\u0005K\u00042\u0001\u0018Bp\u0013\r\u0011\t\u000f\u0010\u0002\u000b\u0019><7+Z4nK:$\bBB\u001f9\u0001\u0004\ti\u0001C\u0004\u0003hb\u0002\rA!\u0005\u0002\u0015\t\f7/Z(gMN,G/A\fdC2\u001cW\u000f\\1uK\u000ecW-\u00198bE2,')\u001f;fgRA!Q\u001eBx\u0005c\u0014)\u0010E\u0004D\u0005s\u0013\tB!\u0005\t\ruJ\u0004\u0019AA\u0007\u0011\u001d\u0011\u00190\u000fa\u0001\u0005#\t\u0001CZ5sgR$\u0015N\u001d;z\u001f\u001a47/\u001a;\t\u000f\t]\u0018\b1\u0001\u0003\u0012\u0005\tRO\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011iP\u000b\u0003\u0002$\t}\u0005")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(Log log, long l, long l2) {
        return LogCleaner$.MODULE$.calculateCleanableBytes(log, l, l2);
    }

    public static LogSegment createNewCleanedSegment(Log log, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.kafka$log$LogCleaner$$cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.kafka$log$LogCleaner$$cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        CleanerConfig newCleanerConfig = LogCleaner$.MODULE$.cleanerConfig(newConfig);
        int numThreads = newCleanerConfig.numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.kafka$log$LogCleaner$$cleaners().size();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$2) {
                return (double)100 * x$2.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$4(x$4)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(x$5)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$4) {
                return x$4.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$5) {
                return x$5.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)$anon$3.$anonfun$value$7(x$7)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$7) {
                return x$7.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            block0: {
                boolean cleaned = this.cleanFilthiestLog();
                if (cleaned) break block0;
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean cleanFilthiestLog() {
            boolean bl;
            ObjectRef currentLog = ObjectRef.create((Object)None$.MODULE$);
            try {
                boolean bl2;
                Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time);
                if (None$.MODULE$.equals(option)) {
                    bl2 = false;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.value();
                    currentLog.elem = new Some((Object)cleanable.log());
                    this.cleanLog(cleanable);
                    bl2 = true;
                } else {
                    throw new MatchError(option);
                }
                boolean cleaned = bl2;
                Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                try {
                    deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(currentLog, x0$1)));
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
                }
                bl = cleaned;
            }
            catch (Throwable throwable) {
                Exception exception;
                Throwable throwable2 = throwable;
                boolean bl3 = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                if (bl3) {
                    throw throwable2;
                }
                if (throwable2 instanceof Exception) {
                    exception = (Exception)throwable2;
                    if (((Option)currentLog.elem).isEmpty()) {
                        throw new IllegalStateException("currentLog cannot be empty on an unexpected exception", exception);
                    }
                } else {
                    throw throwable;
                }
                Log erroneousLog = (Log)((Option)currentLog.elem).get();
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(erroneousLog).append(". Marking its partition (").append(erroneousLog.topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(erroneousLog.dir().getParent(), erroneousLog.topicPartition());
                boolean bl4 = false;
                bl = bl4;
            }
            return bl;
        }

        private void cleanLog(LogToClean cleanable) {
            long endOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                    Tuple2 tuple23 = tuple22;
                    long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                    CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                    endOffset = nextDirtyOffset2;
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().dir().getParent();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            block0: {
                this.lastStats_$eq(stats);
                String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                if (stats.invalidMessagesRead() <= 0L) break block0;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(ObjectRef currentLog$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Log log = (Log)tuple2._2();
            currentLog$1.elem = new Some((Object)log);
            int n = log.deleteOldSegments();
            return n;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        }
    }
}

