/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001%\u0011AER3uG\"\u0014V-];fgR$un\u001e8D_:4XM]:j_:\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(BA\u0003\u0007\u0003\u0015Y\u0017MZ6b\u0015\u00059\u0011\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\u00111!\u0004\u0006\u0002\u000b%\u0011q\u0002\u0004\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003)\u0001i\u0011A\u0001\u0005\b-\u0001\u0001\r\u0011\"\u0003\u0018\u0003!\u0001(o\u001c3vG\u0016\u0014X#\u0001\r\u0011\te\u0011C\u0005J\u0007\u00025)\u0011ac\u0007\u0006\u00039u\tqa\u00197jK:$8O\u0003\u0002\u0006=)\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0013\t\u0019#DA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\b_\u0001\u0001\r\u0011\"\u00031\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\t\tD\u0007\u0005\u0002'e%\u00111g\n\u0002\u0005+:LG\u000fC\u00046]\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u00048\u0001\u0001\u0006K\u0001G\u0001\naJ|G-^2fe\u0002BQ!\u000f\u0001\u0005Bi\n!B\\;n\u0005J|7.\u001a:t+\u0005Y\u0004C\u0001\u0014=\u0013\titEA\u0002J]RDQa\u0010\u0001\u0005B\u0001\u000bQa]3u+B$\u0012!\r\u0005\u0006\u0005\u0002!\t\u0005Q\u0001\ti\u0016\f'\u000fR8x]\")A\t\u0001C)\u000b\u0006\t\u0002O]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005E2\u0005\"B$D\u0001\u0004A\u0015A\u00039s_B,'\u000f^5fgB\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0005kRLGNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=S%A\u0003)s_B,'\u000f^5fg\")\u0011\u000b\u0001C\u0005\u0001\u0006a\u0011N\\5u!J|G-^2fe\")1\u000b\u0001C\u0005)\u0006a1M]3bi\u0016$v\u000e]5dgR)QK\u00181cKB!QE\u0016-<\u0013\t9VFA\u0002NCB\u0004\"!\u0017/\u000e\u0003iS!aW\u000f\u0002\r\r|W.\\8o\u0013\ti&L\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b}\u0013\u0006\u0019A\u001e\u0002\u00139,X\u000eV8qS\u000e\u001c\b\"B1S\u0001\u0004Y\u0014!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0004d%B\u0005\t\u0019\u00013\u0002\u000f\r|gNZ5hgB!QE\u0016\u0013%\u0011\u001d1'\u000b%AA\u0002m\n\u0001\u0003^8qS\u000e\u001cVO\u001a4jqN#\u0018M\u001d;\t\u000b!\u0004A\u0011B5\u0002%\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\u000b\u0006U^L\u0018q\u0002\t\u0005\u0013.DV.\u0003\u0002m\u0015\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"A\u001c;\u000f\u0005=\u0014X\"\u00019\u000b\u0005ET\u0016\u0001\u0003:fcV,7\u000f^:\n\u0005M\u0004\u0018\u0001\u0004$fi\u000eD'+Z9vKN$\u0018BA;w\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*\u00111\u000f\u001d\u0005\u0006q\u001e\u0004\raO\u0001\u0012[\u0006D\b+\u0019:uSRLwN\u001c\"zi\u0016\u001c\b\"\u0002>h\u0001\u0004Y\u0018a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\tq\fI\u0001\u0017\b\u0004{\u0006\u0015ab\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002!\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u0007\u0005\u001dq%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0011Q\u0002\u0002\u0004'\u0016\f(bAA\u0004O!I\u0011\u0011C4\u0011\u0002\u0003\u0007\u00111C\u0001\n_\u001a47/\u001a;NCB\u0004R!\n,Y\u0003+\u00012AJA\f\u0013\r\tIb\n\u0002\u0005\u0019>tw\rC\u0004\u0002\u001e\u0001!I!a\b\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$HCBA\u0011\u0003g\t9\u0004E\u0003p\u0003G\t9#C\u0002\u0002&A\u0014QBR3uG\"\u0014Vm\u001d9p]N,\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\",\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003c\tYCA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0003k\tY\u00021\u0001<\u0003!aW-\u00193fe&#\u0007\u0002CA\u001d\u00037\u0001\r!a\u000f\u0002\u000fI,\u0017/^3tiB\u0019q.!\u0010\n\u0007\u0005}\u0002O\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0003\u0004\u0002D\u0001!\t\u0001Q\u0001&i\u0016\u001cHOV\u0019GKR\u001c\u0007nV5uQ\u0012{wO\\\"p]Z,'o]5p]\u0012K7/\u00192mK\u0012DC!!\u0011\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u0001\nQA[;oSRLA!!\u0015\u0002L\t!A+Z:u\u0011\u0019\t)\u0006\u0001C\u0001\u0001\u0006IC/Z:u\u0019\u0006$Xm\u001d;GKR\u001c\u0007nV5uQ\u0012{wO\\\"p]Z,'o]5p]\u0012K7/\u00192mK\u0012DC!a\u0015\u0002H!1\u00111\f\u0001\u0005\u0002\u0001\u000b!\u0005^3tiZ\u000bd)\u001a;dQ^KG\u000f\u001b+pa&\u001cG*\u001a<fY>3XM\u001d:jI\u0016\u001c\b\u0006BA-\u0003\u000fBa!!\u0019\u0001\t\u0003\u0001\u0015A\u0006;fgR4\u0016GR3uG\"4%o\\7SKBd\u0017nY1)\t\u0005}\u0013q\t\u0005\n\u0003O\u0002\u0011\u0013!C\u0005\u0003S\nac\u0019:fCR,Gk\u001c9jGN$C-\u001a4bk2$HeM\u000b\u0003\u0003WR3\u0001ZA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=O\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAA\u0001E\u0005I\u0011BAB\u0003Y\u0019'/Z1uKR{\u0007/[2tI\u0011,g-Y;mi\u0012\"TCAACU\rY\u0014Q\u000e\u0005\n\u0003\u0013\u0003\u0011\u0013!C\u0005\u0003\u0017\u000bAd\u0019:fCR,\u0007+\u0019:uSRLwN\\'ba\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u000e*\"\u00111CA7\u0001")
public class FetchRequestDownConversionConfigTest
extends BaseRequestTest {
    private KafkaProducer<String, String> unit$kafka$server$FetchRequestDownConversionConfigTest$$producer = null;

    public KafkaProducer<String, String> unit$kafka$server$FetchRequestDownConversionConfigTest$$producer() {
        return this.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer;
    }

    private void unit$kafka$server$FetchRequestDownConversionConfigTest$$producer_$eq(KafkaProducer<String, String> x$1) {
        this.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer = x$1;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.initProducer();
    }

    @Override
    public void tearDown() {
        if (this.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer() != null) {
            this.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer().close();
        }
        super.tearDown();
    }

    @Override
    public void propertyOverrides(Properties properties) {
        super.propertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.LogMessageDownConversionEnableProp(), "false");
    }

    private void initProducer() {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = 5;
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = TestUtils$.MODULE$.createProducer$default$2();
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        long x$8 = TestUtils$.MODULE$.createProducer$default$6();
        long x$9 = TestUtils$.MODULE$.createProducer$default$7();
        SecurityProtocol x$10 = TestUtils$.MODULE$.createProducer$default$8();
        Option<File> x$11 = TestUtils$.MODULE$.createProducer$default$9();
        Option<Properties> x$12 = TestUtils$.MODULE$.createProducer$default$10();
        Option<Properties> x$13 = TestUtils$.MODULE$.createProducer$default$13();
        this.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$5, x$6, x$7, x$2, x$8, x$9, x$10, x$11, x$12, x$3, x$4, x$13));
    }

    private Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, Map<String, String> configs, int topicSuffixStart) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1)new Serializable(this, topicSuffixStart){
            public static final long serialVersionUID = 0L;
            private final int topicSuffixStart$1;

            public final String apply(int t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(t + this.topicSuffixStart$1))}));
            }
            {
                this.topicSuffixStart$1 = topicSuffixStart$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        configs.foreach((Function1)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final Properties topicConfig$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.topicConfig$1.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topicConfig$1 = topicConfig$1;
            }
        });
        return ((TraversableOnce)topics.flatMap((Function1)new Serializable(this, numPartitions, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestDownConversionConfigTest $outer;
            private final int numPartitions$1;
            private final Properties topicConfig$1;

            public final Map<TopicPartition, Object> apply(String topic) {
                Map<Object, Object> partitionToLeader = this.$outer.createTopic(topic, this.numPartitions$1, 1, this.topicConfig$1);
                return (Map)partitionToLeader.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int partition = tuple2._1$mcI$sp();
                            int leader2 = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic$1, partition)), (Object)BoxesRunTime.boxToInteger((int)leader2));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numPartitions$1 = numPartitions$1;
                this.topicConfig$1 = topicConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private int createTopics$default$4() {
        return 0;
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1)new Serializable(this, maxPartitionBytes, offsetMap, partitionMap){
            public static final long serialVersionUID = 0L;
            private final int maxPartitionBytes$1;
            private final Map offsetMap$1;
            private final LinkedHashMap partitionMap$1;

            public final FetchRequest.PartitionData apply(TopicPartition tp) {
                return this.partitionMap$1.put(tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)this.offsetMap$1.getOrElse((Object)tp, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })), 0L, this.maxPartitionBytes$1));
            }
            {
                this.maxPartitionBytes$1 = maxPartitionBytes$1;
                this.offsetMap$1 = offsetMap$1;
                this.partitionMap$1 = partitionMap$1;
            }
        });
        return partitionMap;
    }

    private Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    @Test
    public void testV1FetchWithDownConversionDisabled() {
        Map<TopicPartition, Object> topicMap = this.createTopics(5, 1, this.createTopics$default$3(), this.createTopics$default$4());
        Seq topicPartitions = topicMap.keySet().toSeq();
        topicPartitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestDownConversionConfigTest $outer;

            public final RecordMetadata apply(TopicPartition tp) {
                return (RecordMetadata)this.$outer.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)topicPartitions, this.createPartitionMap$default$3())).build((short)1);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(((Tuple2)topicMap.head())._2$mcI$sp(), fetchRequest);
        topicPartitions.foreach((Function1)new Serializable(this, fetchResponse){
            public static final long serialVersionUID = 0L;
            private final FetchResponse fetchResponse$1;

            public final void apply(TopicPartition tp) {
                Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)((FetchResponse.PartitionData)this.fetchResponse$1.responseData().get((Object)tp)).error);
            }
            {
                this.fetchResponse$1 = fetchResponse$1;
            }
        });
    }

    @Test
    public void testLatestFetchWithDownConversionDisabled() {
        Map<TopicPartition, Object> topicMap = this.createTopics(5, 1, this.createTopics$default$3(), this.createTopics$default$4());
        Seq topicPartitions = topicMap.keySet().toSeq();
        topicPartitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestDownConversionConfigTest $outer;

            public final RecordMetadata apply(TopicPartition tp) {
                return (RecordMetadata)this.$outer.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)topicPartitions, this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(((Tuple2)topicMap.head())._2$mcI$sp(), fetchRequest);
        topicPartitions.foreach((Function1)new Serializable(this, fetchResponse){
            public static final long serialVersionUID = 0L;
            private final FetchResponse fetchResponse$2;

            public final void apply(TopicPartition tp) {
                Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)this.fetchResponse$2.responseData().get((Object)tp)).error);
            }
            {
                this.fetchResponse$2 = fetchResponse$2;
            }
        });
    }

    @Test
    public void testV1FetchWithTopicLevelOverrides() {
        int x$14 = 5;
        int x$15 = 1;
        int x$16 = 0;
        Map<String, String> x$17 = this.createTopics$default$3();
        Map<TopicPartition, Object> conversionDisabledTopicsMap = this.createTopics(x$14, x$15, x$17, x$16);
        Seq conversionDisabledTopicPartitions = conversionDisabledTopicsMap.keySet().toSeq();
        Map topicConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true")}));
        Map<TopicPartition, Object> conversionEnabledTopicsMap = this.createTopics(5, 1, (Map<String, String>)topicConfig, 5);
        Seq conversionEnabledTopicPartitions = conversionEnabledTopicsMap.keySet().toSeq();
        Seq allTopics = (Seq)conversionDisabledTopicPartitions.$plus$plus((GenTraversableOnce)conversionEnabledTopicPartitions, Seq$.MODULE$.canBuildFrom());
        int leaderId = ((Tuple2)conversionDisabledTopicsMap.head())._2$mcI$sp();
        allTopics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestDownConversionConfigTest $outer;

            public final RecordMetadata apply(TopicPartition tp) {
                return (RecordMetadata)this.$outer.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)allTopics, this.createPartitionMap$default$3())).build((short)1);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId, fetchRequest);
        conversionDisabledTopicPartitions.foreach((Function1)new Serializable(this, fetchResponse){
            public static final long serialVersionUID = 0L;
            private final FetchResponse fetchResponse$3;

            public final void apply(TopicPartition tp) {
                Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)((FetchResponse.PartitionData)this.fetchResponse$3.responseData().get((Object)tp)).error);
            }
            {
                this.fetchResponse$3 = fetchResponse$3;
            }
        });
        conversionEnabledTopicPartitions.foreach((Function1)new Serializable(this, fetchResponse){
            public static final long serialVersionUID = 0L;
            private final FetchResponse fetchResponse$3;

            public final void apply(TopicPartition tp) {
                Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)this.fetchResponse$3.responseData().get((Object)tp)).error);
            }
            {
                this.fetchResponse$3 = fetchResponse$3;
            }
        });
    }

    @Test
    public void testV1FetchFromReplica() {
        int x$18 = 5;
        int x$19 = 1;
        int x$20 = 0;
        Map<String, String> x$21 = this.createTopics$default$3();
        Map<TopicPartition, Object> conversionDisabledTopicsMap = this.createTopics(x$18, x$19, x$21, x$20);
        Seq conversionDisabledTopicPartitions = conversionDisabledTopicsMap.keySet().toSeq();
        Map topicConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true")}));
        Map<TopicPartition, Object> conversionEnabledTopicsMap = this.createTopics(5, 1, (Map<String, String>)topicConfig, 5);
        Seq conversionEnabledTopicPartitions = conversionEnabledTopicsMap.keySet().toSeq();
        Seq allTopicPartitions = (Seq)conversionDisabledTopicPartitions.$plus$plus((GenTraversableOnce)conversionEnabledTopicPartitions, Seq$.MODULE$.canBuildFrom());
        int leaderId = ((Tuple2)conversionDisabledTopicsMap.head())._2$mcI$sp();
        allTopicPartitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestDownConversionConfigTest $outer;

            public final RecordMetadata apply(TopicPartition tp) {
                return (RecordMetadata)this.$outer.unit$kafka$server$FetchRequestDownConversionConfigTest$$producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forReplica((short)1, (int)1, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)allTopicPartitions, this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId, fetchRequest);
        allTopicPartitions.foreach((Function1)new Serializable(this, fetchResponse){
            public static final long serialVersionUID = 0L;
            private final FetchResponse fetchResponse$4;

            public final void apply(TopicPartition tp) {
                Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)this.fetchResponse$4.responseData().get((Object)tp)).error);
            }
            {
                this.fetchResponse$4 = fetchResponse$4;
            }
        });
    }
}

