/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.JsonValue$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005-v!B\u0001\u0003\u0011\u00039\u0011\u0001\u0003&t_:$Vm\u001d;\u000b\u0005\r!\u0011!B;uS2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tA!j]8o)\u0016\u001cHo\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\u0007\tYI\u0001i\u0006\u0002\u000b)\u0016\u001cHo\u00142kK\u000e$8\u0003B\u000b\r1m\u0001\"!D\r\n\u0005iq!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001bqI!!\b\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011})\"Q3A\u0005\u0002\u0001\n1AZ8p+\u0005\t\u0003C\u0001\u0012&\u001d\ti1%\u0003\u0002%\u001d\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!c\u0002\u0003\u0005*+\tE\t\u0015!\u0003\"\u0003\u00111wn\u001c\u0011\t\u0011-*\"Q3A\u0005\u00021\n1AY1s+\u0005i\u0003CA\u0007/\u0013\tycBA\u0002J]RD\u0001\"M\u000b\u0003\u0012\u0003\u0006I!L\u0001\u0005E\u0006\u0014\b\u0005C\u0003\u0014+\u0011\u00051\u0007F\u00025m\u0019\u0003\"!N\u000b\u000e\u0003%AQa\b\u001aA\u0002\u0005BCA\u000e\u001dE\u000bB\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\u000bC:tw\u000e^1uS>t'BA\u001f?\u0003\u001dQ\u0017mY6t_:T!a\u0010!\u0002\u0013\u0019\f7\u000f^3sq6d'\"A!\u0002\u0007\r|W.\u0003\u0002Du\ta!j]8o!J|\u0007/\u001a:us\u0006)a/\u00197vK\u0006\nq\u0004C\u0003,e\u0001\u0007Q\u0006\u000b\u0003Gq\u0011C\u0015%A\u0016\t\u000f)+\u0012\u0011!C\u0001\u0017\u0006!1m\u001c9z)\r!D*\u0014\u0005\b?%\u0003\n\u00111\u0001\"\u0011\u001dY\u0013\n%AA\u00025BqaT\u000b\u0012\u0002\u0013\u0005\u0001+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003ES#!\t*,\u0003M\u0003\"\u0001\u0016-\u000e\u0003US!AV,\u0002\u0013Ut7\r[3dW\u0016$'BA\u001e\u000f\u0013\tIVKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DqaW\u000b\u0012\u0002\u0013\u0005A,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003uS#!\f*\t\u000f}+\u0012\u0011!C!A\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u0001\u0014d\u0011\u001dIW#!A\u0005\u00021\nA\u0002\u001d:pIV\u001cG/\u0011:jifDqa[\u000b\u0002\u0002\u0013\u0005A.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u00055\u0004\bCA\u0007o\u0013\tygBA\u0002B]fDq!\u001d6\u0002\u0002\u0003\u0007Q&A\u0002yIEBqa]\u000b\u0002\u0002\u0013\u0005C/A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\u0005)\bc\u0001<z[6\tqO\u0003\u0002y\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005i<(\u0001C%uKJ\fGo\u001c:\t\u000fq,\u0012\u0011!C\u0001{\u0006A1-\u00198FcV\fG\u000eF\u0002\u007f\u0003\u0007\u0001\"!D@\n\u0007\u0005\u0005aBA\u0004C_>dW-\u00198\t\u000fE\\\u0018\u0011!a\u0001[\"I\u0011qA\u000b\u0002\u0002\u0013\u0005\u0013\u0011B\u0001\tQ\u0006\u001c\bnQ8eKR\tQ\u0006C\u0005\u0002\u000eU\t\t\u0011\"\u0011\u0002\u0010\u0005AAo\\*ue&tw\rF\u0001b\u0011%\t\u0019\"FA\u0001\n\u0003\n)\"\u0001\u0004fcV\fGn\u001d\u000b\u0004}\u0006]\u0001\u0002C9\u0002\u0012\u0005\u0005\t\u0019A7\b\u0013\u0005m\u0011\"!A\t\u0002\u0005u\u0011A\u0003+fgR|%M[3diB\u0019Q'a\b\u0007\u0011YI\u0011\u0011!E\u0001\u0003C\u0019R!a\b\u0002$m\u0001r!!\n\u0002,\u0005jC'\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\b\u0002\u000fI,h\u000e^5nK&!\u0011QFA\u0014\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b'\u0005}A\u0011AA\u0019)\t\ti\u0002\u0003\u0006\u0002\u000e\u0005}\u0011\u0011!C#\u0003\u001fA!\"a\u000e\u0002 \u0005\u0005I\u0011QA\u001d\u0003\u0015\t\u0007\u000f\u001d7z)\u0015!\u00141HA \u0011\u0019y\u0012Q\u0007a\u0001C!*\u00111\b\u001dE\u000b\"11&!\u000eA\u00025BS!a\u00109\t\"C!\"!\u0012\u0002 \u0005\u0005I\u0011QA$\u0003\u001d)h.\u00199qYf$B!!\u0013\u0002VA)Q\"a\u0013\u0002P%\u0019\u0011Q\n\b\u0003\r=\u0003H/[8o!\u0015i\u0011\u0011K\u0011.\u0013\r\t\u0019F\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005]\u00131IA\u0001\u0002\u0004!\u0014a\u0001=%a!Q\u00111LA\u0010\u0003\u0003%I!!\u0018\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u00022AYA1\u0013\r\t\u0019g\u0019\u0002\u0007\u001f\nTWm\u0019;\u0007\u000b)\u0011\u0001!a\u001a\u0014\u0007\u0005\u0015D\u0002C\u0004\u0014\u0003K\"\t!a\u001b\u0015\u0005\u00055\u0004c\u0001\u0005\u0002f!A\u0011\u0011OA3\t\u0003\t\u0019(A\u0007uKN$(j]8o!\u0006\u00148/\u001a\u000b\u0003\u0003k\u00022!DA<\u0013\r\tIH\u0004\u0002\u0005+:LG\u000f\u000b\u0003\u0002p\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003\u000f\u000b1a\u001c:h\u0013\u0011\tY)!!\u0003\tQ+7\u000f\u001e\u0005\t\u0003\u001f\u000b)\u0007\"\u0001\u0002t\u0005AB/Z:u\u0019\u0016<\u0017mY=F]\u000e|G-Z!t'R\u0014\u0018N\\4)\t\u00055\u0015Q\u0010\u0005\t\u0003+\u000b)\u0007\"\u0001\u0002t\u0005\u0011B/Z:u\u000b:\u001cw\u000eZ3BgN#(/\u001b8hQ\u0011\t\u0019*! \t\u0011\u0005m\u0015Q\rC\u0001\u0003g\n\u0011\u0003^3ti\u0016s7m\u001c3f\u0003N\u0014\u0015\u0010^3tQ\u0011\tI*! \t\u0011\u0005\u0005\u0016Q\rC\u0001\u0003g\n1\u0002^3tiB\u000b'o]3U_\"\"\u0011qTA?\u0011!\t9+!\u001a\u0005\u0002\u0005M\u0014A\u0007;fgR\u0004\u0016M]:f)><\u0016\u000e\u001e5J]Z\fG.\u001b3Kg>t\u0007\u0006BAS\u0003{\u0002")
public class JsonTest {
    @Test
    public void testJsonParse() {
        JsonNodeFactory jnf = JsonNodeFactory.instance;
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{}"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)new ObjectNode(jnf))));
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\"s}"), (Object)None$.MODULE$);
        ObjectNode objectNode = new ObjectNode(jnf, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new TextNode("bar")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"is_enabled"), (Object)BooleanNode.TRUE)}))).asJava());
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\", \"is_enabled\":true}"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)objectNode)));
        ArrayNode arrayNode = new ArrayNode(jnf);
        ((IterableLike)((TraversableLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IntNode apply(int x$1) {
                return new IntNode(x$1);
            }
        }, Vector$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, arrayNode){
            public static final long serialVersionUID = 0L;
            private final ArrayNode arrayNode$1;

            public final ArrayNode apply(JsonNode x$1) {
                return this.arrayNode$1.add(x$1);
            }
            {
                this.arrayNode$1 = arrayNode$1;
            }
        });
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("[1, 2, 3]"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)arrayNode)));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo1"), (Object)"bar1\\,bar2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo2"), (Object)"\\bar")}));
        String encoded = Json$.MODULE$.legacyEncodeAsString((Object)map);
        Option decoded = Json$.MODULE$.parseFull(encoded);
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo1\":\"bar1\\\\,bar2\", \"foo2\":\"\\\\bar\"}"), (Object)decoded);
        Assert.assertEquals((Object)decoded, (Object)Json$.MODULE$.parseFull("{\"foo1\":\"bar1\\,bar2\", \"foo2\":\"\\bar\"}"));
    }

    @Test
    public void testLegacyEncodeAsString() {
        Assert.assertEquals((Object)"null", (Object)Json$.MODULE$.legacyEncodeAsString(null));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToLong((long)1L)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToByte((byte)((byte)1))));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToShort((short)((short)1))));
        Assert.assertEquals((Object)"1.0", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToDouble((double)1.0)));
        Assert.assertEquals((Object)"\"str\"", (Object)Json$.MODULE$.legacyEncodeAsString((Object)"str"));
        Assert.assertEquals((Object)"true", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Assert.assertEquals((Object)"false", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Assert.assertEquals((Object)"[]", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertEquals((Object)"[1,2,3]", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        Assert.assertEquals((Object)"[1,\"2\",[3]]", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))}))));
        Assert.assertEquals((Object)"{}", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2}", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})))}))));
        Assert.assertEquals((Object)"\"str1\\\\,str2\"", (Object)Json$.MODULE$.legacyEncodeAsString((Object)"str1\\,str2"));
        Assert.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)Json$.MODULE$.legacyEncodeAsString((Object)"\"quoted\""));
    }

    @Test
    public void testEncodeAsString() {
        Assert.assertEquals((Object)"null", (Object)Json$.MODULE$.encodeAsString(null));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToLong((long)1L)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToByte((byte)((byte)1))));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToShort((short)((short)1))));
        Assert.assertEquals((Object)"1.0", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToDouble((double)1.0)));
        Assert.assertEquals((Object)"\"str\"", (Object)Json$.MODULE$.encodeAsString((Object)"str"));
        Assert.assertEquals((Object)"true", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Assert.assertEquals((Object)"false", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Assert.assertEquals((Object)"[]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()));
        Assert.assertEquals((Object)"[null]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))).asJava()));
        Assert.assertEquals((Object)"[1,2,3]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).asJava()));
        Assert.assertEquals((Object)"[1,\"2\",[3],null]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))).asJava(), null}))).asJava()));
        Assert.assertEquals((Object)"{}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()));
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2,\"c\":null}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava())}))).asJava()));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"b\":[3,4],\"c\":null}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()));
        Assert.assertEquals((Object)"\"str1\\\\,str2\"", (Object)Json$.MODULE$.encodeAsString((Object)"str1\\,str2"));
        Assert.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)Json$.MODULE$.encodeAsString((Object)"\"quoted\""));
    }

    @Test
    public void testEncodeAsBytes() {
        Assert.assertEquals((Object)"null", (Object)new String(Json$.MODULE$.encodeAsBytes(null), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToInteger((int)1)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToLong((long)1L)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToByte((byte)((byte)1))), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToShort((short)((short)1))), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1.0", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToDouble((double)1.0)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"\"str\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"str"), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"true", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToBoolean((boolean)true)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"false", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToBoolean((boolean)false)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[null]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[1,2,3]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[1,\"2\",[3],null]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))).asJava(), null}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2,\"c\":null}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava())}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"b\":[3,4],\"c\":null}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"\"str1\\\\,str2\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"str1\\,str2"), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"\"quoted\""), StandardCharsets.UTF_8));
    }

    @Test
    public void testParseTo() {
        String foo = "baz";
        int bar = 1;
        Either result = Json$.MODULE$.parseStringAs(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"foo\": \"", "\", \"bar\": ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{foo, BoxesRunTime.boxToInteger((int)bar)})), ClassTag$.MODULE$.apply(TestObject.class));
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new TestObject(foo, bar), (Object)result.right().get());
    }

    @Test
    public void testParseToWithInvalidJson() {
        Either result = Json$.MODULE$.parseStringAs("{invalid json}", ClassTag$.MODULE$.apply(TestObject.class));
        Assert.assertTrue((boolean)result.isLeft());
        Assert.assertEquals(JsonParseException.class, result.left().get().getClass());
    }

    public static class TestObject
    implements Product,
    Serializable {
        private final String foo;
        private final int bar;

        public String foo() {
            return this.foo;
        }

        public int bar() {
            return this.bar;
        }

        public TestObject copy(String foo, int bar) {
            return new TestObject(foo, bar);
        }

        public String copy$default$1() {
            return this.foo();
        }

        public int copy$default$2() {
            return this.bar();
        }

        public String productPrefix() {
            return "TestObject";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.bar());
                    break;
                }
                case 0: {
                    object = this.foo();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestObject;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.foo()));
            n = Statics.mix((int)n, (int)this.bar());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestObject)) return false;
            boolean bl = true;
            if (!bl) return false;
            TestObject testObject = (TestObject)x$1;
            String string = this.foo();
            String string2 = testObject.foo();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.bar() != testObject.bar()) return false;
            if (!testObject.canEqual(this)) return false;
            return true;
        }

        public TestObject(@JsonProperty(value="foo") String foo, @JsonProperty(value="bar") int bar) {
            this.foo = foo;
            this.bar = bar;
            Product.class.$init$((Product)this);
        }
    }
}

