/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001\u001d\u0011qb\u00144gg\u0016$\u0018J\u001c3fqR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002\u00011A\u0005\u0002e\t1!\u001b3y+\u0005Q\u0002C\u0001\f\u001c\u0013\ta\"AA\u0006PM\u001a\u001cX\r^%oI\u0016D\bb\u0002\u0010\u0001\u0001\u0004%\taH\u0001\bS\u0012Dx\fJ3r)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bbB\u0014\u001e\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004BB\u0015\u0001A\u0003&!$\u0001\u0003jIb\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u0017\u0011\u0005\u0005r\u0013BA\u0018#\u0005\rIe\u000e\u001e\u0005\u0007c\u0001\u0001\u000b\u0011B\u0017\u0002\u00175\f\u00070\u00128ue&,7\u000f\t\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002kA\u0011\u0011EN\u0005\u0003o\t\u0012A\u0001T8oO\"1\u0011\b\u0001Q\u0001\nU\n1BY1tK>3gm]3uA!)1\b\u0001C\u0001y\u0005)1/\u001a;vaR\t\u0001\u0005\u000b\u0002;}A\u0011q(Q\u0007\u0002\u0001*\u00111BD\u0005\u0003\u0005\u0002\u0013aAQ3g_J,\u0007\"\u0002#\u0001\t\u0003a\u0014\u0001\u0003;fCJ$wn\u001e8)\u0005\r3\u0005CA H\u0013\tA\u0005IA\u0003BMR,'\u000fC\u0003K\u0001\u0011\u0005A(\u0001\tsC:$w.\u001c'p_.,\b\u000fV3ti\"\u0012\u0011\n\u0014\t\u0003\u007f5K!A\u0014!\u0003\tQ+7\u000f\u001e\u0005\u0006!\u0002!\t\u0001P\u0001\u0013Y>|7.\u001e9FqR\u0014X-\\3DCN,7\u000f\u000b\u0002P\u0019\")1\u000b\u0001C\u0001y\u0005i\u0011\r\u001d9f]\u0012$vn\\'b]fD#A\u0015'\t\u000bY\u0003A\u0011\u0001\u001f\u0002!\u0005\u0004\b/\u001a8e\u001fV$xJZ(sI\u0016\u0014\b\u0006B+M1f\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u00025B\u00111lY\u0007\u00029*\u0011QLX\u0001\u0007KJ\u0014xN]:\u000b\u0005}\u0003\u0017AB2p[6|gN\u0003\u0002\u0006C*\u0011!MD\u0001\u0007CB\f7\r[3\n\u0005\u0011d&AF%om\u0006d\u0017\u000eZ(gMN,G/\u0012=dKB$\u0018n\u001c8\t\u000b\u0019\u0004A\u0011\u0001\u001f\u00023Q,7\u000f\u001e$fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u0015\u0003K2CQ!\u001b\u0001\u0005\u0002q\n!\u0002^3tiJ+w\u000e]3oQ\tAG\nC\u0003m\u0001\u0011\u0005A(\u0001\u0005ueVt7-\u0019;fQ\tYG\nC\u0003p\u0001\u0011\u0005A(\u0001\bg_J\u001cW-\u00168nCB$Vm\u001d;)\u00059d\u0005\"\u0002:\u0001\t\u0003a\u0014!\n;fgR\u001c\u0016M\\5us2\u000b7\u000f^(gMN,G/R9vC2$vNQ1tK>3gm]3uQ\t\tH\nC\u0003v\u0001\u0011\u0005a/\u0001\tbgN,'\u000f^,sSR,g)Y5mgV\u0019q/a\u0006\u0015\u0011\u0001B\u00181AA\u0003\u0003\u0013AQ!\u001f;A\u0002i\fq!\\3tg\u0006<W\r\u0005\u0002|}:\u0011\u0011\u0005`\u0005\u0003{\n\na\u0001\u0015:fI\u00164\u0017bA@\u0002\u0002\t11\u000b\u001e:j]\u001eT!! \u0012\t\u000ba!\b\u0019\u0001\u000e\t\r\u0005\u001dA\u000f1\u0001.\u0003\u0019ygMZ:fi\"9\u00111\u0002;A\u0002\u00055\u0011!B6mCN\u001c\b#B>\u0002\u0010\u0005M\u0011\u0002BA\t\u0003\u0003\u0011Qa\u00117bgN\u0004B!!\u0006\u0002\u00181\u0001AaBA\ri\n\u0007\u00111\u0004\u0002\u0002)F!\u0011QDA\u0012!\r\t\u0013qD\u0005\u0004\u0003C\u0011#a\u0002(pi\"Lgn\u001a\t\u0004C\u0005\u0015\u0012bAA\u0014E\t\u0019\u0011I\\=\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005aQn\u001c8pi>t\u0017nY*fcR1\u0011qFA\u001e\u0003\u007f\u0001R!!\r\u000285j!!a\r\u000b\u0007\u0005U\"%\u0001\u0006d_2dWm\u0019;j_:LA!!\u000f\u00024\t\u00191+Z9\t\u000f\u0005u\u0012\u0011\u0006a\u0001[\u0005!!-Y:f\u0011\u001d\t\t%!\u000bA\u00025\n1\u0001\\3o\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\n1C\\8o\u000bbL7\u000f^3oiR+W\u000e\u001d$jY\u0016$\"!!\u0013\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005\u0011\u0011n\u001c\u0006\u0003\u0003'\nAA[1wC&!\u0011qKA'\u0005\u00111\u0015\u000e\\3")
public class OffsetIndexTest
extends JUnitSuite {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, OffsetIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size2 = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(int x$1) {
                return this.apply$mcJI$sp(x$1);
            }

            public long apply$mcJI$sp(int x$1) {
                return x$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size2), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x) {
                this.$outer.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        vals.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x$2) {
                Tuple2<Object, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    long logical = tuple2._1$mcJ$sp();
                    int physical = tuple2._2$mcI$sp();
                    Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)this.$outer.idx().lookup(logical));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(Tuple2<Object, Object> p) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(offsets).take(30)).foreach((Function1)new Serializable(this, valMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;
            private final TreeMap valMap$1;

            public final void apply(long offset) {
                this.apply$mcVJ$sp(offset);
            }

            public void apply$mcVJ$sp(long offset) {
                OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)this.valMap$1.firstKey()) ? new OffsetPosition(this.$outer.idx().baseOffset(), 0) : new OffsetPosition(this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
                Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)this.$outer.idx().lookup(offset));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.valMap$1 = valMap$1;
            }
        });
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.idx().append(this.$outer.idx().baseOffset() + (long)i + 1L, i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long offset = this.$outer.idx().baseOffset() + (long)i + 1L;
                this.$outer.idx().append(offset, i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetPosition[]{first, second, third, fourth}))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(OffsetPosition offsetPosition) {
                this.$outer.idx().append(offsetPosition.offset(), offsetPosition.position());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)new Serializable(this, idx){
            public static final long serialVersionUID = 0L;
            private final OffsetIndex idx$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.idx$1.append((long)i, i);
            }
            {
                this.idx$1 = idx$1;
            }
        });
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.forceUnmap();
        this.intercept((Function0)new Serializable(this, idx){
            public static final long serialVersionUID = 0L;
            private final OffsetIndex idx$2;

            public final OffsetPosition apply() {
                return this.idx$2.lookup(1L);
            }
            {
                this.idx$2 = idx$2;
            }
        }, ClassTag$.MODULE$.apply(NullPointerException.class), new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            throw this.fail(message, new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }
        catch (Exception exception) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, exception.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)new Serializable(this, rand, vals, last){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;
            private final ArrayBuffer vals$1;
            private final IntRef last$1;

            public final ArrayBuffer<Object> apply(int _) {
                this.last$1.elem += this.rand$1.nextInt(15) + 1;
                return this.vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.last$1.elem));
            }
            {
                this.rand$1 = rand$1;
                this.vals$1 = vals$1;
                this.last$1 = last$1;
            }
        });
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

