/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.BrokerNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final scala.collection.mutable.Map<Object, Option<SimpleConsumer>> consumerMap;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private scala.collection.mutable.Map<Object, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    public Option<SimpleConsumer> kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, int bid) {
        None$ none$;
        try {
            Some some;
            Option<Object> option;
            Option option2 = (Option)ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)bid)).toString())._1();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String brokerInfoString = (String)some2.x();
                option = Json$.MODULE$.parseFull(brokerInfoString);
                if (!(option instanceof Some)) {
                    None$ none$2 = None$.MODULE$;
                    Option<Object> option3 = option;
                    if (!(none$2 != null ? !none$2.equals(option3) : option3 != null)) {
                        throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bid)})));
                    }
                    throw new MatchError(option);
                }
            } else {
                None$ none$3 = None$.MODULE$;
                Option option4 = option2;
                if (!(none$3 != null ? !none$3.equals(option4) : option4 != null)) {
                    throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bid)})));
                }
                throw new MatchError((Object)option2);
            }
            Some some3 = (Some)option;
            Object m = some3.x();
            Map brokerInfo = (Map)m;
            String host = (String)brokerInfo.get((Object)"host").get();
            int port = BoxesRunTime.unboxToInt((Object)brokerInfo.get((Object)"port").get());
            Some some4 = some = new Some((Object)new SimpleConsumer(host, port, 10000, 100000, "ConsumerOffsetChecker"));
            none$ = some4;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not parse broker info";
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient, String group, String topic, int pid) {
        Option<Object> option;
        block10: {
            block9: {
                block2: {
                    Option option2;
                    block8: {
                        block7: {
                            block3: {
                                Option option3;
                                block6: {
                                    String string;
                                    Object[] objectArray;
                                    StringOps stringOps;
                                    block5: {
                                        block4: {
                                            String ownerStr;
                                            long offset = new StringOps(Predef$.MODULE$.augmentString((String)ZkUtils$.MODULE$.readData(zkClient, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topic, BoxesRunTime.boxToInteger((int)pid)})))._1())).toLong();
                                            Option owner = (Option)ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topic, BoxesRunTime.boxToInteger((int)pid)})))._1();
                                            option = ZkUtils$.MODULE$.getLeaderForPartition(zkClient, topic, pid);
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            int bid = BoxesRunTime.unboxToInt((Object)some.x());
                                            Option consumerOpt = (Option)this.consumerMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)bid), (Function0)new Serializable(zkClient, bid){
                                                public static final long serialVersionUID = 0L;
                                                private final ZkClient zkClient$1;
                                                private final int bid$1;

                                                public final Option<SimpleConsumer> apply() {
                                                    return ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$getConsumer(this.zkClient$1, this.bid$1);
                                                }
                                                {
                                                    this.zkClient$1 = zkClient$1;
                                                    this.bid$1 = bid$1;
                                                }
                                            });
                                            option2 = consumerOpt;
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            SimpleConsumer consumer = (SimpleConsumer)some2.x();
                                            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, pid);
                                            OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetRequestInfo>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                                            long logSize = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
                                            long lag = logSize - offset;
                                            stringOps = new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s"));
                                            objectArray = new Object[7];
                                            objectArray[0] = group;
                                            objectArray[1] = topic;
                                            objectArray[2] = BoxesRunTime.boxToInteger((int)pid);
                                            objectArray[3] = BoxesRunTime.boxToLong((long)offset);
                                            objectArray[4] = BoxesRunTime.boxToLong((long)logSize);
                                            objectArray[5] = BoxesRunTime.boxToLong((long)lag);
                                            option3 = owner;
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            string = ownerStr = (String)some3.x();
                                            break block5;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option4 = option3;
                                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                                        string = "none";
                                    }
                                    objectArray[6] = string;
                                    Predef$.MODULE$.println((Object)stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block7;
                                }
                                throw new MatchError((Object)option3);
                            }
                            None$ none$ = None$.MODULE$;
                            Option option5 = option2;
                            if (none$ != null ? !none$.equals(option5) : option5 != null) break block8;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    throw new MatchError((Object)option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option6 = option;
                if (none$ != null ? !none$.equals(option6) : option6 != null) break block10;
                this.error((Function0<String>)new Serializable(topic, pid){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;
                    private final int pid$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("No broker for partition %s - %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.pid$1)}));
                    }
                    {
                        this.topic$1 = topic$1;
                        this.pid$1 = pid$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient, String group, String topic) {
        Option option;
        block4: {
            block3: {
                block2: {
                    scala.collection.mutable.Map<String, Seq<Object>> pidMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                    option = pidMap.get((Object)topic);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Seq pids = (Seq)some.x();
                    ((IterableLike)pids.sorted((Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(zkClient, group, topic){
                        public static final long serialVersionUID = 0L;
                        private final ZkClient zkClient$2;
                        private final String group$1;
                        private final String topic$2;

                        public final void apply(int pid) {
                            this.apply$mcVI$sp(pid);
                        }

                        public void apply$mcVI$sp(int pid) {
                            ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processPartition(this.zkClient$2, this.group$1, this.topic$2, pid);
                        }
                        {
                            this.zkClient$2 = zkClient$2;
                            this.group$1 = group$1;
                            this.topic$2 = topic$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println((Object)"BROKER INFO");
        this.consumerMap().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<SimpleConsumer>> check$ifrefutable$1) {
                Tuple2<Object, Option<SimpleConsumer>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Option<SimpleConsumer>> x$1) {
                Tuple2<Object, Option<SimpleConsumer>> tuple2;
                block2: {
                    Option option;
                    block5: {
                        block4: {
                            block3: {
                                tuple2 = x$1;
                                if (tuple2 == null) break block2;
                                int bid = tuple2._1$mcI$sp();
                                Option consumerOpt = (Option)tuple2._2();
                                option = consumerOpt;
                                if (!(option instanceof Some)) break block3;
                                Some some = (Some)option;
                                SimpleConsumer consumer = (SimpleConsumer)some.x();
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s -> %s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bid), consumer.host(), BoxesRunTime.boxToInteger((int)consumer.port())})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void main(String[] args) {
        None$ none$;
        block9: {
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
            ArgumentAcceptingOptionSpec topicsOpt = parser.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
            ArgumentAcceptingOptionSpec groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
            parser.accepts("broker-info", "Print broker info");
            parser.accepts("help", "Print this message.");
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt})).foreach((Function1)new Serializable(parser, options){
                public static final long serialVersionUID = 0L;
                private final OptionParser parser$1;
                private final OptionSet options$1;

                public final void apply(ArgumentAcceptingOptionSpec<String> opt) {
                    if (!this.options$1.has(opt)) {
                        System.err.println(new StringOps(Predef$.MODULE$.augmentString("Missing required argument: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt})));
                        this.parser$1.printHelpOn((OutputStream)System.err);
                        System.exit(1);
                    }
                }
                {
                    this.parser$1 = parser$1;
                    this.options$1 = options$1;
                }
            });
            String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
            String group = (String)options.valueOf((OptionSpec)groupOpt);
            None$ topics = options.has((OptionSpec)topicsOpt) ? new Some(options.valueOf((OptionSpec)topicsOpt)) : None$.MODULE$;
            ObjectRef zkClient = new ObjectRef(null);
            try {
                List list;
                zkClient.elem = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
                none$ = topics;
                if (none$ instanceof Some) {
                    Some some = (Some)none$;
                    String x = (String)some.x();
                    list = Predef$.MODULE$.refArrayOps((Object[])x.split(",")).view().toList();
                } else {
                    None$ none$2 = None$.MODULE$;
                    None$ none$3 = none$;
                    if (none$2 != null ? !none$2.equals(none$3) : none$3 != null) break block9;
                    list = ZkUtils$.MODULE$.getChildren((ZkClient)zkClient.elem, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group}))).toList();
                }
                List topicList = list;
                this.debug((Function0<String>)new Serializable(zkConnect, group, topicList){
                    public static final long serialVersionUID = 0L;
                    private final String zkConnect$1;
                    private final String group$2;
                    private final List topicList$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("zkConnect = %s; topics = %s; group = %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect$1, this.topicList$1.toString(), this.group$2}));
                    }
                    {
                        this.zkConnect$1 = zkConnect$1;
                        this.group$2 = group$2;
                        this.topicList$1 = topicList$1;
                    }
                });
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Group", "Topic", "Pid", "Offset", "logSize", "Lag", "Owner"})));
                ((List)topicList.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(group, zkClient){
                    public static final long serialVersionUID = 0L;
                    private final String group$2;
                    private final ObjectRef zkClient$3;

                    public final void apply(String topic) {
                        ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processTopic((ZkClient)this.zkClient$3.elem, this.group$2, topic);
                    }
                    {
                        this.group$2 = group$2;
                        this.zkClient$3 = zkClient$3;
                    }
                });
                if (options.has("broker-info")) {
                    this.printBrokerInfo();
                }
                this.consumerMap().withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Option<SimpleConsumer>> check$ifrefutable$2) {
                        Tuple2<Object, Option<SimpleConsumer>> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Object, Option<SimpleConsumer>> x$2) {
                        Tuple2<Object, Option<SimpleConsumer>> tuple2;
                        block2: {
                            Option option;
                            block5: {
                                block4: {
                                    block3: {
                                        tuple2 = x$2;
                                        if (tuple2 == null) break block2;
                                        Option consumerOpt = (Option)tuple2._2();
                                        option = consumerOpt;
                                        if (!(option instanceof Some)) break block3;
                                        Some some = (Some)option;
                                        SimpleConsumer consumer = (SimpleConsumer)some.x();
                                        consumer.close();
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option option2 = option;
                                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)option);
                        }
                        throw new MatchError(tuple2);
                    }
                });
            }
            catch (Throwable throwable) {
                this.consumerMap().values().foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Option<SimpleConsumer> consumerOpt) {
                        Option<SimpleConsumer> option;
                        block4: {
                            block3: {
                                block2: {
                                    option = consumerOpt;
                                    if (!(option instanceof Some)) break block2;
                                    Some some = (Some)option;
                                    SimpleConsumer consumer = (SimpleConsumer)some.x();
                                    consumer.close();
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<SimpleConsumer> option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(option);
                    }
                });
                if ((ZkClient)zkClient.elem != null) {
                    ((ZkClient)zkClient.elem).close();
                }
                throw throwable;
            }
            this.consumerMap().values().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
            if ((ZkClient)zkClient.elem != null) {
                ((ZkClient)zkClient.elem).close();
            }
            return;
        }
        throw new MatchError((Object)none$);
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

