/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class ByteUtilsTest {
    private final byte x00 = 0;
    private final byte x01 = 1;
    private final byte x02 = (byte)2;
    private final byte x0F = (byte)15;
    private final byte x7E = (byte)126;
    private final byte x7F = (byte)127;
    private final byte xFF = (byte)-1;
    private final byte x80 = (byte)-128;
    private final byte x81 = (byte)-127;
    private final byte xFE = (byte)-2;

    @Test
    public void testReadUnsignedIntLEFromArray() {
        byte[] array1 = new byte[]{1, 2, 3, 4, 5};
        Assert.assertEquals((long)67305985L, (long)ByteUtils.readUnsignedIntLE((byte[])array1, (int)0));
        Assert.assertEquals((long)84148994L, (long)ByteUtils.readUnsignedIntLE((byte[])array1, (int)1));
        byte[] array2 = new byte[]{-15, -14, -13, -12, -11, -10};
        Assert.assertEquals((long)-185339151L, (long)ByteUtils.readUnsignedIntLE((byte[])array2, (int)0));
        Assert.assertEquals((long)-151653133L, (long)ByteUtils.readUnsignedIntLE((byte[])array2, (int)2));
    }

    @Test
    public void testReadUnsignedIntLEFromInputStream() throws IOException {
        byte[] array1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteArrayInputStream is1 = new ByteArrayInputStream(array1);
        Assert.assertEquals((long)67305985L, (long)ByteUtils.readUnsignedIntLE((InputStream)is1));
        Assert.assertEquals((long)134678021L, (long)ByteUtils.readUnsignedIntLE((InputStream)is1));
        byte[] array2 = new byte[]{-15, -14, -13, -12, -11, -10, -9, -8};
        ByteArrayInputStream is2 = new ByteArrayInputStream(array2);
        Assert.assertEquals((long)-185339151L, (long)ByteUtils.readUnsignedIntLE((InputStream)is2));
        Assert.assertEquals((long)-117967115L, (long)ByteUtils.readUnsignedIntLE((InputStream)is2));
    }

    @Test
    public void testReadUnsignedInt() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        long writeValue = 133444L;
        ByteUtils.writeUnsignedInt((ByteBuffer)buffer, (long)writeValue);
        buffer.flip();
        long readValue = ByteUtils.readUnsignedInt((ByteBuffer)buffer);
        Assert.assertEquals((long)writeValue, (long)readValue);
    }

    @Test
    public void testWriteUnsignedIntLEToArray() {
        int value1 = 67305985;
        byte[] array1 = new byte[4];
        ByteUtils.writeUnsignedIntLE((byte[])array1, (int)0, (int)value1);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])array1);
        array1 = new byte[8];
        ByteUtils.writeUnsignedIntLE((byte[])array1, (int)2, (int)value1);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 1, 2, 3, 4, 0, 0}, (byte[])array1);
        int value2 = -185339151;
        byte[] array2 = new byte[4];
        ByteUtils.writeUnsignedIntLE((byte[])array2, (int)0, (int)value2);
        Assert.assertArrayEquals((byte[])new byte[]{-15, -14, -13, -12}, (byte[])array2);
        array2 = new byte[8];
        ByteUtils.writeUnsignedIntLE((byte[])array2, (int)2, (int)value2);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, -15, -14, -13, -12, 0, 0}, (byte[])array2);
    }

    @Test
    public void testWriteUnsignedIntLEToOutputStream() throws IOException {
        int value1 = 67305985;
        ByteArrayOutputStream os1 = new ByteArrayOutputStream();
        ByteUtils.writeUnsignedIntLE((OutputStream)os1, (int)value1);
        ByteUtils.writeUnsignedIntLE((OutputStream)os1, (int)value1);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 1, 2, 3, 4}, (byte[])os1.toByteArray());
        int value2 = -185339151;
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        ByteUtils.writeUnsignedIntLE((OutputStream)os2, (int)value2);
        Assert.assertArrayEquals((byte[])new byte[]{-15, -14, -13, -12}, (byte[])os2.toByteArray());
    }

    @Test
    public void testVarintSerde() throws Exception {
        this.assertVarintSerde(0, new byte[]{0});
        this.assertVarintSerde(-1, new byte[]{1});
        this.assertVarintSerde(1, new byte[]{2});
        this.assertVarintSerde(63, new byte[]{126});
        this.assertVarintSerde(-64, new byte[]{127});
        this.assertVarintSerde(64, new byte[]{-128, 1});
        this.assertVarintSerde(-65, new byte[]{-127, 1});
        this.assertVarintSerde(8191, new byte[]{-2, 127});
        this.assertVarintSerde(-8192, new byte[]{-1, 127});
        this.assertVarintSerde(8192, new byte[]{-128, -128, 1});
        this.assertVarintSerde(-8193, new byte[]{-127, -128, 1});
        this.assertVarintSerde(1048575, new byte[]{-2, -1, 127});
        this.assertVarintSerde(-1048576, new byte[]{-1, -1, 127});
        this.assertVarintSerde(0x100000, new byte[]{-128, -128, -128, 1});
        this.assertVarintSerde(-1048577, new byte[]{-127, -128, -128, 1});
        this.assertVarintSerde(0x7FFFFFF, new byte[]{-2, -1, -1, 127});
        this.assertVarintSerde(-134217728, new byte[]{-1, -1, -1, 127});
        this.assertVarintSerde(0x8000000, new byte[]{-128, -128, -128, -128, 1});
        this.assertVarintSerde(-134217729, new byte[]{-127, -128, -128, -128, 1});
        this.assertVarintSerde(Integer.MAX_VALUE, new byte[]{-2, -1, -1, -1, 15});
        this.assertVarintSerde(Integer.MIN_VALUE, new byte[]{-1, -1, -1, -1, 15});
    }

    @Test
    public void testVarlongSerde() throws Exception {
        this.assertVarlongSerde(0L, new byte[]{0});
        this.assertVarlongSerde(-1L, new byte[]{1});
        this.assertVarlongSerde(1L, new byte[]{2});
        this.assertVarlongSerde(63L, new byte[]{126});
        this.assertVarlongSerde(-64L, new byte[]{127});
        this.assertVarlongSerde(64L, new byte[]{-128, 1});
        this.assertVarlongSerde(-65L, new byte[]{-127, 1});
        this.assertVarlongSerde(8191L, new byte[]{-2, 127});
        this.assertVarlongSerde(-8192L, new byte[]{-1, 127});
        this.assertVarlongSerde(8192L, new byte[]{-128, -128, 1});
        this.assertVarlongSerde(-8193L, new byte[]{-127, -128, 1});
        this.assertVarlongSerde(1048575L, new byte[]{-2, -1, 127});
        this.assertVarlongSerde(-1048576L, new byte[]{-1, -1, 127});
        this.assertVarlongSerde(0x100000L, new byte[]{-128, -128, -128, 1});
        this.assertVarlongSerde(-1048577L, new byte[]{-127, -128, -128, 1});
        this.assertVarlongSerde(0x7FFFFFFL, new byte[]{-2, -1, -1, 127});
        this.assertVarlongSerde(-134217728L, new byte[]{-1, -1, -1, 127});
        this.assertVarlongSerde(0x8000000L, new byte[]{-128, -128, -128, -128, 1});
        this.assertVarlongSerde(-134217729L, new byte[]{-127, -128, -128, -128, 1});
        this.assertVarlongSerde(Integer.MAX_VALUE, new byte[]{-2, -1, -1, -1, 15});
        this.assertVarlongSerde(Integer.MIN_VALUE, new byte[]{-1, -1, -1, -1, 15});
        this.assertVarlongSerde(0x3FFFFFFFFL, new byte[]{-2, -1, -1, -1, 127});
        this.assertVarlongSerde(-17179869184L, new byte[]{-1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x400000000L, new byte[]{-128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-17179869185L, new byte[]{-127, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0x1FFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-2199023255552L, new byte[]{-1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x20000000000L, new byte[]{-128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-2199023255553L, new byte[]{-127, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0xFFFFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-281474976710656L, new byte[]{-1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x1000000000000L, new byte[]{-128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-281474976710657L, new byte[]{-127, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0x7FFFFFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-36028797018963968L, new byte[]{-1, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x80000000000000L, new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-36028797018963969L, new byte[]{-127, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(0x3FFFFFFFFFFFFFFFL, new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(-4611686018427387904L, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127});
        this.assertVarlongSerde(0x4000000000000000L, new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(-4611686018427387905L, new byte[]{-127, -128, -128, -128, -128, -128, -128, -128, -128, 1});
        this.assertVarlongSerde(Long.MAX_VALUE, new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, -1, 1});
        this.assertVarlongSerde(Long.MIN_VALUE, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidVarint() {
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{-1, -1, -1, -1, -1, 1});
        ByteUtils.readVarint((ByteBuffer)buf);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidVarlong() {
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1});
        ByteUtils.readVarlong((ByteBuffer)buf);
    }

    private void assertVarintSerde(int value, byte[] expectedEncoding) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(32);
        ByteUtils.writeVarint((int)value, (ByteBuffer)buf);
        buf.flip();
        Assert.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        Assert.assertEquals((long)value, (long)ByteUtils.readVarint((ByteBuffer)buf.duplicate()));
        buf.rewind();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buf));
        ByteUtils.writeVarint((int)value, (DataOutput)out);
        buf.flip();
        Assert.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        Assert.assertEquals((long)value, (long)ByteUtils.readVarint((DataInput)in));
    }

    private void assertVarlongSerde(long value, byte[] expectedEncoding) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(32);
        ByteUtils.writeVarlong((long)value, (ByteBuffer)buf);
        buf.flip();
        Assert.assertEquals((long)value, (long)ByteUtils.readVarlong((ByteBuffer)buf.duplicate()));
        Assert.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        buf.rewind();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buf));
        ByteUtils.writeVarlong((long)value, (DataOutput)out);
        buf.flip();
        Assert.assertArrayEquals((byte[])expectedEncoding, (byte[])Utils.toArray((ByteBuffer)buf));
        DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(buf));
        Assert.assertEquals((long)value, (long)ByteUtils.readVarlong((DataInput)in));
    }
}

