/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class CreateAclsRequestTest {
    private static final short V0 = 0;
    private static final short V1 = 1;
    private static final AclBinding LITERAL_ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));
    private static final AclBinding LITERAL_ACL2 = new AclBinding(new ResourcePattern(ResourceType.GROUP, "group", PatternType.LITERAL), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
    private static final AclBinding PREFIXED_ACL1 = new AclBinding(new ResourcePattern(ResourceType.GROUP, "prefix", PatternType.PREFIXED), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBinding UNKNOWN_ACL1 = new AclBinding(new ResourcePattern(ResourceType.UNKNOWN, "unknown", PatternType.LITERAL), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowOnV0IfNotLiteral() {
        new CreateAclsRequest(0, CreateAclsRequestTest.aclCreations(PREFIXED_ACL1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnIfUnknown() {
        new CreateAclsRequest(0, CreateAclsRequestTest.aclCreations(UNKNOWN_ACL1));
    }

    @Test
    public void shouldRoundTripV0() {
        CreateAclsRequest original = new CreateAclsRequest(0, CreateAclsRequestTest.aclCreations(LITERAL_ACL1, LITERAL_ACL2));
        Struct struct = original.toStruct();
        CreateAclsRequest result = new CreateAclsRequest(struct, 0);
        CreateAclsRequestTest.assertRequestEquals(original, result);
    }

    @Test
    public void shouldRoundTripV1() {
        CreateAclsRequest original = new CreateAclsRequest(1, CreateAclsRequestTest.aclCreations(LITERAL_ACL1, PREFIXED_ACL1));
        Struct struct = original.toStruct();
        CreateAclsRequest result = new CreateAclsRequest(struct, 1);
        CreateAclsRequestTest.assertRequestEquals(original, result);
    }

    private static void assertRequestEquals(CreateAclsRequest original, CreateAclsRequest actual) {
        Assert.assertEquals((String)"Number of Acls wrong", (long)original.aclCreations().size(), (long)actual.aclCreations().size());
        for (int idx = 0; idx != original.aclCreations().size(); ++idx) {
            AclBinding originalBinding = ((CreateAclsRequest.AclCreation)original.aclCreations().get(idx)).acl();
            AclBinding actualBinding = ((CreateAclsRequest.AclCreation)actual.aclCreations().get(idx)).acl();
            Assert.assertEquals((Object)originalBinding, (Object)actualBinding);
        }
    }

    private static List<CreateAclsRequest.AclCreation> aclCreations(AclBinding ... acls) {
        return Arrays.stream(acls).map(CreateAclsRequest.AclCreation::new).collect(Collectors.toList());
    }
}

