/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.EchoServer;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.SelectorTest;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.kafka.common.network.SslSender;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SslSelectorTest
extends SelectorTest {
    private Map<String, Object> sslClientConfigs;

    @Override
    @Before
    public void setUp() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslServerConfigs = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        this.server = new EchoServer(SecurityProtocol.SSL, sslServerConfigs);
        this.server.start();
        this.time = new MockTime();
        this.sslClientConfigs = TestSslUtils.createSslConfig(false, false, Mode.CLIENT, trustStoreFile, "client");
        this.channelBuilder = new SslChannelBuilder(Mode.CLIENT, null, false);
        this.channelBuilder.configure(this.sslClientConfigs);
        this.metrics = new Metrics();
        this.selector = new Selector(5000L, this.metrics, this.time, "MetricGroup", this.channelBuilder, new LogContext());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.selector.close();
        this.server.close();
        this.metrics.close();
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    @Test
    public void testDisconnectWithIntermediateBufferedBytes() throws Exception {
        int requestSize = 102400;
        String node = "0";
        String request = TestUtils.randomString(requestSize);
        this.selector.close();
        this.channelBuilder = new TestSslChannelBuilder(Mode.CLIENT);
        this.channelBuilder.configure(this.sslClientConfigs);
        this.selector = new Selector(5000L, this.metrics, this.time, "MetricGroup", this.channelBuilder, new LogContext());
        this.connect("0", new InetSocketAddress("localhost", this.server.port));
        this.selector.send((Send)this.createSend("0", request));
        this.waitForBytesBuffered(this.selector, "0");
        this.selector.close("0");
        this.verifySelectorEmpty();
    }

    private void waitForBytesBuffered(final Selector selector, final String node) throws Exception {
        TestUtils.waitForCondition(new TestCondition(){

            @Override
            public boolean conditionMet() {
                try {
                    selector.poll(0L);
                    return selector.channel(node).hasBytesBuffered();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 2000L, "Failed to reach socket state with bytes buffered");
    }

    @Test
    public void testBytesBufferedChannelWithNoIncomingBytes() throws Exception {
        this.verifyNoUnnecessaryPollWithBytesBuffered(key -> key.interestOps(key.interestOps() & 0xFFFFFFFE));
    }

    @Test
    public void testBytesBufferedChannelAfterMute() throws Exception {
        this.verifyNoUnnecessaryPollWithBytesBuffered(key -> ((KafkaChannel)key.attachment()).mute());
    }

    private void verifyNoUnnecessaryPollWithBytesBuffered(Consumer<SelectionKey> disableRead) throws Exception {
        this.selector.close();
        final String node1 = "1";
        String node2 = "2";
        final AtomicInteger node1Polls = new AtomicInteger();
        this.channelBuilder = new TestSslChannelBuilder(Mode.CLIENT);
        this.channelBuilder.configure(this.sslClientConfigs);
        this.selector = new Selector(5000L, this.metrics, this.time, "MetricGroup", this.channelBuilder, new LogContext()){

            void pollSelectionKeys(Set<SelectionKey> selectionKeys, boolean isImmediatelyConnected, long currentTimeNanos) {
                for (SelectionKey key : selectionKeys) {
                    KafkaChannel channel = (KafkaChannel)key.attachment();
                    if (channel == null || !channel.id().equals(node1)) continue;
                    node1Polls.incrementAndGet();
                }
                super.pollSelectionKeys(selectionKeys, isImmediatelyConnected, currentTimeNanos);
            }
        };
        int largeRequestSize = 102400;
        this.connect(node1, new InetSocketAddress("localhost", this.server.port));
        this.selector.send((Send)this.createSend(node1, TestUtils.randomString(largeRequestSize)));
        this.waitForBytesBuffered(this.selector, node1);
        TestSslChannelBuilder.TestSslTransportLayer.transportLayers.get(node1).truncateReadBuffer();
        disableRead.accept(this.selector.channel(node1).selectionKey());
        node1Polls.set(0);
        this.connect(node2, new InetSocketAddress("localhost", this.server.port));
        int received = 0;
        String request = TestUtils.randomString(10);
        this.selector.send((Send)this.createSend(node2, request));
        while (received < 100) {
            received += this.selector.completedReceives().size();
            if (!this.selector.completedSends().isEmpty()) {
                this.selector.send((Send)this.createSend(node2, request));
            }
            this.selector.poll(5L);
        }
        Assert.assertEquals((long)1L, (long)node1Polls.get());
        this.selector.close(node1);
        this.selector.close(node2);
        this.verifySelectorEmpty();
    }

    @Test
    public void testRenegotiationFails() throws Exception {
        String node = "0";
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        this.selector.connect(node, addr, 4096, 4096);
        while (!this.selector.isChannelReady(node)) {
            this.selector.poll(1000L);
        }
        this.selector.send((Send)this.createSend(node, node + "-" + 0));
        this.selector.poll(0L);
        this.server.renegotiate();
        this.selector.send((Send)this.createSend(node, node + "-" + 1));
        long expiryTime = System.currentTimeMillis() + 2000L;
        ArrayList disconnected = new ArrayList();
        while (!disconnected.contains(node) && System.currentTimeMillis() < expiryTime) {
            this.selector.poll(10L);
            disconnected.addAll(this.selector.disconnected().keySet());
        }
        Assert.assertTrue((String)"Renegotiation should cause disconnection", (boolean)disconnected.contains(node));
    }

    @Override
    public void testMuteOnOOM() throws Exception {
        this.selector.close();
        SimpleMemoryPool pool = new SimpleMemoryPool(900L, 900, false, null);
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslServerConfigs = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        this.channelBuilder = new SslChannelBuilder(Mode.SERVER, null, false);
        this.channelBuilder.configure(sslServerConfigs);
        this.selector = new Selector(-1, 5000L, this.metrics, this.time, "MetricGroup", new HashMap(), true, false, this.channelBuilder, (MemoryPool)pool, new LogContext());
        try (ServerSocketChannel ss = ServerSocketChannel.open();){
            List completed;
            ss.bind(new InetSocketAddress(0));
            InetSocketAddress serverAddress = (InetSocketAddress)ss.getLocalAddress();
            SslSender sender1 = this.createSender(serverAddress, this.randomPayload(900));
            SslSender sender2 = this.createSender(serverAddress, this.randomPayload(900));
            sender1.start();
            sender2.start();
            SocketChannel channelX = ss.accept();
            channelX.configureBlocking(false);
            SocketChannel channelY = ss.accept();
            channelY.configureBlocking(false);
            this.selector.register("clientX", channelX);
            this.selector.register("clientY", channelY);
            boolean handshaked = false;
            NetworkReceive firstReceive = null;
            long deadline = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < deadline) {
                this.selector.poll(10L);
                completed = this.selector.completedReceives();
                if (firstReceive == null) {
                    if (!completed.isEmpty()) {
                        Assert.assertEquals((String)"expecting a single request", (long)1L, (long)completed.size());
                        firstReceive = (NetworkReceive)completed.get(0);
                        Assert.assertTrue((boolean)this.selector.isMadeReadProgressLastPoll());
                        Assert.assertEquals((long)0L, (long)pool.availableMemory());
                    }
                } else {
                    Assert.assertTrue((String)"only expecting single request", (boolean)completed.isEmpty());
                }
                if (!(handshaked = sender1.waitForHandshake(1L) && sender2.waitForHandshake(1L)) || firstReceive == null || !this.selector.isOutOfMemory()) continue;
                break;
            }
            Assert.assertTrue((String)"could not initiate connections within timeout", (boolean)handshaked);
            this.selector.poll(10L);
            Assert.assertTrue((boolean)this.selector.completedReceives().isEmpty());
            Assert.assertEquals((long)0L, (long)pool.availableMemory());
            Assert.assertNotNull((String)"First receive not complete", firstReceive);
            Assert.assertTrue((String)"Selector not out of memory", (boolean)this.selector.isOutOfMemory());
            firstReceive.close();
            Assert.assertEquals((long)900L, (long)pool.availableMemory());
            completed = Collections.emptyList();
            deadline = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < deadline && completed.isEmpty()) {
                this.selector.poll(1000L);
                completed = this.selector.completedReceives();
            }
            Assert.assertEquals((String)"could not read remaining request within timeout", (long)1L, (long)completed.size());
            Assert.assertEquals((long)0L, (long)pool.availableMemory());
            Assert.assertFalse((boolean)this.selector.isOutOfMemory());
        }
    }

    @Override
    protected void connect(String node, InetSocketAddress serverAddr) throws IOException {
        this.blockingConnect(node, serverAddr);
    }

    private SslSender createSender(InetSocketAddress serverAddress, byte[] payload) {
        return new SslSender(serverAddress, payload);
    }

    private static class TestSslChannelBuilder
    extends SslChannelBuilder {
        public TestSslChannelBuilder(Mode mode) {
            super(mode, null, false);
        }

        protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key, String host) throws IOException {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            SSLEngine sslEngine = sslFactory.createSslEngine(host, socketChannel.socket().getPort());
            TestSslTransportLayer transportLayer = new TestSslTransportLayer(id, key, sslEngine);
            transportLayer.startHandshake();
            return transportLayer;
        }

        static class TestSslTransportLayer
        extends SslTransportLayer {
            static Map<String, TestSslTransportLayer> transportLayers = new HashMap<String, TestSslTransportLayer>();
            boolean muteSocket = false;

            public TestSslTransportLayer(String channelId, SelectionKey key, SSLEngine sslEngine) throws IOException {
                super(channelId, key, sslEngine);
                transportLayers.put(channelId, this);
            }

            protected int readFromSocketChannel() throws IOException {
                if (this.muteSocket) {
                    if ((this.selectionKey().interestOps() & 1) != 0) {
                        this.muteSocket = false;
                    }
                    return 0;
                }
                this.muteSocket = true;
                return super.readFromSocketChannel();
            }

            void truncateReadBuffer() throws Exception {
                this.netReadBuffer().position(1);
                this.appReadBuffer().position(0);
                this.muteSocket = true;
            }
        }
    }
}

