/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public class SaslConfigsTest {
    @Test
    public void testSaslLoginRefreshDefaults() {
        Map vals = new ConfigDef().withClientSaslSupport().parse(Collections.emptyMap());
        Assert.assertEquals((Object)0.8, vals.get("sasl.login.refresh.window.factor"));
        Assert.assertEquals((Object)0.05, vals.get("sasl.login.refresh.window.jitter"));
        Assert.assertEquals((Object)60, vals.get("sasl.login.refresh.min.period.seconds"));
        Assert.assertEquals((Object)300, vals.get("sasl.login.refresh.buffer.seconds"));
    }

    @Test
    public void testSaslLoginRefreshMinValuesAreValid() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.window.factor", "0.5");
        props.put("sasl.login.refresh.window.jitter", "0.0");
        props.put("sasl.login.refresh.min.period.seconds", "0");
        props.put("sasl.login.refresh.buffer.seconds", "0");
        Map vals = new ConfigDef().withClientSaslSupport().parse(props);
        Assert.assertEquals((Object)Double.valueOf("0.5"), vals.get("sasl.login.refresh.window.factor"));
        Assert.assertEquals((Object)Double.valueOf("0.0"), vals.get("sasl.login.refresh.window.jitter"));
        Assert.assertEquals((Object)Short.valueOf("0"), vals.get("sasl.login.refresh.min.period.seconds"));
        Assert.assertEquals((Object)Short.valueOf("0"), vals.get("sasl.login.refresh.buffer.seconds"));
    }

    @Test
    public void testSaslLoginRefreshMaxValuesAreValid() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.window.factor", "1.0");
        props.put("sasl.login.refresh.window.jitter", "0.25");
        props.put("sasl.login.refresh.min.period.seconds", "900");
        props.put("sasl.login.refresh.buffer.seconds", "3600");
        Map vals = new ConfigDef().withClientSaslSupport().parse(props);
        Assert.assertEquals((Object)Double.valueOf("1.0"), vals.get("sasl.login.refresh.window.factor"));
        Assert.assertEquals((Object)Double.valueOf("0.25"), vals.get("sasl.login.refresh.window.jitter"));
        Assert.assertEquals((Object)Short.valueOf("900"), vals.get("sasl.login.refresh.min.period.seconds"));
        Assert.assertEquals((Object)Short.valueOf("3600"), vals.get("sasl.login.refresh.buffer.seconds"));
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshWindowFactorMinValueIsReallyMinimum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.window.factor", "0.499999");
        new ConfigDef().withClientSaslSupport().parse(props);
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshWindowFactorMaxValueIsReallyMaximum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.window.factor", "1.0001");
        new ConfigDef().withClientSaslSupport().parse(props);
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshWindowJitterMinValueIsReallyMinimum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.window.jitter", "-0.000001");
        new ConfigDef().withClientSaslSupport().parse(props);
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshWindowJitterMaxValueIsReallyMaximum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.window.jitter", "0.251");
        new ConfigDef().withClientSaslSupport().parse(props);
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshMinPeriodSecondsMinValueIsReallyMinimum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.min.period.seconds", "-1");
        new ConfigDef().withClientSaslSupport().parse(props);
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshMinPeriodSecondsMaxValueIsReallyMaximum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.min.period.seconds", "901");
        new ConfigDef().withClientSaslSupport().parse(props);
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshBufferSecondsMinValueIsReallyMinimum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.buffer.seconds", "-1");
        new ConfigDef().withClientSaslSupport().parse(props);
    }

    @Test(expected=ConfigException.class)
    public void testSaslLoginRefreshBufferSecondsMaxValueIsReallyMaximum() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sasl.login.refresh.buffer.seconds", "3601");
        new ConfigDef().withClientSaslSupport().parse(props);
    }
}

