/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.common.utils.MockTime;
import org.junit.Assert;
import org.junit.Test;

public class HeartbeatTest {
    private int sessionTimeoutMs = 300;
    private int heartbeatIntervalMs = 100;
    private int maxPollIntervalMs = 900;
    private long retryBackoffMs = 10L;
    private MockTime time = new MockTime();
    private Heartbeat heartbeat = new Heartbeat(this.sessionTimeoutMs, this.heartbeatIntervalMs, this.maxPollIntervalMs, this.retryBackoffMs);

    @Test
    public void testShouldHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep((long)((double)this.heartbeatIntervalMs * 1.1));
        Assert.assertTrue((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testShouldNotHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.heartbeatIntervalMs / 2);
        Assert.assertFalse((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testTimeToNextHeartbeat() {
        this.heartbeat.sentHeartbeat(0L);
        Assert.assertEquals((long)100L, (long)this.heartbeat.timeToNextHeartbeat(0L));
        Assert.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(100L));
        Assert.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(200L));
    }

    @Test
    public void testSessionTimeoutExpired() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(305L);
        Assert.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetSession() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(305L);
        this.heartbeat.resetTimeouts(this.time.milliseconds());
        Assert.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
    }
}

