/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class RangeAssignorTest {
    private RangeAssignor assignor = new RangeAssignor();

    @Test
    public void testOneConsumerNoTopic() {
        String consumerId = "consumer";
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(Collections.emptyList())));
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get(consumerId)).isEmpty());
    }

    @Test
    public void testOneConsumerNonexistentTopic() {
        String topic = "topic";
        String consumerId = "consumer";
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic))));
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get(consumerId)).isEmpty());
    }

    @Test
    public void testOneConsumerOneTopic() {
        String topic = "topic";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic))));
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic, 0), RangeAssignorTest.tp(topic, 1), RangeAssignorTest.tp(topic, 2)), (List)assignment.get(consumerId));
    }

    @Test
    public void testOnlyAssignsPartitionsFromSubscribedTopics() {
        String topic = "topic";
        String otherTopic = "other";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        partitionsPerTopic.put(otherTopic, 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic))));
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic, 0), RangeAssignorTest.tp(topic, 1), RangeAssignorTest.tp(topic, 2)), (List)assignment.get(consumerId));
    }

    @Test
    public void testOneConsumerMultipleTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 1);
        partitionsPerTopic.put(topic2, 2);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic1, topic2))));
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 0), RangeAssignorTest.tp(topic2, 0), RangeAssignorTest.tp(topic2, 1)), (List)assignment.get(consumerId));
    }

    @Test
    public void testTwoConsumersOneTopicOnePartition() {
        String topic = "topic";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 1);
        HashMap<String, PartitionAssignor.Subscription> consumers = new HashMap<String, PartitionAssignor.Subscription>();
        consumers.put(consumer1, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic)));
        consumers.put(consumer2, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic, 0)), (List)assignment.get(consumer1));
        this.assertAssignment(Collections.emptyList(), (List)assignment.get(consumer2));
    }

    @Test
    public void testTwoConsumersOneTopicTwoPartitions() {
        String topic = "topic";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 2);
        HashMap<String, PartitionAssignor.Subscription> consumers = new HashMap<String, PartitionAssignor.Subscription>();
        consumers.put(consumer1, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic)));
        consumers.put(consumer2, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic, 0)), (List)assignment.get(consumer1));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic, 1)), (List)assignment.get(consumer2));
    }

    @Test
    public void testMultipleConsumersMixedTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 2);
        HashMap<String, PartitionAssignor.Subscription> consumers = new HashMap<String, PartitionAssignor.Subscription>();
        consumers.put(consumer1, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic1)));
        consumers.put(consumer2, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic1, topic2)));
        consumers.put(consumer3, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic1)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 0)), (List)assignment.get(consumer1));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 1), RangeAssignorTest.tp(topic2, 0), RangeAssignorTest.tp(topic2, 1)), (List)assignment.get(consumer2));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 2)), (List)assignment.get(consumer3));
    }

    @Test
    public void testTwoConsumersTwoTopicsSixPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 3);
        HashMap<String, PartitionAssignor.Subscription> consumers = new HashMap<String, PartitionAssignor.Subscription>();
        consumers.put(consumer1, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic1, topic2)));
        consumers.put(consumer2, new PartitionAssignor.Subscription(RangeAssignorTest.topics(topic1, topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 0), RangeAssignorTest.tp(topic1, 1), RangeAssignorTest.tp(topic2, 0), RangeAssignorTest.tp(topic2, 1)), (List)assignment.get(consumer1));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 2), RangeAssignorTest.tp(topic2, 2)), (List)assignment.get(consumer2));
    }

    private void assertAssignment(List<TopicPartition> expected, List<TopicPartition> actual) {
        Assert.assertEquals(new HashSet<TopicPartition>(expected), new HashSet<TopicPartition>(actual));
    }

    private static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    private static List<TopicPartition> partitions(TopicPartition ... partitions) {
        return Arrays.asList(partitions);
    }

    private static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }
}

