/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class InitProducerIdResponse
extends AbstractResponse {
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String EPOCH_KEY_NAME = "producer_epoch";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final int throttleTimeMs;
    private final Errors error;
    private final long producerId;
    private final short epoch;

    public InitProducerIdResponse(int throttleTimeMs, Errors error, long producerId, short epoch) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.producerId = producerId;
        this.epoch = epoch;
    }

    public InitProducerIdResponse(Struct struct) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
        this.producerId = struct.getLong(PRODUCER_ID_KEY_NAME);
        this.epoch = struct.getShort(EPOCH_KEY_NAME);
    }

    public InitProducerIdResponse(int throttleTimeMs, Errors errors) {
        this(throttleTimeMs, errors, -1L, 0);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public long producerId() {
        return this.producerId;
    }

    public Errors error() {
        return this.error;
    }

    public short epoch() {
        return this.epoch;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.INIT_PRODUCER_ID.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set(PRODUCER_ID_KEY_NAME, (Object)this.producerId);
        struct.set(EPOCH_KEY_NAME, (Object)this.epoch);
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        return struct;
    }

    public static InitProducerIdResponse parse(ByteBuffer buffer, short version) {
        return new InitProducerIdResponse(ApiKeys.INIT_PRODUCER_ID.parseResponse(version, buffer));
    }

    public String toString() {
        return "InitProducerIdResponse(error=" + (Object)((Object)this.error) + ", producerId=" + this.producerId + ", producerEpoch=" + this.epoch + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }
}

