/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;

public class HeartbeatRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.HEARTBEAT.id);
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String GROUP_GENERATION_ID_KEY_NAME = "group_generation_id";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private final String groupId;
    private final int groupGenerationId;
    private final String memberId;

    public HeartbeatRequest(String groupId, int groupGenerationId, String memberId) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.struct.set(GROUP_GENERATION_ID_KEY_NAME, (Object)groupGenerationId);
        this.struct.set(MEMBER_ID_KEY_NAME, (Object)memberId);
        this.groupId = groupId;
        this.groupGenerationId = groupGenerationId;
        this.memberId = memberId;
    }

    public HeartbeatRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.groupGenerationId = struct.getInt(GROUP_GENERATION_ID_KEY_NAME);
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                return new HeartbeatResponse(Errors.forException(e).code());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.HEARTBEAT.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupGenerationId() {
        return this.groupGenerationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public static HeartbeatRequest parse(ByteBuffer buffer, int versionId) {
        return new HeartbeatRequest(ProtoUtils.parseRequest(ApiKeys.HEARTBEAT.id, versionId, buffer));
    }

    public static HeartbeatRequest parse(ByteBuffer buffer) {
        return new HeartbeatRequest(CURRENT_SCHEMA.read(buffer));
    }
}

