/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public final class Links {
    public static <T extends Page> AbstractLink newSubmitLink(String linkId, final PageParameters pageParameters, final Class<T> pageClass) {
        return new SubmitLink(linkId){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.getForm().setResponsePage(pageClass, pageParameters);
                super.onSubmit();
            }
        };
    }

    @Deprecated
    public static <T extends Page> AbstractLink newAbstractLink(String linkId, final PageParameters pageParameters, final Class<T> pageClass) {
        return new Link<T>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                this.setResponsePage(pageClass, pageParameters);
            }
        };
    }

    public static <T extends Page> AbstractLink newBookmarkablePageLink(String linkId, PageParameters pageParameters, Class<T> pageClass) {
        return new BookmarkablePageLink(linkId, pageClass, pageParameters);
    }

    public static <T extends Page> AbstractLink newBookmarkablePageLinkWithAnchor(String linkId, PageParameters pageParameters, Class<T> pageClass) {
        final String hints = PageParameterNames.ANCHOR.getStringFrom(pageParameters);
        if (hints != null) {
            PageParameterNames.ANCHOR.removeFrom(pageParameters);
            return new BookmarkablePageLink<T>(linkId, pageClass, pageParameters){
                private static final long serialVersionUID = 1L;

                protected CharSequence appendAnchor(ComponentTag tag, CharSequence url) {
                    if (url != null) {
                        url = url + "#" + hints;
                    }
                    return url;
                }
            };
        }
        return Links.newBookmarkablePageLink(linkId, pageParameters, pageClass);
    }
}

