/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;
import org.apache.isis.viewer.wicket.ui.errors.StackTraceDetail;

public class ExceptionModel
extends ModelAbstract<List<StackTraceDetail>> {
    private static final long serialVersionUID = 1L;
    private static final String MAIN_MESSAGE_IF_NOT_RECOGNIZED = "Sorry, an unexpected error occurred.";
    private List<StackTraceDetail> stackTraceDetailList;
    private boolean recognized;
    private boolean authorizationCause;
    private final String mainMessage;

    public static ExceptionModel create(String recognizedMessageIfAny, Exception ex) {
        return new ExceptionModel(recognizedMessageIfAny, ex);
    }

    private ExceptionModel(String recognizedMessageIfAny, Exception ex) {
        ObjectMember.AuthorizationException authorizationException = ExceptionModel.causalChainOf(ex, ObjectMember.AuthorizationException.class);
        if (authorizationException != null) {
            this.authorizationCause = true;
            this.mainMessage = authorizationException.getMessage();
        } else {
            this.authorizationCause = false;
            if (recognizedMessageIfAny != null) {
                this.recognized = true;
                this.mainMessage = recognizedMessageIfAny;
            } else {
                this.recognized = false;
                Iterable appEx = Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)ex), NonRecoverableException.class);
                Iterator iterator = appEx.iterator();
                NonRecoverableException nonRecoverableException = iterator.hasNext() ? (NonRecoverableException)iterator.next() : null;
                this.mainMessage = nonRecoverableException != null ? nonRecoverableException.getMessage() : MAIN_MESSAGE_IF_NOT_RECOGNIZED;
            }
        }
        this.stackTraceDetailList = ExceptionModel.asStackTrace(ex);
    }

    protected List<StackTraceDetail> load() {
        return this.stackTraceDetailList;
    }

    private static <T extends Exception> T causalChainOf(Exception ex, Class<T> exType) {
        List causalChain = Throwables.getCausalChain((Throwable)ex);
        for (Throwable cause : causalChain) {
            if (!exType.isAssignableFrom(cause.getClass())) continue;
            return (T)((Exception)cause);
        }
        return null;
    }

    public void setObject(List<StackTraceDetail> stackTraceDetail) {
        if (stackTraceDetail == null) {
            return;
        }
        this.stackTraceDetailList = stackTraceDetail;
    }

    public boolean isRecognized() {
        return this.recognized;
    }

    public String getMainMessage() {
        return this.mainMessage;
    }

    public boolean isAuthorizationException() {
        return this.authorizationCause;
    }

    public List<StackTraceDetail> getStackTrace() {
        return this.stackTraceDetailList;
    }

    private static List<StackTraceDetail> asStackTrace(Throwable ex) {
        ArrayList stackTrace = Lists.newArrayList();
        List causalChain = Throwables.getCausalChain((Throwable)ex);
        boolean firstTime = true;
        for (Throwable cause : causalChain) {
            if (!firstTime) {
                stackTrace.add(StackTraceDetail.spacer());
                stackTrace.add(StackTraceDetail.causedBy());
                stackTrace.add(StackTraceDetail.spacer());
            } else {
                firstTime = false;
            }
            stackTrace.add(StackTraceDetail.exceptionClassName(cause));
            stackTrace.add(StackTraceDetail.exceptionMessage(cause));
            ExceptionModel.addStackTraceElements(cause, stackTrace);
        }
        return stackTrace;
    }

    private static void addStackTraceElements(Throwable ex, List<StackTraceDetail> stackTrace) {
        for (StackTraceElement el : ex.getStackTrace()) {
            stackTrace.add(StackTraceDetail.element(el));
        }
    }
}

