/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs;

import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.Response;
import com.vaynberg.wicket.select2.Select2Choice;
import com.vaynberg.wicket.select2.Settings;
import com.vaynberg.wicket.select2.TextChoiceProvider;
import java.util.Collection;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BreadcrumbPanel
extends PanelAbstract<IModel<Void>> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BREADCRUMBS = "breadcrumbs";

    public BreadcrumbPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        final BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        Model entityModel = new Model();
        final Select2Choice breadcrumbChoice = new Select2Choice(ID_BREADCRUMBS, (IModel)entityModel);
        breadcrumbChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                String oidStr = breadcrumbChoice.getInput();
                EntityModel selectedModel = breadcrumbModel.lookup(oidStr);
                if (selectedModel == null) {
                    MessageBroker messageBroker = IsisContext.getAuthenticationSession().getMessageBroker();
                    messageBroker.addWarning("Cannot find object");
                    String feedbackMsg = JGrowlUtil.asJGrowlCalls(messageBroker);
                    target.appendJavaScript((CharSequence)feedbackMsg);
                    breadcrumbModel.remove(oidStr);
                    return;
                }
                BreadcrumbPanel.this.setResponsePage(EntityPage.class, selectedModel.getPageParameters());
            }
        }});
        Settings settings = breadcrumbChoice.getSettings();
        settings.setMinimumInputLength(Integer.valueOf(0));
        settings.setWidth("100%");
        breadcrumbChoice.setProvider((ChoiceProvider)new TextChoiceProvider<EntityModel>(){
            private static final long serialVersionUID = 1L;

            protected String getDisplayText(EntityModel choice) {
                return breadcrumbModel.titleFor(choice);
            }

            protected Object getId(EntityModel choice) {
                try {
                    return PageParameterNames.OBJECT_OID.getStringFrom(choice.getPageParameters());
                }
                catch (Exception ex) {
                    breadcrumbModel.remove(choice);
                    return null;
                }
            }

            public void query(String term, int page, Response<EntityModel> response) {
                response.addAll(breadcrumbModel.getList());
            }

            public Collection<EntityModel> toChoices(Collection<String> ids) {
                return breadcrumbModel.getList();
            }
        });
        this.addOrReplace(new Component[]{breadcrumbChoice});
    }
}

