/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.vaynberg.wicket.select2.Response;
import com.vaynberg.wicket.select2.TextChoiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.IsisConverterLocator;
import org.apache.wicket.Session;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;

public abstract class ObjectAdapterMementoProviderAbstract
extends TextChoiceProvider<ObjectAdapterMemento> {
    private static final long serialVersionUID = 1L;
    protected static final String NULL_PLACEHOLDER = "$$_isis_null_$$";
    private static final String NULL_DISPLAY_TEXT = "";
    private final ScalarModel scalarModel;
    private final WicketViewerSettings wicketViewerSettings;

    public ObjectAdapterMementoProviderAbstract(ScalarModel scalarModel, WicketViewerSettings wicketViewerSettings) {
        this.scalarModel = scalarModel;
        this.wicketViewerSettings = wicketViewerSettings;
    }

    protected String getDisplayText(ObjectAdapterMemento choice) {
        if (choice == null) {
            return NULL_DISPLAY_TEXT;
        }
        ObjectAdapter objectAdapter = choice.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
        IConverter<Object> converter = this.findConverter(objectAdapter);
        return converter != null ? converter.convertToString(objectAdapter.getObject(), this.getLocale()) : objectAdapter.titleString(null);
    }

    protected Locale getLocale() {
        return Session.exists() ? Session.get().getLocale() : Locale.ENGLISH;
    }

    protected IConverter<Object> findConverter(ObjectAdapter objectAdapter) {
        return IsisConverterLocator.findConverter(objectAdapter, this.wicketViewerSettings);
    }

    protected Object getId(ObjectAdapterMemento choice) {
        return choice != null ? choice.asString() : NULL_PLACEHOLDER;
    }

    public void query(String term, int page, Response<ObjectAdapterMemento> response) {
        ArrayList mementos = Lists.newArrayList(this.obtainMementos(term));
        if (!this.scalarModel.isRequired() && !mementos.contains(null)) {
            mementos.add(0, null);
        }
        response.addAll((Collection)mementos);
    }

    protected abstract List<ObjectAdapterMemento> obtainMementos(String var1);

    protected List<ObjectAdapterMemento> obtainMementos(String term, Collection<ObjectAdapterMemento> choicesMementos) {
        ArrayList matches = Lists.newArrayList();
        if (Strings.isEmpty((CharSequence)term)) {
            matches.addAll(choicesMementos);
        } else {
            for (ObjectAdapterMemento candidate : choicesMementos) {
                ObjectAdapter objectAdapter = candidate.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
                String title = objectAdapter.titleString(objectAdapter);
                if (!title.toLowerCase().contains(term.toLowerCase())) continue;
                matches.add(candidate);
            }
        }
        return matches;
    }

    public Collection<ObjectAdapterMemento> toChoices(Collection<String> ids) {
        Function<String, ObjectAdapterMemento> function = new Function<String, ObjectAdapterMemento>(){

            public ObjectAdapterMemento apply(String input) {
                if (ObjectAdapterMementoProviderAbstract.NULL_PLACEHOLDER.equals(input)) {
                    return null;
                }
                RootOidDefault oid = RootOidDefault.deString((String)input, (OidMarshaller)ObjectAdapterMemento.getOidMarshaller());
                return ObjectAdapterMemento.createPersistent((RootOid)oid);
            }
        };
        return Collections2.transform(ids, (Function)function);
    }

    protected ScalarModel getScalarModel() {
        return this.scalarModel;
    }
}

