/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldAbstract;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.StringValidator;

public abstract class ScalarPanelTextFieldParseableAbstract
extends ScalarPanelTextFieldAbstract<String> {
    private static final long serialVersionUID = 1L;
    protected final String idTextField;

    public ScalarPanelTextFieldParseableAbstract(String id, String idTextField, ScalarModel scalarModel) {
        super(id, scalarModel, String.class);
        this.idTextField = idTextField;
    }

    @Override
    protected AbstractTextComponent<String> createTextFieldForRegular() {
        TextField textField = new TextField(this.idTextField, (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return ((ScalarModel)ScalarPanelTextFieldParseableAbstract.this.getModel()).getObjectAsString();
            }

            public void setObject(String object) {
                if (object == null) {
                    ((ScalarModel)ScalarPanelTextFieldParseableAbstract.this.getModel()).setObject(null);
                } else {
                    ((ScalarModel)ScalarPanelTextFieldParseableAbstract.this.getModel()).setObjectAsString(object);
                }
            }
        });
        return textField;
    }

    @Override
    protected void addStandardSemantics() {
        super.addStandardSemantics();
        this.addMaxLengthValidator();
    }

    private void addMaxLengthValidator() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        AbstractTextComponent textField = this.getTextField();
        ObjectSpecification facetHolder = scalarModel.getTypeOfSpecification();
        MaxLengthFacet maxLengthFacet = (MaxLengthFacet)facetHolder.getFacet(MaxLengthFacet.class);
        if (maxLengthFacet != null) {
            textField.add((IValidator)StringValidator.maximumLength((int)maxLengthFacet.value()));
        }
    }
}

