/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker.TextFieldWithDatePicker;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public abstract class ScalarPanelTextFieldDatePickerAbstract<T extends Serializable>
extends ScalarPanelTextFieldAbstract<T> {
    private static final long serialVersionUID = 1L;
    protected DateConverter<T> converter;
    @Inject
    private WicketViewerSettings settings;

    public ScalarPanelTextFieldDatePickerAbstract(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel, cls);
    }

    protected void init(DateConverter<T> converter) {
        this.converter = converter;
    }

    protected int getAdjustBy() {
        RenderedAdjustedFacet facet = (RenderedAdjustedFacet)((ScalarModel)this.getModel()).getFacet(RenderedAdjustedFacet.class);
        return facet != null ? facet.value() : 0;
    }

    @Override
    protected TextField<T> createTextField(String id) {
        return new TextFieldWithDatePicker(id, this.newTextFieldValueModel(), this.cls, this.converter);
    }

    @Override
    protected Fragment createTextFieldFragment(String id) {
        return new Fragment(id, "date", (MarkupContainer)this);
    }

    @Override
    protected void addSemantics() {
        super.addSemantics();
        this.addObjectAdapterValidator();
    }

    @Override
    protected Component addComponentForCompact() {
        Fragment compactFragment = this.getCompactFragment(ScalarPanelAbstract.CompactType.SPAN);
        Label label = new Label("scalarIfCompact", (IModel)this.newTextFieldValueModel()){

            public <C> IConverter<C> getConverter(Class<C> type) {
                return ScalarPanelTextFieldDatePickerAbstract.this.converter;
            }
        };
        label.setEnabled(false);
        int lengthAdjust = this.getLengthAdjustHint() != null ? this.getLengthAdjustHint() : 1;
        String dateTimePattern = this.converter.getDateTimePattern(this.getLocale());
        int length = dateTimePattern.length() + lengthAdjust;
        label.add(new Behavior[]{new AttributeModifier("size", (IModel)Model.of((Serializable)((Object)("" + length))))});
        compactFragment.add(new Component[]{label});
        this.scalarTypeContainer.addOrReplace(new Component[]{compactFragment});
        return label;
    }

    protected Integer getLengthAdjustHint() {
        return null;
    }

    private void addObjectAdapterValidator() {
        AbstractTextComponent textField = this.getTextField();
        textField.add(new IValidator<T>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<T> validatable) {
                Serializable proposed = (Serializable)validatable.getValue();
                ObjectAdapter proposedAdapter = ScalarPanelTextFieldDatePickerAbstract.this.adapterFor(proposed);
                String reasonIfAny = ScalarPanelTextFieldDatePickerAbstract.this.scalarModel.validate(proposedAdapter);
                if (reasonIfAny != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(reasonIfAny);
                    validatable.error((IValidationError)error);
                }
            }
        });
    }

    protected String getDatePattern() {
        return this.converter.getDatePattern(this.getLocale());
    }

    protected String getDateTimePattern() {
        return this.converter.getDateTimePattern(this.getLocale());
    }

    protected String getDatePickerPattern() {
        return this.converter.getDatePickerPattern(this.getLocale());
    }

    protected WicketViewerSettings getSettings() {
        return this.settings;
    }

    private ObjectAdapter adapterFor(Object pojo) {
        return this.getAdapterManager().adapterFor(pojo);
    }
}

