/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.objectvalue.renderedadjusted.RenderedAdjustedFacet;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib.DateConverterForApplibDate;
import org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib.DateConverterForApplibDateTime;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaSqlDate;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaUtilDate;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath.BigDecimalConverterWithScale;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath.BigIntegerConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaDateTime;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaLocalDate;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaLocalDateTime;
import org.apache.wicket.Application;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class IsisConverterLocator {
    public static IConverter<Object> findConverter(ObjectAdapter objectAdapter, WicketViewerSettings wicketViewerSettings) {
        ObjectSpecification objectSpecification = objectAdapter.getSpecification();
        if (!objectSpecification.isValue()) {
            return null;
        }
        Class correspondingClass = objectSpecification.getCorrespondingClass();
        if (Enum.class.isAssignableFrom(correspondingClass)) {
            return null;
        }
        RenderedAdjustedFacet renderedAdjustedFacet = (RenderedAdjustedFacet)objectSpecification.getFacet(RenderedAdjustedFacet.class);
        int adjustBy = renderedAdjustedFacet != null ? renderedAdjustedFacet.value() : 0;
        IConverter<BigDecimal> converter = null;
        if (java.util.Date.class == correspondingClass) {
            converter = new DateConverterForJavaUtilDate(wicketViewerSettings, adjustBy);
        } else if (Date.class == correspondingClass) {
            converter = new DateConverterForJavaSqlDate(wicketViewerSettings, adjustBy);
        } else if (org.apache.isis.applib.value.Date.class == correspondingClass) {
            converter = new DateConverterForApplibDate(wicketViewerSettings, adjustBy);
        } else if (org.apache.isis.applib.value.DateTime.class == correspondingClass) {
            converter = new DateConverterForApplibDateTime(wicketViewerSettings, adjustBy);
        } else if (LocalDate.class == correspondingClass) {
            converter = new DateConverterForJodaLocalDate(wicketViewerSettings, adjustBy);
        } else if (LocalDateTime.class == correspondingClass) {
            converter = new DateConverterForJodaLocalDateTime(wicketViewerSettings, adjustBy);
        } else if (DateTime.class == correspondingClass) {
            converter = new DateConverterForJodaDateTime(wicketViewerSettings, adjustBy);
        } else if (Timestamp.class == correspondingClass) {
            converter = new IConverter<BigDecimal>(wicketViewerSettings, adjustBy);
        } else if (BigInteger.class == correspondingClass) {
            converter = BigIntegerConverter.INSTANCE;
        } else if (BigDecimal.class == correspondingClass) {
            BigDecimalValueFacet facet = (BigDecimalValueFacet)objectSpecification.getFacet(BigDecimalValueFacet.class);
            Integer scale = null;
            if (facet != null) {
                scale = facet.getScale();
            }
            converter = new BigDecimalConverterWithScale(scale).forViewMode();
        } else if (Application.exists()) {
            IConverterLocator converterLocator = Application.get().getConverterLocator();
            converter = converterLocator.getConverter(correspondingClass);
        }
        return converter;
    }
}

