/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.footer;

import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.themepicker.ThemeChooser;
import org.apache.isis.viewer.wicket.ui.pages.about.AboutPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class FooterPanel
extends PanelAbstract<Model<String>> {
    private static final String ID_BREADCRUMBS = "breadcrumbs";
    private static final String ID_ABOUT_LINK = "aboutLink";
    private static final String ID_ABOUT_MESSAGE = "aboutMessage";
    private static final String ID_THEME_PICKER = "themePicker";

    public FooterPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addBreadcrumbs();
        this.addAboutLink();
        this.addThemePicker();
    }

    private void addBreadcrumbs() {
        BreadcrumbPanel breadcrumbPanel = new BreadcrumbPanel(ID_BREADCRUMBS);
        this.addOrReplace(new Component[]{breadcrumbPanel});
    }

    protected void onConfigure() {
        super.onConfigure();
        PageParameters parameters = this.getPage().getPageParameters();
        this.setVisible(parameters.get("isis.no.footer").isNull());
    }

    private void addAboutLink() {
        BookmarkablePageLink aboutLink = new BookmarkablePageLink(ID_ABOUT_LINK, AboutPage.class);
        this.add(new Component[]{aboutLink});
        Label aboutLabel = new Label(ID_ABOUT_MESSAGE, (IModel)new ResourceModel("aboutLabel"));
        aboutLink.add(new Component[]{aboutLabel});
        this.addDevModeWarning((MarkupContainer)aboutLink);
    }

    private void addDevModeWarning(MarkupContainer container) {
        WebComponent devModeWarning = new WebComponent("devModeWarning");
        devModeWarning.setVisible(this.getApplication().usesDevelopmentConfig());
        container.add(new Component[]{devModeWarning});
    }

    private void addThemePicker() {
        ThemeChooser themeChooser = new ThemeChooser(ID_THEME_PICKER);
        this.addOrReplace(new Component[]{themeChooser});
    }
}

