/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.selector.links;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.viewer.wicket.model.hints.IsisUiHintEvent;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintPathSignificant;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.LinksProvider;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.CssClassRemover;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EntityLinksSelectorPanel
extends PanelAbstract<EntityModel>
implements UiHintPathSignificant {
    private static final long serialVersionUID = 1L;
    private static final String INVISIBLE_CLASS = "link-selector-panel-invisible";
    private static final int MAX_NUM_UNDERLYING_VIEWS = 10;
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_VIEWS = "views";
    private static final String ID_VIEW_LIST = "viewList";
    private static final String ID_VIEW_LINK = "viewLink";
    private static final String ID_VIEW_ITEM = "viewItem";
    private static final String ID_VIEW_ITEM_TITLE = "viewItemTitle";
    private static final String ID_VIEW_ITEM_ICON = "viewItemIcon";
    private static final String UIHINT_VIEW = "view";
    private static final String ID_VIEW_BUTTON_TITLE = "viewButtonTitle";
    private static final String ID_VIEW_BUTTON_ICON = "viewButtonIcon";
    private final ComponentType componentType;
    private final String underlyingIdPrefix = ComponentType.ENTITY.toString();
    private ComponentFactory selectedComponentFactory;
    protected Component selectedComponent;

    public EntityLinksSelectorPanel(String id, EntityModel model, ComponentFactory factory) {
        super(id, model);
        this.componentType = factory.getComponentType();
    }

    protected int determineInitialFactory(List<ComponentFactory> componentFactories, IModel<?> model) {
        return 0;
    }

    @Override
    public UiHintContainer getUiHintContainer() {
        return null;
    }

    public void onInitialize() {
        super.onInitialize();
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactoryElseFailFast(this.getComponentType(), (IModel<?>)this.getModel());
        this.addAdditionalLinks((EntityModel)this.getModel());
        this.addUnderlyingViews(this.underlyingIdPrefix, (EntityModel)this.getModel(), componentFactory);
    }

    protected void addAdditionalLinks(EntityModel model) {
        if (!(model instanceof LinksProvider)) {
            this.permanentlyHide(ID_ADDITIONAL_LINKS);
            return;
        }
        LinksProvider linksProvider = (LinksProvider)model;
        List links = linksProvider.getLinks();
        this.addAdditionalLinks((MarkupContainer)this, links);
    }

    protected void addAdditionalLinks(MarkupContainer markupContainer, List<LinkAndLabel> links) {
        if (links == null || links.isEmpty()) {
            Components.permanentlyHide(markupContainer, ID_ADDITIONAL_LINKS);
            return;
        }
        links = Lists.newArrayList(links);
        AdditionalLinksPanel.addAdditionalLinks(markupContainer, ID_ADDITIONAL_LINKS, links, AdditionalLinksPanel.Style.INLINE_LIST);
    }

    private void addUnderlyingViews(String underlyingIdPrefix, final EntityModel model, ComponentFactory factory) {
        List<ComponentFactory> componentFactories = this.findOtherComponentFactories(model, factory);
        int selected = this.honourViewHintElseDefault(componentFactories, (IModel<?>)model);
        final EntityLinksSelectorPanel selectorPanel = this;
        final Component[] underlyingViews = new Component[10];
        int i = 0;
        EntityModel emptyModel = this.dummyOf(model);
        for (ComponentFactory componentFactory : componentFactories) {
            String underlyingId = underlyingIdPrefix + "-" + i;
            Component underlyingView = componentFactory.createComponent(underlyingId, (IModel<?>)(i == selected ? model : emptyModel));
            underlyingViews[i++] = underlyingView;
            selectorPanel.addOrReplace(new Component[]{underlyingView});
        }
        while (i < 10) {
            String underlyingId = underlyingIdPrefix + "-" + i;
            this.permanentlyHide(underlyingId);
            ++i;
        }
        if (componentFactories.size() <= 1) {
            this.permanentlyHide(ID_VIEWS);
        } else {
            Model componentFactoryModel = new Model();
            selectorPanel.selectedComponentFactory = componentFactories.get(selected);
            componentFactoryModel.setObject((Serializable)selectorPanel.selectedComponentFactory);
            final WebMarkupContainer views = new WebMarkupContainer(ID_VIEWS);
            final Label viewButtonTitle = new Label(ID_VIEW_BUTTON_TITLE, "Hidden");
            views.addOrReplace(new Component[]{viewButtonTitle});
            final Label viewButtonIcon = new Label(ID_VIEW_BUTTON_ICON, "");
            views.addOrReplace(new Component[]{viewButtonIcon});
            WebMarkupContainer container = new WebMarkupContainer(ID_VIEW_LIST);
            views.addOrReplace(new Component[]{container});
            views.setOutputMarkupId(true);
            this.setOutputMarkupId(true);
            ListView<ComponentFactory> listView = new ListView<ComponentFactory>(ID_VIEW_ITEM, componentFactories){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<ComponentFactory> item) {
                    boolean isEnabled;
                    final int underlyingViewNum = item.getIndex();
                    final ComponentFactory componentFactory = (ComponentFactory)item.getModelObject();
                    AjaxLink<Void> link = new AjaxLink<Void>(EntityLinksSelectorPanel.ID_VIEW_LINK){
                        private static final long serialVersionUID = 1L;

                        public void onClick(AjaxRequestTarget target) {
                            EntityLinksSelectorPanel linksSelectorPanel = EntityLinksSelectorPanel.this;
                            linksSelectorPanel.setViewHintAndBroadcast(underlyingViewNum, target);
                            EntityModel dummyModel = EntityLinksSelectorPanel.this.dummyOf(model);
                            for (int i = 0; i < 10; ++i) {
                                Component component = underlyingViews[i];
                                if (component == null) continue;
                                boolean isSelected = i == underlyingViewNum;
                                EntityLinksSelectorPanel.applyCssVisibility(component, isSelected);
                                component.setDefaultModel((IModel)(isSelected ? model : dummyModel));
                            }
                            selectorPanel.selectedComponentFactory = componentFactory;
                            selectorPanel.selectedComponent = underlyingViews[underlyingViewNum];
                            selectorPanel.onSelect(target);
                            target.add(new Component[]{selectorPanel, views});
                        }

                        protected void onComponentTag(ComponentTag tag) {
                            super.onComponentTag(tag);
                            Buttons.fixDisabledState((Component)this, (ComponentTag)tag);
                        }
                    };
                    IModel<String> title = this.nameFor(componentFactory);
                    Label viewItemTitleLabel = new Label(EntityLinksSelectorPanel.ID_VIEW_ITEM_TITLE, title);
                    link.add(new Component[]{viewItemTitleLabel});
                    Label viewItemIcon = new Label(EntityLinksSelectorPanel.ID_VIEW_ITEM_ICON, "");
                    link.add(new Component[]{viewItemIcon});
                    boolean bl = isEnabled = componentFactory != selectorPanel.selectedComponentFactory;
                    if (!isEnabled) {
                        viewButtonTitle.setDefaultModel(title);
                        IModel<String> cssClass = this.cssClassFor(componentFactory, viewButtonIcon);
                        viewButtonIcon.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)("ViewLinkItem " + (String)cssClass.getObject())))});
                        link.setVisible(false);
                    } else {
                        IModel<String> cssClass = this.cssClassFor(componentFactory, viewItemIcon);
                        viewItemIcon.add(new Behavior[]{new CssClassAppender(cssClass)});
                    }
                    item.add(new Component[]{link});
                }

                private IModel<String> cssClassFor(ComponentFactory componentFactory, Label viewIcon) {
                    Model cssClass = null;
                    if (componentFactory instanceof CollectionContentsAsFactory) {
                        CollectionContentsAsFactory collectionContentsAsFactory = (CollectionContentsAsFactory)((Object)componentFactory);
                        cssClass = collectionContentsAsFactory.getCssClass();
                        viewIcon.setDefaultModelObject((Object)"");
                        viewIcon.setEscapeModelStrings(true);
                    }
                    if (cssClass == null) {
                        String name = componentFactory.getName();
                        cssClass = Model.of((Serializable)((Object)StringExtensions.asLowerDashed((String)name)));
                        viewIcon.setDefaultModelObject((Object)"&#160;&#160;&#160;&#160;&#160;");
                        viewIcon.setEscapeModelStrings(false);
                    }
                    return cssClass;
                }

                private IModel<String> nameFor(ComponentFactory componentFactory) {
                    Model name = null;
                    if (componentFactory instanceof CollectionContentsAsFactory) {
                        CollectionContentsAsFactory collectionContentsAsFactory = (CollectionContentsAsFactory)((Object)componentFactory);
                        name = collectionContentsAsFactory.getTitleLabel();
                    }
                    if (name == null) {
                        name = Model.of((Serializable)((Object)componentFactory.getName()));
                    }
                    return name;
                }
            };
            container.add(new Component[]{listView});
            this.addOrReplace(new Component[]{views});
        }
        for (i = 0; i < 10; ++i) {
            Component component = underlyingViews[i];
            if (component == null) continue;
            if (i != selected) {
                component.add(new Behavior[]{new CssClassAppender(INVISIBLE_CLASS)});
                continue;
            }
            this.selectedComponent = component;
        }
    }

    protected void setViewHintAndBroadcast(int viewNum, AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, UIHINT_VIEW, "" + viewNum);
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new IsisUiHintEvent(uiHintContainer, target));
    }

    protected void onSelect(AjaxRequestTarget target) {
    }

    protected EntityModel dummyOf(EntityModel model) {
        return model;
    }

    protected static void applyCssVisibility(Component component, boolean visible) {
        if (component == null) {
            return;
        }
        Object modifier = visible ? new CssClassRemover(INVISIBLE_CLASS) : new CssClassAppender(INVISIBLE_CLASS);
        component.add(new Behavior[]{modifier});
    }

    protected int honourViewHintElseDefault(List<ComponentFactory> componentFactories, IModel<?> model) {
        String viewStr;
        UiHintContainer hintContainer = this.getUiHintContainer();
        if (hintContainer != null && (viewStr = hintContainer.getHint((Component)this, UIHINT_VIEW)) != null) {
            try {
                int view = Integer.parseInt(viewStr);
                if (view >= 0 && view < componentFactories.size()) {
                    return view;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int initialFactory = this.determineInitialFactory(componentFactories, model);
        if (hintContainer != null) {
            hintContainer.setHint((Component)this, UIHINT_VIEW, "" + initialFactory);
        }
        return initialFactory;
    }

    private List<ComponentFactory> findOtherComponentFactories(EntityModel model, final ComponentFactory ignoreFactory) {
        List<ComponentFactory> componentFactories = this.getComponentFactoryRegistry().findComponentFactories(this.componentType, (IModel<?>)model);
        ArrayList otherFactories = Lists.newArrayList((Iterable)Collections2.filter(componentFactories, (Predicate)new Predicate<ComponentFactory>(){

            public boolean apply(ComponentFactory input) {
                return input != ignoreFactory;
            }
        }));
        return this.ordered(otherFactories);
    }

    protected List<ComponentFactory> ordered(List<ComponentFactory> otherFactories) {
        return otherFactories;
    }
}

