/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.multiple;

import java.util.List;
import org.apache.isis.viewer.wicket.model.hints.IsisEnvelopeEvent;
import org.apache.isis.viewer.wicket.model.hints.IsisUiHintEvent;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintPathSignificant;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.CssClassRemover;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

public class CollectionContentsMultipleViewsPanel
extends PanelAbstract<EntityCollectionModel>
implements UiHintPathSignificant,
CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final String INVISIBLE_CLASS = "link-selector-panel-invisible";
    private static final int MAX_NUM_UNDERLYING_VIEWS = 10;
    private static final String UIHINT_VIEW = "view";
    private final ComponentFactory ignoreFactory;
    private final ComponentType componentType;
    private final String underlyingIdPrefix;
    private final CollectionSelectorHelper selectorHelper;
    private ComponentFactory selectedComponentFactory;
    private Component selectedComponent;
    private Component[] underlyingViews;
    private CollectionSelectorPanel selectorDropdownPanel;

    public CollectionContentsMultipleViewsPanel(String id, EntityCollectionModel model, ComponentFactory ignoreFactory) {
        super(id, model);
        this.ignoreFactory = ignoreFactory;
        this.underlyingIdPrefix = ComponentType.COLLECTION_CONTENTS.toString();
        this.componentType = ignoreFactory.getComponentType();
        this.selectorHelper = new CollectionSelectorHelper(model, this.getComponentFactoryRegistry());
    }

    public void onInitialize() {
        super.onInitialize();
        this.addUnderlyingViews();
    }

    private void addUnderlyingViews() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        CollectionSelectorPanel selectorDropdownPanelIfAny = CollectionSelectorProvider.Util.getCollectionSelectorProvider((Component)this);
        int selected = selectorDropdownPanelIfAny != null ? this.selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanelIfAny) : 0;
        List<ComponentFactory> componentFactories = this.selectorHelper.getComponentFactories();
        int i = 0;
        this.underlyingViews = new Component[10];
        EntityCollectionModel emptyModel = model.asDummy();
        for (ComponentFactory componentFactory : componentFactories) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            Component underlyingView = componentFactory.createComponent(underlyingId, (IModel<?>)(i == selected ? model : emptyModel));
            this.underlyingViews[i++] = underlyingView;
            this.addOrReplace(new Component[]{underlyingView});
        }
        while (i < 10) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            this.permanentlyHide(underlyingId);
            ++i;
        }
        this.setOutputMarkupId(true);
        for (i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            if (i != selected) {
                component.add(new Behavior[]{new CssClassAppender(INVISIBLE_CLASS)});
                continue;
            }
            this.selectedComponent = component;
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        IsisUiHintEvent uiHintEvent = (IsisUiHintEvent)IsisEnvelopeEvent.openLetter(event, IsisUiHintEvent.class);
        if (uiHintEvent == null) {
            return;
        }
        UiHintContainer uiHintContainer = uiHintEvent.getUiHintContainer();
        int underlyingViewNum = 0;
        CollectionSelectorPanel selectorDropdownPanel = CollectionSelectorProvider.Util.getCollectionSelectorProvider((Component)this);
        if (selectorDropdownPanel == null) {
            return;
        }
        String viewStr = uiHintContainer.getHint((Component)selectorDropdownPanel, UIHINT_VIEW);
        List<ComponentFactory> componentFactories = this.selectorHelper.getComponentFactories();
        if (viewStr != null) {
            try {
                int view = Integer.parseInt(viewStr);
                if (view >= 0 && view < componentFactories.size()) {
                    underlyingViewNum = view;
                }
                EntityCollectionModel dummyModel = ((EntityCollectionModel)this.getModel()).asDummy();
                for (int i = 0; i < 10; ++i) {
                    Component component = this.underlyingViews[i];
                    if (component == null) continue;
                    boolean isSelected = i == underlyingViewNum;
                    CollectionContentsMultipleViewsPanel.applyCssVisibility(component, isSelected);
                    component.setDefaultModel((IModel)(isSelected ? (EntityCollectionModel)this.getModel() : dummyModel));
                }
                this.selectedComponentFactory = this.ignoreFactory;
                this.selectedComponent = this.underlyingViews[underlyingViewNum];
                AjaxRequestTarget target = uiHintEvent.getTarget();
                if (target != null) {
                    target.add(new Component[]{this, selectorDropdownPanel});
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected static void applyCssVisibility(Component component, boolean visible) {
        if (component == null) {
            return;
        }
        Object modifier = visible ? new CssClassRemover(INVISIBLE_CLASS) : new CssClassAppender(INVISIBLE_CLASS);
        component.add(new Behavior[]{modifier});
    }

    @Override
    public Integer getCount() {
        if (this.selectedComponent instanceof CollectionCountProvider) {
            CollectionCountProvider collectionCountProvider = (CollectionCountProvider)this.selectedComponent;
            return collectionCountProvider.getCount();
        }
        return null;
    }
}

