/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import com.google.common.base.Throwables;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.viewer.wicket.model.models.ActionExecutor;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseHandlingStrategy;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseType;
import org.apache.isis.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ActionPanel
extends PanelAbstract<ActionModel>
implements ActionExecutor {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    static final String ID_ACTION_NAME = "actionName";
    private ActionPrompt actionPrompt;
    private boolean showHeader = true;

    public ActionPanel(String id, ActionModel actionModel) {
        super(id, actionModel);
        actionModel.setExecutor((ActionExecutor)this);
        this.buildGui(actionModel);
    }

    public void setActionPrompt(ActionPrompt actionPrompt) {
        this.actionPrompt = actionPrompt;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui((ActionModel)this.getModel());
    }

    private void buildGui(ActionModel actionModel) {
        if (actionModel.hasParameters()) {
            this.buildGuiForParameters();
        } else {
            boolean succeeded = this.executeActionAndProcessResults(null, null);
            if (!succeeded) {
                ObjectAdapter targetAdapter = actionModel.getTargetAdapter();
                ActionResultResponse resultResponse = ActionResultResponseType.OBJECT.interpretResult(this.getActionModel(), targetAdapter, null);
                resultResponse.getHandlingStrategy().handleResults((Component)this, resultResponse);
            }
        }
    }

    ActionModel getActionModel() {
        return (ActionModel)super.getModel();
    }

    public ActionPanel setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        return this;
    }

    private void buildGuiForParameters() {
        WebMarkupContainer header = new WebMarkupContainer(ID_HEADER){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ActionPanel.this.showHeader);
            }
        };
        this.addOrReplace(new Component[]{header});
        ObjectAdapter targetAdapter = null;
        try {
            targetAdapter = this.getActionModel().getTargetAdapter();
            this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.PARAMETERS, (IModel<?>)this.getActionModel());
            this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)new EntityModel(targetAdapter));
            String actionName = this.getActionModel().getActionMemento().getAction().getName();
            header.add(new Component[]{new Label(ID_ACTION_NAME, (IModel)Model.of((Serializable)((Object)actionName)))});
        }
        catch (ConcurrencyException ex) {
            if (targetAdapter == null) {
                targetAdapter = ((ActionModel)this.getModel()).getTargetAdapter();
            }
            ActionResultResponse resultResponse = ActionResultResponseType.OBJECT.interpretResult(this.getActionModel(), targetAdapter, ex);
            resultResponse.getHandlingStrategy().handleResults((Component)this, resultResponse);
            this.getMessageBroker().addWarning(ex.getMessage());
        }
    }

    protected void bookmarkPage(BookmarkableModel<?> model) {
        this.getBookmarkedPagesModel().bookmarkPage(model);
    }

    private BookmarkedPagesModel getBookmarkedPagesModel() {
        BookmarkedPagesModelProvider application = (BookmarkedPagesModelProvider)this.getSession();
        return application.getBookmarkedPagesModel();
    }

    public boolean executeActionAndProcessResults(AjaxRequestTarget target, Form<?> feedbackForm) {
        this.permanentlyHide(ComponentType.ENTITY_ICON_AND_TITLE);
        ObjectAdapter targetAdapter = null;
        try {
            targetAdapter = ((ActionModel)this.getModel()).getTargetAdapter();
            return this.executeActionOnTargetAndProcessResults(targetAdapter, target, feedbackForm);
        }
        catch (ConcurrencyException ex) {
            if (targetAdapter == null) {
                targetAdapter = ((ActionModel)this.getModel()).getTargetAdapter();
            }
            ActionResultResponse resultResponse = ActionResultResponseType.OBJECT.interpretResult(this.getActionModel(), targetAdapter, ex);
            resultResponse.getHandlingStrategy().handleResults((Component)this, resultResponse);
            this.getMessageBroker().addWarning(ex.getMessage());
            return false;
        }
    }

    private boolean executeActionOnTargetAndProcessResults(ObjectAdapter targetAdapter, AjaxRequestTarget target, Form<?> feedbackForm) {
        Command command;
        ActionModel actionModel = this.getActionModel();
        String invalidReasonIfAny = actionModel.getReasonInvalidIfAny();
        if (invalidReasonIfAny != null) {
            this.raiseWarning(target, feedbackForm, invalidReasonIfAny);
            return false;
        }
        CommandContext commandContext = (CommandContext)this.getServicesInjector().lookupService(CommandContext.class);
        if (commandContext != null) {
            command = commandContext.getCommand();
            command.setExecutor(Command.Executor.USER);
        } else {
            command = null;
        }
        try {
            ObjectAdapter resultAdapter = this.getActionModel().executeHandlingApplicationExceptions();
            this.getTransactionManager().flushTransaction();
            ActionResultResponse resultResponse = ActionResultResponseType.determineAndInterpretResult(this.getActionModel(), target, resultAdapter);
            resultResponse.getHandlingStrategy().handleResults((Component)this, resultResponse);
            if (actionModel.isBookmarkable()) {
                this.bookmarkPage((BookmarkableModel<?>)actionModel);
            }
            if (this.actionPrompt != null) {
                this.actionPrompt.closePrompt(target);
                actionModel.clearArguments();
            }
            return true;
        }
        catch (RuntimeException ex) {
            String message = this.recognizeException(ex, target, feedbackForm);
            if (message != null) {
                if (feedbackForm == null) {
                    ActionResultResponseHandlingStrategy.REDIRECT_TO_VOID.handleResults((Component)this, null);
                }
                return false;
            }
            if (command != null) {
                command.setException(Throwables.getStackTraceAsString((Throwable)ex));
            }
            throw ex;
        }
    }

    private String recognizeException(RuntimeException ex, AjaxRequestTarget target, Form<?> feedbackForm) {
        List exceptionRecognizers = this.getServicesInjector().lookupServices(ExceptionRecognizer.class);
        String recognizedErrorIfAny = new ExceptionRecognizerComposite(exceptionRecognizers).recognize((Throwable)ex);
        if (recognizedErrorIfAny != null) {
            this.raiseWarning(target, feedbackForm, recognizedErrorIfAny);
            this.getTransactionManager().getTransaction().clearAbortCause();
        }
        return recognizedErrorIfAny;
    }

    public void raiseWarning(AjaxRequestTarget target, Form<?> feedbackForm, String error) {
        if (target != null && feedbackForm != null) {
            target.add(new Component[]{feedbackForm});
            feedbackForm.error((Serializable)((Object)error));
        } else {
            this.getMessageBroker().addWarning(error);
        }
    }

    protected IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }

    protected ServicesInjector getServicesInjector() {
        return IsisContext.getPersistenceSession().getServicesInjector();
    }

    protected MessageBroker getMessageBroker() {
        return this.getAuthenticationSession().getMessageBroker();
    }
}

