/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintPathSignificant;
import org.apache.wicket.Component;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;

public abstract class ModelAbstract<T>
extends LoadableDetachableModel<T>
implements UiHintContainer {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> hints = Maps.newTreeMap();

    public ModelAbstract() {
    }

    public ModelAbstract(T t) {
        super(t);
    }

    @Override
    public String getHint(Component component, String key) {
        if (component == null) {
            return null;
        }
        String hintKey = ModelAbstract.hintKey(component, key);
        return this.hints.get(hintKey);
    }

    @Override
    public void setHint(Component component, String key, String value) {
        if (component == null) {
            return;
        }
        String hintKey = ModelAbstract.hintKey(component, key);
        if (value != null) {
            this.hints.put(hintKey, value);
        } else {
            this.hints.remove(hintKey);
        }
    }

    @Override
    public void clearHint(Component component, String key) {
        this.setHint(component, key, null);
    }

    private static String hintKey(Component component, String key) {
        return ModelAbstract.hintPathFor(component) + "-" + key;
    }

    private static String hintPathFor(Component component) {
        return Strings.afterFirstPathComponent((String)ModelAbstract.fullHintPathFor(component), (char)':');
    }

    private static String fullHintPathFor(Component component) {
        PrependingStringBuffer buffer = new PrependingStringBuffer(32);
        for (Component c = component; c != null; c = c.getParent()) {
            if (!(c instanceof UiHintPathSignificant)) continue;
            if (buffer.length() > 0) {
                buffer.prepend(':');
            }
            buffer.prepend(c.getId());
        }
        return buffer.toString();
    }

    protected Map<String, String> getHints() {
        return this.hints;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }
}

