/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.commons.lang.Closure;
import org.apache.isis.core.commons.lang.IterableExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.object.paged.PagedFacet;
import org.apache.isis.core.metamodel.facets.object.plural.PluralFacet;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.LinksProvider;
import org.apache.isis.viewer.wicket.model.mementos.CollectionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;

public class EntityCollectionModel
extends ModelAbstract<List<ObjectAdapter>>
implements LinksProvider {
    private static final long serialVersionUID = 1L;
    private static final int PAGE_SIZE_DEFAULT_FOR_PARENTED = 12;
    private static final int PAGE_SIZE_DEFAULT_FOR_STANDALONE = 25;
    private final Type type;
    private final Class<?> typeOf;
    private transient ObjectSpecification typeOfSpec;
    private List<ObjectAdapterMemento> mementoList;
    private List<ObjectAdapterMemento> toggledMementosList;
    private ObjectAdapterMemento parentObjectAdapterMemento;
    private CollectionMemento collectionMemento;
    private final int pageSize;
    private List<LinkAndLabel> entityActions = Lists.newArrayList();
    private Class<? extends Comparator<?>> sortedBy;
    private ActionModel actionModelHint;

    public static EntityCollectionModel createStandalone(ObjectAdapter collectionAsAdapter) {
        Class elementType;
        ObjectSpecification elementSpec;
        Iterable<Object> pojos = EntityCollectionModel.asIterable(collectionAsAdapter);
        ArrayList mementoList = Lists.newArrayList((Iterable)Iterables.transform(pojos, ObjectAdapterMemento.Functions.fromPojo(EntityCollectionModel.getAdapterManagerStatic())));
        if (!Iterables.isEmpty(pojos)) {
            LowestCommonSuperclassClosure closure = new LowestCommonSuperclassClosure();
            Function function = new Function<Object, Class<?>>(){

                public Class<?> apply(Object obj) {
                    return obj.getClass();
                }
            };
            IterableExtensions.fold((Iterable)Iterables.transform(pojos, (Function)function), (Closure)closure);
            elementSpec = EntityCollectionModel.getSpecificationLoaderStatic().loadSpecification(closure.getLowestCommonSuperclass());
        } else {
            elementSpec = collectionAsAdapter.getElementSpecification();
        }
        int pageSize = 25;
        if (elementSpec != null) {
            elementType = elementSpec.getCorrespondingClass();
            pageSize = EntityCollectionModel.pageSize((PagedFacet)elementSpec.getFacet(PagedFacet.class), 25);
        } else {
            elementType = Object.class;
        }
        return new EntityCollectionModel(elementType, mementoList, pageSize);
    }

    public ActionModel getActionModelHint() {
        return this.actionModelHint;
    }

    public void setActionHint(ActionModel actionModelHint) {
        this.actionModelHint = actionModelHint;
    }

    public static EntityCollectionModel createParented(EntityModel model, OneToManyAssociation collection) {
        return new EntityCollectionModel(model, collection);
    }

    public static EntityCollectionModel createParented(ObjectAdapter adapter, OneToManyAssociation collection) {
        return new EntityCollectionModel(adapter, collection);
    }

    private EntityCollectionModel(Class<?> typeOf, List<ObjectAdapterMemento> mementoList, int pageSize) {
        this.type = Type.STANDALONE;
        this.typeOf = typeOf;
        this.mementoList = mementoList;
        this.pageSize = pageSize;
        this.toggledMementosList = Lists.newArrayList();
    }

    private EntityCollectionModel(ObjectAdapter adapter, OneToManyAssociation collection) {
        this(ObjectAdapterMemento.createOrNull(adapter), collection);
    }

    private EntityCollectionModel(EntityModel model, OneToManyAssociation collection) {
        this(model.getObjectAdapterMemento(), collection);
    }

    private EntityCollectionModel(ObjectAdapterMemento parentAdapterMemento, OneToManyAssociation collection) {
        this.type = Type.PARENTED;
        this.typeOf = EntityCollectionModel.forName(collection.getSpecification());
        this.parentObjectAdapterMemento = parentAdapterMemento;
        this.collectionMemento = new CollectionMemento(collection);
        this.pageSize = EntityCollectionModel.pageSize((PagedFacet)collection.getFacet(PagedFacet.class), 12);
        SortedByFacet sortedByFacet = (SortedByFacet)collection.getFacet(SortedByFacet.class);
        this.sortedBy = sortedByFacet != null ? (Class)sortedByFacet.value() : null;
    }

    private static Class<?> forName(ObjectSpecification objectSpec) {
        String fullName = objectSpec.getFullIdentifier();
        return ClassUtil.forName((String)fullName);
    }

    private static int pageSize(PagedFacet pagedFacet, int defaultPageSize) {
        return pagedFacet != null ? pagedFacet.value() : defaultPageSize;
    }

    public boolean isParented() {
        return this.type == Type.PARENTED;
    }

    public boolean isStandalone() {
        return this.type == Type.STANDALONE;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getName() {
        return this.type.getName(this);
    }

    public int getCount() {
        return this.type.getCount(this);
    }

    protected List<ObjectAdapter> load() {
        return this.type.load(this);
    }

    public ObjectSpecification getTypeOfSpecification() {
        if (this.typeOfSpec == null) {
            this.typeOfSpec = EntityCollectionModel.getSpecificationLoaderStatic().loadSpecification(this.typeOf);
        }
        return this.typeOfSpec;
    }

    public void setObject(List<ObjectAdapter> list) {
        super.setObject(list);
        this.type.setObject(this, list);
    }

    public void setObjectList(ObjectAdapter resultAdapter) {
        Iterable<Object> pojos = EntityCollectionModel.asIterable(resultAdapter);
        this.mementoList = Lists.newArrayList((Iterable)Iterables.transform(pojos, ObjectAdapterMemento.Functions.fromPojo(EntityCollectionModel.getAdapterManagerStatic())));
    }

    public ObjectAdapterMemento getParentObjectAdapterMemento() {
        return this.parentObjectAdapterMemento;
    }

    public CollectionMemento getCollectionMemento() {
        return this.collectionMemento;
    }

    private static Iterable<Object> asIterable(ObjectAdapter resultAdapter) {
        return (Iterable)resultAdapter.getObject();
    }

    public void toggleSelectionOn(ObjectAdapter selectedAdapter) {
        ObjectAdapterMemento selectedAsMemento = ObjectAdapterMemento.createOrNull(selectedAdapter);
        boolean removed = this.toggledMementosList.remove(selectedAsMemento);
        if (!removed) {
            this.toggledMementosList.add(selectedAsMemento);
        }
    }

    public List<ObjectAdapterMemento> getToggleMementosList() {
        return Collections.unmodifiableList(this.toggledMementosList);
    }

    public void clearToggleMementosList() {
        this.toggledMementosList.clear();
    }

    public void addEntityActions(List<LinkAndLabel> entityActions) {
        this.entityActions.addAll(entityActions);
    }

    @Override
    public List<LinkAndLabel> getLinks() {
        return Collections.unmodifiableList(this.entityActions);
    }

    public EntityCollectionModel asDummy() {
        return new EntityCollectionModel(this.typeOf, Collections.emptyList(), this.pageSize);
    }

    private static AdapterManager getAdapterManagerStatic() {
        return EntityCollectionModel.getPersistenceSessionStatic().getAdapterManager();
    }

    private static ServicesInjectorSpi getServicesInjector() {
        return EntityCollectionModel.getPersistenceSessionStatic().getServicesInjector();
    }

    private static PersistenceSession getPersistenceSessionStatic() {
        return IsisContext.getPersistenceSession();
    }

    private static SpecificationLoaderSpi getSpecificationLoaderStatic() {
        return IsisContext.getSpecificationLoader();
    }

    static class LowestCommonSuperclassClosure
    implements Closure<Class<?>> {
        private Class<?> common;

        LowestCommonSuperclassClosure() {
        }

        public Class<?> execute(Class<?> value) {
            if (this.common == null) {
                this.common = value;
            } else {
                Class<?> current = this.common;
                while (!current.isAssignableFrom(value)) {
                    current = current.getSuperclass();
                }
                this.common = current;
            }
            return this.common;
        }

        Class<?> getLowestCommonSuperclass() {
            return this.common;
        }
    }

    public static enum Type {
        STANDALONE{

            @Override
            List<ObjectAdapter> load(EntityCollectionModel entityCollectionModel) {
                return Lists.transform((List)entityCollectionModel.mementoList, ObjectAdapterMemento.Functions.fromMemento(AdapterManager.ConcurrencyChecking.NO_CHECK));
            }

            @Override
            void setObject(EntityCollectionModel entityCollectionModel, List<ObjectAdapter> list) {
                entityCollectionModel.mementoList = Lists.newArrayList((Iterable)Lists.transform(list, ObjectAdapterMemento.Functions.toMemento()));
            }

            @Override
            public String getName(EntityCollectionModel model) {
                PluralFacet facet = (PluralFacet)model.getTypeOfSpecification().getFacet(PluralFacet.class);
                return facet.value();
            }

            @Override
            public int getCount(EntityCollectionModel model) {
                return model.mementoList.size();
            }
        }
        ,
        PARENTED{

            @Override
            List<ObjectAdapter> load(EntityCollectionModel entityCollectionModel) {
                ObjectAdapter adapter = entityCollectionModel.parentObjectAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
                OneToManyAssociation collection = entityCollectionModel.collectionMemento.getCollection();
                ObjectAdapter collectionAsAdapter = collection.get(adapter);
                List<Object> objectList = this.asIterable(collectionAsAdapter);
                Class sortedBy = entityCollectionModel.sortedBy;
                if (sortedBy != null) {
                    Comparator comparator = (Comparator)InstanceUtil.createInstance((Class)sortedBy);
                    EntityCollectionModel.getServicesInjector().injectServicesInto((Object)comparator);
                    Collections.sort(objectList, comparator);
                }
                Iterable adapterIterable = Iterables.transform(objectList, (Function)ObjectAdapter.Functions.adapterForUsing((AdapterManager)EntityCollectionModel.getAdapterManagerStatic()));
                ArrayList adapterList = Lists.newArrayList((Iterable)adapterIterable);
                return adapterList;
            }

            private List<Object> asIterable(ObjectAdapter collectionAsAdapter) {
                Iterable objects = (Iterable)collectionAsAdapter.getObject();
                return Lists.newArrayList((Iterable)objects);
            }

            @Override
            void setObject(EntityCollectionModel entityCollectionModel, List<ObjectAdapter> list) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getName(EntityCollectionModel model) {
                return model.getCollectionMemento().getName();
            }

            @Override
            public int getCount(EntityCollectionModel model) {
                return this.load(model).size();
            }
        };


        abstract List<ObjectAdapter> load(EntityCollectionModel var1);

        abstract void setObject(EntityCollectionModel var1, List<ObjectAdapter> var2);

        public abstract String getName(EntityCollectionModel var1);

        public abstract int getCount(EntityCollectionModel var1);
    }
}

