/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.registries.pages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@Singleton
public class PageNavigationServiceDefault
implements PageNavigationService {
    private static final long serialVersionUID = 1L;
    private final PageClassRegistry pageClassRegistry;

    @Inject
    public PageNavigationServiceDefault(PageClassRegistry pageClassRegistry) {
        this.pageClassRegistry = pageClassRegistry;
    }

    public void navigateTo(PageType pageType) {
        this.navigateTo(pageType, new PageParameters());
    }

    public void navigateTo(PageType pageType, PageParameters parameters) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        RequestCycle.get().setResponsePage(pageClass, parameters);
    }

    public void restartAt(PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        throw new RestartResponseException(pageClass);
    }

    public void interceptAndRestartAt(PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        throw new RestartResponseAtInterceptPageException(pageClass);
    }
}

