/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.vaynberg.wicket.select2.ApplicationSettings;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.webjars.WicketWebjars;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.settings.WebjarsSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import net.ftlines.wicketsource.WicketSource;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderPrimer;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderResourceStreams;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceComposite;
import org.apache.isis.core.commons.resource.ResourceStreamSourceContextLoaderClassPath;
import org.apache.isis.core.commons.resource.ResourceStreamSourceCurrentClassClassPath;
import org.apache.isis.core.commons.resource.ResourceStreamSourceFileSystem;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.runner.IsisInjectModule;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerInitParameters;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.IsisSystem;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.webapp.IsisWebAppBootstrapperUtil;
import org.apache.isis.core.webapp.config.ResourceStreamSourceForWebInf;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.string.MultiLineStringPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2BootstrapCssReference;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2JsReference;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.viewer.IsisWicketModule;
import org.apache.isis.viewer.wicket.viewer.integration.isis.DeploymentTypeWicketAbstract;
import org.apache.isis.viewer.wicket.viewer.integration.isis.WicketServer;
import org.apache.isis.viewer.wicket.viewer.integration.isis.WicketServerPrototype;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.AuthenticatedWebSessionForIsis;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.ConverterForObjectAdapter;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.ConverterForObjectAdapterMemento;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.WebRequestCycleForIsis;
import org.apache.isis.viewer.wicket.viewer.settings.IsisResourceSettings;
import org.apache.wicket.Application;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.SharedResources;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.core.request.mapper.MountedMapper;
import org.apache.wicket.guice.GuiceComponentInjector;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.filter.JavaScriptFilteredIntoFooterHeaderResponse;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.PageRequestHandlerTracker;
import org.apache.wicket.request.cycle.RequestCycleListenerCollection;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisWicketApplication
extends AuthenticatedWebApplication
implements ComponentFactoryRegistryAccessor,
PageClassRegistryAccessor,
AuthenticationSessionProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IsisWicketApplication.class);
    private static final String STRIP_WICKET_TAGS_KEY = "isis.viewer.wicket.stripWicketTags";
    private static final boolean STRIP_WICKET_TAGS_DEFAULT = true;
    private static final String AJAX_DEBUG_MODE_KEY = "isis.viewer.wicket.ajaxDebugMode";
    private static final boolean AJAX_DEBUG_MODE_DEFAULT = false;
    private final IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer();
    @Inject
    private ComponentFactoryRegistry componentFactoryRegistry;
    @Inject
    private ImageResourceCache imageCache;
    @Inject
    private WicketViewerSettings wicketViewerSettings;
    @Inject
    private PageClassRegistry pageClassRegistry;
    @Inject
    private IsisSystem system;
    private boolean determiningDeploymentType;
    private DeploymentTypeWicketAbstract deploymentType;
    private final List<String> validationErrors = Lists.newArrayList();
    protected static final Function<ComponentFactory, Iterable<CssResourceReference>> getCssResourceReferences = new Function<ComponentFactory, Iterable<CssResourceReference>>(){

        public Iterable<CssResourceReference> apply(ComponentFactory input) {
            CssResourceReference cssResourceReference = input.getCssResourceReference();
            return cssResourceReference != null ? Collections.singletonList(cssResourceReference) : Collections.emptyList();
        }
    };

    public static IsisWicketApplication get() {
        return (IsisWicketApplication)AuthenticatedWebApplication.get();
    }

    protected void internalInit() {
        this.setResourceSettings((IResourceSettings)new IsisResourceSettings((Application)this));
        super.internalInit();
    }

    protected void init() {
        try {
            super.init();
            this.configureWebJars();
            this.configureWicketBootstrap();
            this.configureWicketSelect2();
            String isisConfigDir = this.getServletContext().getInitParameter("isis.config.dir");
            this.configureLogging(isisConfigDir);
            this.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.RenderStrategy.REDIRECT_TO_RENDER);
            this.getResourceSettings().setParentFolderPlaceholder("$up$");
            this.determineDeploymentTypeIfRequired();
            RequestCycleListenerCollection requestCycleListeners = this.getRequestCycleListeners();
            IRequestCycleListener requestCycleListenerForIsis = this.newWebRequestCycleForIsis();
            requestCycleListeners.add((Object)requestCycleListenerForIsis);
            requestCycleListeners.add((Object)new PageRequestHandlerTracker());
            IsisConfigurationBuilder isisConfigurationBuilder = this.createConfigBuilder();
            IsisInjectModule isisModule = this.newIsisModule(this.deploymentType, isisConfigurationBuilder);
            Injector injector = Guice.createInjector((Module[])new Module[]{isisModule, this.newIsisWicketModule()});
            this.initWicketComponentInjection(injector);
            injector.injectMembers((Object)this);
            if (requestCycleListenerForIsis instanceof WebRequestCycleForIsis) {
                WebRequestCycleForIsis webRequestCycleForIsis = (WebRequestCycleForIsis)requestCycleListenerForIsis;
                webRequestCycleForIsis.setPageClassRegistry(this.pageClassRegistry);
            }
            IsisConfiguration configuration = isisConfigurationBuilder.getConfiguration();
            this.getMarkupSettings().setStripWicketTags(this.determineStripWicketTags(configuration));
            this.getDebugSettings().setAjaxDebugModeEnabled(this.determineAjaxDebugModeEnabled(configuration));
            this.buildCssBundle();
            this.filterJavascriptContributions();
            this.configureWicketSourcePlugin();
            int maxEntries = 1000;
            this.setMetaData(AccountConfirmationMap.KEY, new AccountConfirmationMap(maxEntries, Duration.days((int)1)));
            this.mountPages();
            SharedResources sharedResources = this.getSharedResources();
        }
        catch (RuntimeException ex) {
            List<MetaModelInvalidException> mmies = this.locateMetaModelInvalidExceptions(ex);
            if (!mmies.isEmpty()) {
                MetaModelInvalidException mmie = mmies.get(0);
                IsisWicketApplication.log("");
                IsisWicketApplication.logBanner();
                IsisWicketApplication.log("");
                this.validationErrors.addAll(mmie.getValidationErrors());
                for (String validationError : this.validationErrors) {
                    this.logError(validationError);
                }
                IsisWicketApplication.log("");
                IsisWicketApplication.log("Please inspect the above messages and correct your domain model.");
                IsisWicketApplication.log("");
                IsisWicketApplication.logBanner();
                IsisWicketApplication.log("");
            }
            LOG.error("Failed to initialize", (Throwable)ex);
            throw ex;
        }
    }

    private void configureWicketSelect2() {
        ApplicationSettings select2Settings = ApplicationSettings.get();
        select2Settings.setCssReference((ResourceReference)new Select2BootstrapCssReference());
        select2Settings.setJavaScriptReference((ResourceReference)new Select2JsReference());
        select2Settings.setIncludeJqueryUI(false);
    }

    private void configureWicketSourcePlugin() {
        if (!this.deploymentType.isProduction()) {
            WicketSource.configure((Application)this);
        }
    }

    protected void configureWebJars() {
        WebjarsSettings settings = new WebjarsSettings();
        WicketWebjars.install((WebApplication)this, (IWebjarsSettings)settings);
    }

    protected void configureWicketBootstrap() {
        BootstrapSettings settings = new BootstrapSettings();
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        this.getHeaderContributorListenerCollection().add((Object)new IHeaderContributor((IBootstrapSettings)settings){
            final /* synthetic */ IBootstrapSettings val$settings;
            {
                this.val$settings = iBootstrapSettings;
            }

            public void renderHead(IHeaderResponse response) {
                BootstrapBaseBehavior bootstrapBaseBehavior = new BootstrapBaseBehavior();
                bootstrapBaseBehavior.renderHead(this.val$settings, response);
            }
        });
    }

    protected void configureLogging(String isisConfigDir) {
        String loggingPropertiesDir = isisConfigDir != null ? isisConfigDir : this.getServletContext().getRealPath("/WEB-INF");
        this.loggingConfigurer.configureLogging(loggingPropertiesDir, new String[0]);
    }

    protected IRequestCycleListener newWebRequestCycleForIsis() {
        return new WebRequestCycleForIsis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineDeploymentTypeIfRequired() {
        if (this.deploymentType != null) {
            return;
        }
        this.determiningDeploymentType = true;
        try {
            IsisConfigurationBuilder isisConfigurationBuilder = this.createConfigBuilder();
            IsisConfiguration configuration = isisConfigurationBuilder.getConfiguration();
            String deploymentTypeFromConfig = configuration.getString("isis.deploymentType");
            this.deploymentType = this.determineDeploymentType(deploymentTypeFromConfig);
        }
        finally {
            this.determiningDeploymentType = false;
        }
    }

    protected DeploymentTypeWicketAbstract determineDeploymentType(String deploymentTypeFromConfig) {
        WicketServerPrototype prototype = new WicketServerPrototype();
        WicketServer deployment = new WicketServer();
        if (deploymentTypeFromConfig != null) {
            DeploymentType deploymentType = DeploymentType.lookup((String)deploymentTypeFromConfig);
            return !deploymentType.getDeploymentCategory().isProduction() ? prototype : deployment;
        }
        return this.usesDevelopmentConfig() ? prototype : deployment;
    }

    private IsisConfigurationBuilder createConfigBuilder() {
        return this.createConfigBuilder(this.getServletContext());
    }

    protected IsisConfigurationBuilder createConfigBuilder(ServletContext servletContext) {
        String configLocation = servletContext.getInitParameter("isis.config.dir");
        ResourceStreamSourceForWebInf rssWebInf = new ResourceStreamSourceForWebInf(servletContext);
        ResourceStreamSourceContextLoaderClassPath rssContextLoaderClassPath = ResourceStreamSourceContextLoaderClassPath.create();
        ResourceStreamSourceCurrentClassClassPath rssCurrentClassPath = new ResourceStreamSourceCurrentClassClassPath();
        ResourceStreamSourceComposite compositeSource = new ResourceStreamSourceComposite(new ResourceStreamSource[]{rssWebInf, rssContextLoaderClassPath, rssCurrentClassPath});
        if (configLocation != null) {
            LOG.info("Config override location: " + configLocation);
            compositeSource.addResourceStreamSource(ResourceStreamSourceFileSystem.create((String)configLocation));
        } else {
            LOG.info("Config override location: No override location configured!");
        }
        IsisConfigurationBuilderResourceStreams configurationBuilder = new IsisConfigurationBuilderResourceStreams((ResourceStreamSource)compositeSource);
        IsisWicketApplication.primeConfigurationBuilder((IsisConfigurationBuilder)configurationBuilder, servletContext);
        configurationBuilder.addDefaultConfigurationResources();
        IsisWebAppBootstrapperUtil.addConfigurationResourcesForViewers((IsisConfigurationBuilder)configurationBuilder, (ServletContext)servletContext);
        return configurationBuilder;
    }

    private static void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder, ServletContext servletContext) {
        LOG.info("loading properties from option handlers");
        ArrayList isisConfigurationBuilderPrimers = Lists.newArrayList();
        List primers = (List)servletContext.getAttribute("isis.configurationPrimers");
        if (primers != null) {
            isisConfigurationBuilderPrimers.addAll(primers);
        }
        isisConfigurationBuilderPrimers.add(new OptionHandlerInitParameters(servletContext));
        for (IsisConfigurationBuilderPrimer isisConfigurationBuilderPrimer : isisConfigurationBuilderPrimers) {
            LOG.info("priming configurations for " + isisConfigurationBuilderPrimer);
            isisConfigurationBuilderPrimer.primeConfigurationBuilder(isisConfigurationBuilder);
        }
    }

    protected Module newIsisWicketModule() {
        return new IsisWicketModule();
    }

    protected void buildCssBundle() {
        Set<CssResourceReference> references = this.cssResourceReferencesForAllComponents();
        this.addSpecialCasesToCssBundle(references);
        this.getResourceBundles().addCssBundle(IsisWicketApplication.class, "isis-wicket-viewer-bundle.css", references.toArray(new CssResourceReference[0]));
    }

    protected void addSpecialCasesToCssBundle(Set<CssResourceReference> references) {
        references.add(PanelUtil.cssResourceReferenceFor(AdditionalLinksPanel.class));
        references.add(PanelUtil.cssResourceReferenceFor(MultiLineStringPanel.class));
    }

    protected Set<CssResourceReference> cssResourceReferencesForAllComponents() {
        return Sets.newLinkedHashSet();
    }

    protected void filterJavascriptContributions() {
        this.setHeaderResponseDecorator(new IHeaderResponseDecorator(){

            public IHeaderResponse decorate(IHeaderResponse response) {
                return new JavaScriptFilteredIntoFooterHeaderResponse(response, "footerJS");
            }
        });
    }

    protected void mountPages() {
        this.mountPage("/signin", PageType.SIGN_IN);
        this.mountPage("/signup", PageType.SIGN_UP);
        this.mountPage("/signup/verify", PageType.SIGN_UP_VERIFY);
        this.mountPage("/password/reset", PageType.PASSWORD_RESET);
        this.mountPage("/entity/#{objectOid}", PageType.ENTITY);
        this.mountPage("/action/${objectOid}/${actionOwningSpec}/${actionId}/${actionType}", PageType.ACTION_PROMPT);
    }

    protected void mountPage(String mountPath, PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        this.mount((IRequestMapper)new MountedMapper(mountPath, pageClass));
    }

    protected List<MetaModelInvalidException> locateMetaModelInvalidExceptions(RuntimeException ex) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)ex), MetaModelInvalidException.class));
    }

    public List<String> getValidationErrors() {
        return this.validationErrors;
    }

    private void logError(String validationError) {
        IsisWicketApplication.log(validationError);
    }

    private static void logBanner() {
        String msg = "################################################ ISIS METAMODEL VALIDATION ERRORS ################################################################";
        IsisWicketApplication.log(msg);
    }

    private static void log(String msg) {
        System.err.println(msg);
        LOG.error(msg);
    }

    private boolean determineStripWicketTags(IsisConfiguration configuration) {
        boolean strip = configuration.getBoolean(STRIP_WICKET_TAGS_KEY, true);
        return strip;
    }

    private boolean determineAjaxDebugModeEnabled(IsisConfiguration configuration) {
        boolean debugMode = configuration.getBoolean(AJAX_DEBUG_MODE_KEY, false);
        return debugMode;
    }

    protected void onDestroy() {
        try {
            if (this.system != null) {
                this.system.shutdown();
            }
            IsisContext.shutdown();
            super.onDestroy();
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to destroy", (Throwable)ex);
            throw ex;
        }
    }

    public RuntimeConfigurationType getConfigurationType() {
        if (this.determiningDeploymentType) {
            return super.getConfigurationType();
        }
        this.determineDeploymentTypeIfRequired();
        return this.deploymentType.getConfigurationType();
    }

    protected IsisInjectModule newIsisModule(DeploymentType deploymentType, IsisConfigurationBuilder isisConfigurationBuilder) {
        return new IsisInjectModule(deploymentType, isisConfigurationBuilder);
    }

    protected void initWicketComponentInjection(Injector injector) {
        this.getComponentInstantiationListeners().add((Object)new GuiceComponentInjector((Application)this, injector, false));
    }

    protected Class<? extends AuthenticatedWebSession> getWebSessionClass() {
        return AuthenticatedWebSessionForIsis.class;
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator converterLocator = new ConverterLocator();
        converterLocator.set(ObjectAdapter.class, (IConverter)new ConverterForObjectAdapter());
        converterLocator.set(ObjectAdapterMemento.class, (IConverter)new ConverterForObjectAdapterMemento());
        return converterLocator;
    }

    public final ComponentFactoryRegistry getComponentFactoryRegistry() {
        return this.componentFactoryRegistry;
    }

    public PageClassRegistry getPageClassRegistry() {
        return this.pageClassRegistry;
    }

    public Class<? extends Page> getHomePage() {
        return this.getPageClassRegistry().getPageClass(PageType.HOME);
    }

    public Class<? extends WebPage> getSignInPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_IN);
    }

    public Class<? extends WebPage> getSignUpPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_UP);
    }

    public Class<? extends WebPage> getSignUpVerifyPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_UP_VERIFY);
    }

    public Class<? extends WebPage> getForgotPasswordPageClass() {
        return this.getPageClassRegistry().getPageClass(PageType.PASSWORD_RESET);
    }

    public AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    public void injectInto(Object candidate) {
        if (AuthenticationSessionProviderAware.class.isAssignableFrom(candidate.getClass())) {
            AuthenticationSessionProviderAware cast = (AuthenticationSessionProviderAware)AuthenticationSessionProviderAware.class.cast(candidate);
            cast.setAuthenticationSessionProvider((AuthenticationSessionProvider)this);
        }
    }
}

