/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Content;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContentResponseHandler
implements ResponseHandler<Content> {
    ContentResponseHandler() {
    }

    public Content handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (entity != null) {
            return new Content(EntityUtils.toByteArray((HttpEntity)entity), ContentType.getOrDefault((HttpEntity)entity));
        }
        return Content.NO_CONTENT;
    }
}

