/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import org.apache.hadoop.tools.rumen.CDFPiecewiseLinearRandomGenerator;
import org.apache.hadoop.tools.rumen.Histogram;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedSingleRelativeRanking;
import org.junit.Assert;
import org.junit.Test;

public class TestPiecewiseLinearInterpolation {
    private static double maximumRelativeError = 0.002;

    private static LoggedSingleRelativeRanking makeRR(double ranking, long datum) {
        LoggedSingleRelativeRanking result = new LoggedSingleRelativeRanking();
        result.setDatum(datum);
        result.setRelativeRanking(ranking);
        return result;
    }

    @Test
    public void testOneRun() {
        long error;
        int i;
        LoggedDiscreteCDF input = new LoggedDiscreteCDF();
        input.setMinimum(100000L);
        input.setMaximum(1100000L);
        ArrayList<LoggedSingleRelativeRanking> rankings = new ArrayList<LoggedSingleRelativeRanking>();
        rankings.add(TestPiecewiseLinearInterpolation.makeRR(0.1, 200000L));
        rankings.add(TestPiecewiseLinearInterpolation.makeRR(0.5, 800000L));
        rankings.add(TestPiecewiseLinearInterpolation.makeRR(0.9, 1000000L));
        input.setRankings(rankings);
        input.setNumberValues(3L);
        CDFPiecewiseLinearRandomGenerator gen = new CDFPiecewiseLinearRandomGenerator(input);
        Histogram values = new Histogram();
        for (int i2 = 0; i2 < 1000000; ++i2) {
            long value = gen.randomValue();
            values.enter(value);
        }
        int[] percentiles = new int[99];
        for (int i3 = 0; i3 < 99; ++i3) {
            percentiles[i3] = i3 + 1;
        }
        long[] result = values.getCDF(100, percentiles);
        long sumErrorSquares = 0L;
        for (i = 0; i < 10; ++i) {
            error = result[i] - (10000L * (long)i + 100000L);
            System.out.println("element " + i + ", got " + result[i] + ", expected " + (10000L * (long)i + 100000L) + ", error = " + error);
            sumErrorSquares += error * error;
        }
        for (i = 10; i < 50; ++i) {
            error = result[i] - (15000L * (long)i + 50000L);
            System.out.println("element " + i + ", got " + result[i] + ", expected " + (15000L * (long)i + 50000L) + ", error = " + error);
            sumErrorSquares += error * error;
        }
        for (i = 50; i < 90; ++i) {
            error = result[i] - (5000L * (long)i + 550000L);
            System.out.println("element " + i + ", got " + result[i] + ", expected " + (5000L * (long)i + 550000L) + ", error = " + error);
            sumErrorSquares += error * error;
        }
        for (i = 90; i <= 100; ++i) {
            error = result[i] - (10000L * (long)i + 100000L);
            System.out.println("element " + i + ", got " + result[i] + ", expected " + (10000L * (long)i + 100000L) + ", error = " + error);
            sumErrorSquares += error * error;
        }
        double realSumErrorSquares = sumErrorSquares;
        double normalizedError = realSumErrorSquares / 100.0 / (double)((LoggedSingleRelativeRanking)rankings.get(1)).getDatum() / (double)((LoggedSingleRelativeRanking)rankings.get(1)).getDatum();
        double RMSNormalizedError = Math.sqrt(normalizedError);
        System.out.println("sumErrorSquares = " + sumErrorSquares);
        System.out.println("normalizedError: " + normalizedError + ", RMSNormalizedError: " + RMSNormalizedError);
        System.out.println("Cumulative error is " + RMSNormalizedError);
        Assert.assertTrue((String)("The RMS relative error per bucket, " + RMSNormalizedError + ", exceeds our tolerance of " + maximumRelativeError), (RMSNormalizedError <= maximumRelativeError ? 1 : 0) != 0);
    }
}

