/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestParsedLine {
    static final char[] CHARS_TO_ESCAPE = new char[]{'=', '\"', '.'};

    String buildLine(String type, String[] kvseq) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        for (int i = 0; i < kvseq.length; ++i) {
            sb.append(" ");
            if (kvseq[i].equals(".") || kvseq[i].equals("\n")) {
                sb.append(kvseq[i]);
                continue;
            }
            if (i == kvseq.length - 1) {
                Assert.fail((String)"Incorrect input, expecting value.");
            }
            sb.append(kvseq[i++]);
            sb.append("=\"");
            sb.append(StringUtils.escapeString((String)kvseq[i], (char)'\\', (char[])CHARS_TO_ESCAPE));
            sb.append("\"");
        }
        return sb.toString();
    }

    void testOneLine(String type, String ... kvseq) {
        String line = this.buildLine(type, kvseq);
        ParsedLine pl = new ParsedLine(line, 1);
        Assert.assertEquals((String)"Mismatching type", (Object)type, (Object)pl.getType().toString());
        for (int i = 0; i < kvseq.length; ++i) {
            if (kvseq[i].equals(".") || kvseq[i].equals("\n")) continue;
            Assert.assertEquals((String)("Key mismatching for " + kvseq[i]), (Object)kvseq[i + 1], (Object)StringUtils.unEscapeString((String)pl.get(kvseq[i]), (char)'\\', (char[])CHARS_TO_ESCAPE));
            ++i;
        }
    }

    @Test
    public void testEscapedQuote() {
        this.testOneLine("REC", "A", "x", "B", "abc\"de", "C", "f");
        this.testOneLine("REC", "B", "abcde\"", "C", "f");
        this.testOneLine("REC", "A", "x", "B", "\"abcde");
    }

    @Test
    public void testEqualSign() {
        this.testOneLine("REC1", "A", "x", "B", "abc=de", "C", "f");
        this.testOneLine("REC2", "B", "=abcde", "C", "f");
        this.testOneLine("REC3", "A", "x", "B", "abcde=");
    }

    @Test
    public void testSpace() {
        this.testOneLine("REC1", "A", "x", "B", "abc de", "C", "f");
        this.testOneLine("REC2", "B", " ab c de", "C", "f");
        this.testOneLine("REC3", "A", "x", "B", "abc\t  de  ");
    }

    @Test
    public void testBackSlash() {
        this.testOneLine("REC1", "A", "x", "B", "abc\\de", "C", "f");
        this.testOneLine("REC2", "B", "\\ab\\c\\de", "C", "f");
        this.testOneLine("REC3", "A", "x", "B", "abc\\\\de\\");
        this.testOneLine("REC4", "A", "x", "B", "abc\\\"de\\\"", "C", "f");
    }

    @Test
    public void testLineDelimiter() {
        this.testOneLine("REC1", "A", "x", "B", "abc.de", "C", "f");
        this.testOneLine("REC2", "B", ".ab.de");
        this.testOneLine("REC3", "A", "x", "B", "abc.de.");
        this.testOneLine("REC4", "A", "x", "B", "abc.de", ".");
    }

    @Test
    public void testMultipleLines() {
        this.testOneLine("REC1", "A", "x", "\n", "B", "abc.de", "\n", "C", "f", "\n", ".");
    }
}

