/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.Histogram;
import org.apache.hadoop.tools.rumen.HistogramRawTestData;
import org.apache.hadoop.tools.rumen.JsonObjectMapperParser;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.TreePath;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class TestHistograms {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHistograms() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootInputFile = new Path(rootInputDir, "rumen/histogram-tests");
        FileStatus[] tests = lfs.listStatus(rootInputFile);
        for (int i = 0; i < tests.length; ++i) {
            Path filePath = tests[i].getPath();
            String fileName = filePath.getName();
            if (!fileName.startsWith("input")) continue;
            String testName = fileName.substring("input".length());
            Path goldFilePath = new Path(rootInputFile, "gold" + testName);
            Assert.assertTrue((String)"Gold file dies not exist", (boolean)lfs.exists(goldFilePath));
            LoggedDiscreteCDF newResult = TestHistograms.histogramFileToCDF(filePath, (FileSystem)lfs);
            System.out.println("Testing a Histogram for " + fileName);
            FSDataInputStream goldStream = lfs.open(goldFilePath);
            JsonObjectMapperParser parser = new JsonObjectMapperParser((InputStream)goldStream, LoggedDiscreteCDF.class);
            try {
                LoggedDiscreteCDF dcdf = (LoggedDiscreteCDF)parser.getNext();
                dcdf.deepCompare((DeepCompare)newResult, new TreePath(null, "<root>"));
                continue;
            }
            catch (DeepInequalityException e) {
                Assert.fail((String)e.path.toString());
                continue;
            }
            finally {
                parser.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoggedDiscreteCDF histogramFileToCDF(Path path, FileSystem fs) throws IOException {
        HistogramRawTestData data;
        FSDataInputStream dataStream = fs.open(path);
        JsonObjectMapperParser parser = new JsonObjectMapperParser((InputStream)dataStream, HistogramRawTestData.class);
        try {
            data = (HistogramRawTestData)parser.getNext();
        }
        finally {
            parser.close();
        }
        Histogram hist = new Histogram();
        List<Long> measurements = data.getData();
        List<Long> typeProbeData = new HistogramRawTestData().getData();
        Assert.assertTrue((String)("The data attribute of a jackson-reconstructed HistogramRawTestData  should be a " + typeProbeData.getClass().getName() + ", like a virgin HistogramRawTestData, but it's a " + measurements.getClass().getName()), (measurements.getClass() == typeProbeData.getClass() ? 1 : 0) != 0);
        for (int j = 0; j < measurements.size(); ++j) {
            hist.enter(measurements.get(j).longValue());
        }
        LoggedDiscreteCDF result = new LoggedDiscreteCDF();
        int[] percentiles = new int[data.getPercentiles().size()];
        for (int j = 0; j < data.getPercentiles().size(); ++j) {
            percentiles[j] = data.getPercentiles().get(j);
        }
        result.setCDF(hist, percentiles, data.getScale());
        return result;
    }

    public static void main(String[] args) throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        for (String arg : args) {
            Path filePath = new Path(arg).makeQualified((FileSystem)lfs);
            String fileName = filePath.getName();
            if (fileName.startsWith("input")) {
                LoggedDiscreteCDF newResult = TestHistograms.histogramFileToCDF(filePath, (FileSystem)lfs);
                String testName = fileName.substring("input".length());
                Path goldFilePath = new Path(filePath.getParent(), "gold" + testName);
                ObjectMapper mapper = new ObjectMapper();
                JsonFactory factory = mapper.getJsonFactory();
                FSDataOutputStream ostream = lfs.create(goldFilePath, true);
                JsonGenerator gen = factory.createJsonGenerator((OutputStream)ostream, JsonEncoding.UTF8);
                gen.useDefaultPrettyPrinter();
                gen.writeObject((Object)newResult);
                gen.close();
                continue;
            }
            System.err.println("Input file not started with \"input\". File " + fileName + " skipped.");
        }
    }
}

