/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.net.NetUtils;

public class NetUtilsTestResolver
extends NetUtils.QualifiedHostResolver {
    Map<String, InetAddress> resolvedHosts = new HashMap<String, InetAddress>();
    List<String> hostSearches = new LinkedList<String>();

    public static NetUtilsTestResolver install() {
        NetUtilsTestResolver resolver = new NetUtilsTestResolver();
        resolver.setSearchDomains(new String[]{"a.b", "b", "c"});
        resolver.addResolvedHost("host.a.b.", "1.1.1.1");
        resolver.addResolvedHost("b-host.b.", "2.2.2.2");
        resolver.addResolvedHost("simple.", "3.3.3.3");
        NetUtils.setHostResolver((NetUtils.HostResolver)resolver);
        return resolver;
    }

    public void addResolvedHost(String host, String ip) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(ip);
            addr = InetAddress.getByAddress(host, addr.getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("not an ip:" + ip);
        }
        this.resolvedHosts.put(host, addr);
    }

    InetAddress getInetAddressByName(String host) throws UnknownHostException {
        this.hostSearches.add(host);
        if (!this.resolvedHosts.containsKey(host)) {
            throw new UnknownHostException(host);
        }
        return this.resolvedHosts.get(host);
    }

    String[] getHostSearches() {
        return this.hostSearches.toArray(new String[0]);
    }

    void reset() {
        this.hostSearches.clear();
    }
}

